/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.BaseService;
import com.wego168.share.component.DistributeWxMsgTemplateTask;
import com.wego168.share.domain.Bonus;
import com.wego168.share.domain.BonusFlow;
import com.wego168.share.domain.BonusWithdraw;
import com.wego168.share.domain.BonusWithdrawProgress;
import com.wego168.share.enums.BonusFlowStatusEnum;
import com.wego168.share.enums.BonusFlowTypeEnum;
import com.wego168.share.enums.BonusWithdrawStatus;
import com.wego168.share.handler.BonusWithdrawNotifyHandler;
import com.wego168.share.persistence.BonusWithdrawMapper;
import com.wego168.share.service.BonusFlowService;
import com.wego168.share.service.BonusService;
import com.wego168.share.service.BonusWithdrawProgressService;
import com.wego168.util.InterfaceDispatcher;
import com.wego168.web.util.GuidGenerator;
import com.wego168.wxpay.service.PayService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BonusWithdrawService
extends BaseService<BonusWithdraw> {
    private static Logger logger = LoggerFactory.getLogger(BonusWithdrawService.class);
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat ORDER_NO_DATE_FORMAT = new SimpleDateFormat("yyMMdd");
    @Autowired
    private BonusWithdrawMapper mapper;
    @Autowired
    private BonusWithdrawProgressService bonusWithdrawProgressService;
    @Autowired
    private BonusService bonusService;
    @Autowired
    private BonusFlowService bonusFlowService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private PayService payService;
    @Autowired
    private DistributeWxMsgTemplateTask distributeWxMsgTemplateTask;

    public CrudMapper<BonusWithdraw> getMapper() {
        return this.mapper;
    }

    public String getOrderNo() {
        String dateStr = ORDER_NO_DATE_FORMAT.format(new Date());
        String key = "bonus_withdraw_" + dateStr;
        String orderNo = StringUtils.leftPad((String)String.valueOf(this.simpleRedisTemplate.incr(key)), (int)8, (String)"0");
        logger.info("\u751f\u6210\u63d0\u73b0\u5355\u53f7\uff0corderNo\uff1a{}", (Object)orderNo);
        return String.valueOf(dateStr) + orderNo + RandomStringUtils.random((int)3, (boolean)false, (boolean)true);
    }

    public List<BonusWithdraw> page(Page page) {
        return this.mapper.page(page);
    }

    @Transactional
    public int apply(BonusWithdraw withdraw) {
        withdraw.setOrderNo(this.getOrderNo());
        if (withdraw.getStatus() == null) {
            withdraw.setStatus(BonusWithdrawStatus.APPLY.id);
        }
        super.insert((Object)withdraw);
        BonusWithdrawProgress bonusWithdrawProgress = this.bonusWithdrawProgressService.buildBonusWithdrawProgress(withdraw.getId(), withdraw.getMemberId(), withdraw.getStatus(), null);
        int rs = this.bonusWithdrawProgressService.insert(bonusWithdrawProgress);
        List<Bonus> bonusList = this.bonusService.selectListForWithdraw(withdraw.getMemberId());
        Bonus bonus = bonusList.get(0);
        String storeId = bonus.getStoreId();
        int applyAmount = withdraw.getAmount() + withdraw.getFeeAmount();
        LinkedList<BonusFlow> flowList = new LinkedList<BonusFlow>();
        BonusFlow flow = new BonusFlow();
        flow.setId(GuidGenerator.generate());
        flow.setCreateTime(new Date());
        flow.setAppId(withdraw.getAppId());
        flow.setStoreId(bonus.getStoreId());
        flow.setIsDeleted(false);
        flow.setAmount(-withdraw.getAmount().intValue());
        flow.setBalanceAmount(bonus.getAmount() - withdraw.getAmount());
        flow.setOrderId(withdraw.getId());
        flow.setOrderAmount(0);
        flow.setType(BonusFlowTypeEnum.WITHDRAW.id());
        flow.setLevel(0);
        flow.setMemberId(withdraw.getMemberId());
        flow.setDetail("\u63d0\u73b0");
        flow.setStatus(BonusFlowStatusEnum.SUCCESS.id());
        flow.setAwardTime(new Date());
        flowList.add(flow);
        BonusFlow feeFlow = new BonusFlow();
        BeanUtils.copyProperties((Object)((Object)flow), (Object)((Object)feeFlow));
        feeFlow.setId(GuidGenerator.generate());
        feeFlow.setAmount(-withdraw.getFeeAmount().intValue());
        feeFlow.setDetail("\u63d0\u73b0\u624b\u7eed\u8d39");
        feeFlow.setBalanceAmount(flow.getBalanceAmount() - withdraw.getFeeAmount());
        flowList.add(feeFlow);
        this.bonusFlowService.insertBatch(flowList);
        this.bonusService.updateAddAmount(-applyAmount, storeId, withdraw.getMemberId());
        this.bonusService.updateAddAmount(-applyAmount, "0", withdraw.getMemberId());
        return rs;
    }

    @Transactional
    public int audit(String bonusWithdrawId, String operator, Integer status, String remarks) {
        BonusWithdrawProgress bonusWithdrawProgress = this.bonusWithdrawProgressService.buildBonusWithdrawProgress(bonusWithdrawId, operator, status, remarks);
        this.bonusWithdrawProgressService.insert(bonusWithdrawProgress);
        JpaCriteria jpaCriteria = JpaCriteria.builder().set("status", (Object)status).set("updateTime", (Object)new Date()).eq("id", (Object)bonusWithdrawId).eq("status", (Object)BonusWithdrawStatus.APPLY.id);
        return this.mapper.updateSelective(jpaCriteria);
    }

    @Transactional
    public int auditPass(String bonusWithdrawId, String operator, String remarks) {
        return this.audit(bonusWithdrawId, operator, BonusWithdrawStatus.PAYING.id, remarks);
    }

    @Transactional
    public int auditNotPass(String bonusWithdrawId, String operator, String remarks) {
        this.bonusService.withdrawRollBack(bonusWithdrawId);
        return this.audit(bonusWithdrawId, operator, BonusWithdrawStatus.REJECT.id, remarks);
    }

    @Transactional
    public int cancel(String bonusWithdrawId, String operator, Integer status, String remarks) {
        int rs = this.audit(bonusWithdrawId, operator, status, remarks);
        if (BonusWithdrawStatus.REJECT.id != status) {
            this.bonusService.withdrawRollBack(bonusWithdrawId);
        }
        return rs;
    }

    @Transactional
    public int doAfterTransfer(BonusWithdraw bonusWithdraw) {
        String id = bonusWithdraw.getId();
        int status = bonusWithdraw.getStatus();
        String operator = bonusWithdraw.getOperator();
        String remarks = bonusWithdraw.getRemarks();
        BonusWithdrawProgress bonusWithdrawProgress = this.bonusWithdrawProgressService.buildBonusWithdrawProgress(id, operator, status, remarks);
        this.bonusWithdrawProgressService.insert(bonusWithdrawProgress);
        int row = super.update((Object)bonusWithdraw);
        if (bonusWithdraw.getStatus() == BonusWithdrawStatus.FAIL.id) {
            this.bonusFlowService.cancelByOrderId(bonusWithdraw.getId());
        }
        return row;
    }

    @Transactional
    public int finishAfterTransfer(BonusWithdraw bonusWithdraw) {
        String id = bonusWithdraw.getId();
        int status = bonusWithdraw.getStatus();
        String operator = bonusWithdraw.getOperator();
        String remark = BonusWithdrawStatus.getDesc(status);
        BonusWithdrawProgress bonusWithdrawProgress = this.bonusWithdrawProgressService.buildBonusWithdrawProgress(id, operator, status, remark);
        this.bonusWithdrawProgressService.insert(bonusWithdrawProgress);
        int row = this.mapper.update((Object)bonusWithdraw);
        if (bonusWithdraw.getStatus() == BonusWithdrawStatus.FAIL.id) {
            this.bonusFlowService.cancelByOrderId(bonusWithdraw.getId());
        }
        InterfaceDispatcher.builder().collect(BonusWithdrawNotifyHandler.class).forEach(e -> e.doAfterTransfer(bonusWithdraw));
        if (row == 1) {
            this.distributeWxMsgTemplateTask.sendBonusWithdrawMsg(bonusWithdraw);
        }
        return row;
    }

    public int sumTotalWithdrawAmount(String memberId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().select("sum(amount)").eq("memberId", (Object)memberId).eq("isDeleted", (Object)false).ge("status", (Object)BonusWithdrawStatus.APPLY.id);
        Integer rs = (Integer)super.select(jpaCriteria, Integer.class);
        return rs == null ? 0 : rs;
    }

    public List<BonusWithdraw> selectPayingListForTransfer() {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("isDeleted", (Object)false).eq("status", (Object)BonusWithdrawStatus.PAYING.id);
        return this.mapper.selectList(jpaCriteria);
    }

    public List<BonusWithdraw> selectApplyListForTransfer() {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("isDeleted", (Object)false).eq("status", (Object)BonusWithdrawStatus.APPLY.id);
        return this.mapper.selectList(jpaCriteria);
    }

    @Transactional
    public void withdrawRollBack(BonusWithdraw bonusWithdraw) {
        super.update((Object)bonusWithdraw);
        this.bonusService.withdrawRollBack(bonusWithdraw.getId());
    }

    @Transactional
    public int applyByManual(BonusWithdraw withdraw, BonusWithdraw dbBonusWithdraw) {
        int rows = this.apply(withdraw);
        if (dbBonusWithdraw != null) {
            dbBonusWithdraw.setWithdrawId(withdraw.getId());
            this.update((Object)dbBonusWithdraw);
        }
        InterfaceDispatcher.builder().collect(BonusWithdrawNotifyHandler.class).forEach(e -> e.doAfterTransfer(withdraw));
        return rows;
    }
}

