/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.BaseService;
import com.wego168.service.InitializingBeanHandler;
import com.wego168.share.domain.DistributeConfig;
import com.wego168.share.persistence.DistributeConfigMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.stereotype.Service;

@Service
public class DistributeConfigService
extends BaseService<DistributeConfig>
implements InitializingBeanHandler {
    @Autowired
    private DistributeConfigMapper mapper;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;

    public CrudMapper<DistributeConfig> getMapper() {
        return this.mapper;
    }

    public int insert(DistributeConfig config) {
        return super.insert((Object)config);
    }

    public int update(DistributeConfig config) {
        return super.update((Object)config);
    }

    public DistributeConfig selectByAppId(String appId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("appId", (Object)appId).eq("isDeleted", (Object)false);
        return (DistributeConfig)((Object)this.mapper.select(criteria));
    }

    public double getShareRate(String appId, int level) {
        DistributeConfig config = this.getConfig(appId);
        if (level == 1) {
            return config.getShareLevelRate1();
        }
        if (level == 2) {
            return config.getShareLevelRate2();
        }
        if (level == 3) {
            return config.getShareLevelRate3();
        }
        return 0.0;
    }

    public DistributeConfig getConfig(String appId) {
        DistributeConfig config = this.getCache(appId);
        return config == null ? this.initDistributeConfig(appId) : config;
    }

    public void invoking() {
        try {
            List lists = this.mapper.selectList(JpaCriteria.builder().eq("isDeleted", (Object)false));
            if (lists != null && lists.size() > 0) {
                for (DistributeConfig config : lists) {
                    this.setCache(config);
                }
            }
        }
        catch (BadSqlGrammarException e) {
            System.out.println("\u52a0\u8f7d\u5206\u9500\u914d\u7f6e\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u8868\u4e0d\u5b58\u5728\u6216\u7f3a\u5c11\u5b57\u6bb5");
        }
    }

    public void setCache(DistributeConfig config) {
        this.simpleRedisTemplate.set("DistributeConfig" + config.getAppId(), (Object)config);
    }

    public DistributeConfig getCache(String appId) {
        return (DistributeConfig)((Object)this.simpleRedisTemplate.get("DistributeConfig" + appId, DistributeConfig.class));
    }

    private DistributeConfig initDistributeConfig(String appId) {
        DistributeConfig config = new DistributeConfig();
        config.setAppId(appId);
        config.setShareLevelRate1(0.02);
        config.setShareLevelRate2(0.01);
        config.setShareLevelCount(2);
        return config;
    }
}

