/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.service.ConfigService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.enums.MemberIdentityEnum;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberLevelItemService;
import com.wego168.member.service.impl.MemberLevelService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.share.component.DistributeWxMsgTemplateTask;
import com.wego168.share.domain.ShareChain;
import com.wego168.share.domain.ShareLink;
import com.wego168.share.filter.ShareFilter;
import com.wego168.share.model.ShareMember;
import com.wego168.share.model.TeamUser;
import com.wego168.share.persistence.ShareChainMapper;
import com.wego168.share.service.DistributeConfigService;
import com.wego168.share.service.ShareConfigService;
import com.wego168.share.service.ShareLinkService;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.util.GuidGenerator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShareChainService
extends CrudService<ShareChain> {
    private static Logger logger = LoggerFactory.getLogger(ShareFilter.class);
    @Autowired
    private ShareChainMapper mapper;
    @Autowired
    private ShareLinkService shareLinkService;
    @Autowired
    private DistributeConfigService distributeConfigService;
    @Autowired
    private DistributeWxMsgTemplateTask distributeWxMsgTemplateTask;
    @Autowired
    protected AuthenticationUser authenticationUser;
    @Autowired
    protected ConfigService configService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private MemberLevelItemService memberLevelItemService;
    @Autowired
    private MemberLevelService memberLevelService;
    @Autowired
    private ShareConfigService shareConfigService;
    @Autowired
    private MemberService memberService;

    public CrudMapper<ShareChain> getMapper() {
        return this.mapper;
    }

    public Member selectParent(String memberId) {
        return this.mapper.selectParent(memberId);
    }

    public List<ShareMember> selectParentList(List<String> list) {
        return this.mapper.selectParentList(list);
    }

    public List<ShareChain> selectByUser(String username) {
        return this.mapper.selectByUser(username);
    }

    public List<TeamUser> selectTeamUserPage(Page page) {
        return this.mapper.selectTeamUserPage(page);
    }

    public List<ShareChain> selectByParent(String parentId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("parentId", (Object)parentId).orderBy("level asc");
        return this.mapper.selectList(criteria);
    }

    public List<ShareChain> selectByMemberId(String memberId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("memberId", (Object)memberId).orderBy("level asc");
        return this.mapper.selectList(jpaCriteria);
    }

    public List<Bootmap> pageMyMemberList(Page page) {
        return this.mapper.pageMyMemberList(page);
    }

    public List<Bootmap> pageMyMemberListWithMember(Page page) {
        return this.mapper.pageMyMemberListWithMember(page);
    }

    public List<Bootmap> pageMyMemberListWithMemberForAdmin(Page page) {
        return this.mapper.pageMyMemberListWithMemberForAdmin(page);
    }

    public Bootmap groupByLevel(String parentId) {
        return this.mapper.groupByLevel(parentId);
    }

    public Bootmap groupByWithMember(String memberId) {
        return this.mapper.groupByWithMember(memberId);
    }

    public ShareChain buildShareChain(String memberId, String parentId, String appId, int level) {
        ShareChain chain = new ShareChain();
        chain.setId(GuidGenerator.generate());
        chain.setCreateTime(new Date());
        chain.setLevel(level);
        chain.setParentId(parentId);
        chain.setMemberId(memberId);
        chain.setAppId(appId);
        return chain;
    }

    @Transactional
    public int saveShareChainByShareLink(String openId, String parentId, String appId) {
        ShareLink shareLink = this.shareLinkService.selectByMemberId(openId, appId);
        if (shareLink == null) {
            shareLink = this.shareLinkService.buildShareLink(openId, parentId, appId);
            this.shareLinkService.insert(shareLink);
        }
        if ("0".equals(shareLink.getParentId())) {
            return 0;
        }
        return this.saveShareChain(shareLink);
    }

    @Transactional
    public int saveShareChain(ShareLink shareLink) {
        MemberAccount account;
        String appId = shareLink.getAppId();
        String openId = shareLink.getMemberId();
        String parentOpenId = shareLink.getParentId();
        int rows = 0;
        Object memberLevel = null;
        if (memberLevel != null && memberLevel.getIdentity().intValue() == MemberIdentityEnum.DISTRIBUTOR.value() && (account = this.memberAccountService.selectByUsername(openId, appId)) != null && StringUtils.isNotBlank((CharSequence)account.getMemberId())) {
            String upMemberId = this.mapper.selectUpMemberId(account.getMemberId());
            if (StringUtils.isNotBlank((CharSequence)upMemberId)) {
                return rows;
            }
            int shareLevelNum = this.shareConfigService.getShareLevelNum(appId);
            LinkedList<ShareChain> chainList = new LinkedList<ShareChain>();
            chainList.add(this.buildShareChain(account.getMemberId(), memberLevel.getMemberId(), appId, 1));
            List<ShareChain> lists = this.selectByMemberId(memberLevel.getMemberId());
            if (lists != null && lists.size() > 0) {
                for (ShareChain chain : lists) {
                    if (chain.getLevel() >= shareLevelNum || StringUtils.equals((CharSequence)account.getMemberId(), (CharSequence)chain.getParentId())) continue;
                    ShareChain scn = this.buildShareChain(account.getMemberId(), chain.getParentId(), appId, chain.getLevel() + 1);
                    chainList.add(scn);
                }
            }
            if (chainList.size() > 0) {
                rows = this.insertBatch(chainList);
            }
        }
        return rows;
    }

    @Async
    public void repairChain(String openId, String parentId, String appId) {
        List<ShareLink> shareLinkList;
        Bootmap boot = this.selectCountByParent(parentId);
        if (boot != null) {
            return;
        }
        ShareChain parentChain = null;
        List<ShareChain> parentChainList = this.selectByMemberId(parentId);
        if (parentChainList != null && parentChainList.size() > 0) {
            for (ShareChain chain : parentChainList) {
                if (chain.getLevel() != 1) continue;
                parentChain = chain;
            }
        }
        if ((shareLinkList = this.shareLinkService.selectListByParentId(openId, appId)) != null) {
            LinkedList<ShareChain> resultList = new LinkedList<ShareChain>();
            LinkedList<String> distributorList = new LinkedList<String>();
            for (ShareLink link : shareLinkList) {
                int identity;
                Member member = this.memberService.selectByUsername(link.getMemberId(), appId);
                if (member == null) continue;
                ShareChain chain = this.buildShareChain(member.getId(), parentId, appId, 1);
                resultList.add(chain);
                if (parentChain != null) {
                    ShareChain chain2 = this.buildShareChain(member.getId(), parentChain.getParentId(), appId, 2);
                    resultList.add(chain2);
                }
                int n = identity = member.getIdentity() == null ? 0 : member.getIdentity();
                if (identity != MemberIdentityEnum.DISTRIBUTOR.value()) continue;
                distributorList.add(member.getId());
            }
            if (distributorList.size() > 0) {
                for (String pid : distributorList) {
                    List<ShareChain> chLists = this.getFirstChildList(pid);
                    if (chLists == null || chLists.size() <= 0) continue;
                    for (ShareChain c : chLists) {
                        ShareChain chain = this.buildShareChain(c.getMemberId(), parentId, appId, 2);
                        resultList.add(chain);
                    }
                }
            }
            if (resultList.size() > 0) {
                this.mapper.insertBatch(resultList);
            }
        }
    }

    public List<ShareChain> getFirstChildList(String parentId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("parentId", (Object)parentId).eq("level", (Object)1);
        return this.mapper.selectList(jpaCriteria);
    }

    public List<Bootmap> selectCountByParentList(List<String> list) {
        return this.mapper.selectCountByParentList(list);
    }

    public Bootmap selectCountByParent(String parentId) {
        return this.mapper.selectCountByParent(parentId);
    }

    public int countTeamUser(String memberId) {
        Integer count = this.mapper.countTeamUser(memberId);
        return count == null ? 0 : count;
    }

    public List<Bootmap> countTeamUserByParentIdList(List<String> list) {
        return this.mapper.countTeamUserByParentIdList(list);
    }

    public String selectUpMemberId(String memberId) {
        return this.mapper.selectUpMemberId(memberId);
    }
}

