/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.share.domain.ShareLink;
import com.wego168.share.persistence.ShareLinkMapper;
import com.wego168.share.response.WxFansResponse;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.util.GuidGenerator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareLinkService
extends CrudService<ShareLink> {
    @Autowired
    private ShareLinkMapper mapper;
    @Autowired
    protected AuthenticationUser authenticationUser;

    public CrudMapper<ShareLink> getMapper() {
        return this.mapper;
    }

    public ShareLink selectByMemberId(String memberId, String appId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("memberId", (Object)memberId).eq("appId", (Object)appId);
        return (ShareLink)super.select(jpaCriteria);
    }

    public List<ShareLink> selectListByParentId(String parentId, String appId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("parentId", (Object)parentId).eq("appId", (Object)appId);
        return super.selectList(jpaCriteria);
    }

    public ShareLink selectBy(String memberId, String parentId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("memberId", (Object)memberId).eq("parentId", (Object)parentId);
        return (ShareLink)super.select(jpaCriteria);
    }

    public String selectUpMemberIdByOpenId(String openId) {
        return this.mapper.selectUpMemberIdByOpenId(openId);
    }

    public List<WxFansResponse> selectFirstFansList(Page page) {
        return this.mapper.selectFirstFansList(page);
    }

    public Integer selectFirstFansCount(String openId, String appellation) {
        Integer count = this.mapper.selectFirstFansCount(openId, appellation);
        return count == null ? 0 : count;
    }

    public List<WxFansResponse> selectSecondFansList(Page page) {
        return this.mapper.selectSecondFansList(page);
    }

    public Integer selectSecondFansCount(String openId, String appellation) {
        Integer count = this.mapper.selectSecondFansCount(openId, appellation);
        return count == null ? 0 : count;
    }

    public List<Bootmap> selectFirstFansListForAdmin(Page page) {
        return this.mapper.selectFirstFansListForAdmin(page);
    }

    public List<Bootmap> selectSecondFansListForAdmin(Page page) {
        return this.mapper.selectSecondFansListForAdmin(page);
    }

    public ShareLink buildShareLink(String memberId, String parentId, String appId) {
        ShareLink link = new ShareLink();
        link.setId(GuidGenerator.generate());
        link.setCreateTime(new Date());
        link.setParentId(parentId);
        link.setMemberId(memberId);
        link.setAppId(appId);
        return link;
    }
}

