/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.distribute.enums.SharerStatusEnum;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.share.domain.ShareOpenIdChain;
import com.wego168.share.domain.Sharer;
import com.wego168.share.domain.SharerConfig;
import com.wego168.share.model.response.SharerCustomersWebPageResponse;
import com.wego168.share.model.response.SharerFriendsWebPageResponse;
import com.wego168.share.persistence.ShareOpenIdChainMapper;
import com.wego168.share.persistence.SharerMapper;
import com.wego168.util.Checker;
import com.wego168.util.DateUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareOpenIdChainService
extends CrudService<ShareOpenIdChain> {
    @Autowired
    private ShareOpenIdChainMapper mapper;
    @Autowired
    private DistributerCommissionService distributerCommissionService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private SharerMapper sharerMapper;

    public ShareOpenIdChain create(String openId, String upperOpenId, int level, boolean isRoot, String url, int expireDays, int insteadDays) {
        expireDays = expireDays == 0 ? 3650 : expireDays;
        insteadDays = insteadDays == 0 ? 3650 : insteadDays;
        Date now = new Date();
        ShareOpenIdChain chain = new ShareOpenIdChain();
        chain.setId(SequenceUtil.createUuid());
        chain.setCreateTime(now);
        chain.setOpenId(openId);
        chain.setUpperOpenId(upperOpenId);
        chain.setUpperSharerLevel(level);
        chain.setUpperSharerIsRoot(isRoot);
        chain.setUrl(url);
        chain.setExpireDays(expireDays);
        chain.setExpireTime(DateUtil.addDaysToDate((Date)now, (int)expireDays));
        chain.setInsteadDays(insteadDays);
        chain.setInsteadTime(DateUtil.addDaysToDate((Date)now, (int)insteadDays));
        return chain;
    }

    public ShareOpenIdChain createSystemVirtualChain(String openId, String virtualUpperSharerId) {
        ShareOpenIdChain chain = new ShareOpenIdChain();
        chain.setId(SequenceUtil.createUuid());
        Date now = new Date();
        chain.setCreateTime(now);
        chain.setOpenId(openId);
        chain.setUpperOpenId(virtualUpperSharerId);
        chain.setUpperSharerIsRoot(false);
        chain.setUpperSharerLevel(0);
        chain.setExpireDays(3650);
        chain.setExpireTime(DateUtil.addDaysToDate((Date)now, (int)3650));
        chain.setInsteadDays(3650);
        chain.setInsteadTime(DateUtil.addDaysToDate((Date)now, (int)3650));
        chain.setUrl(null);
        return chain;
    }

    public String getRealUpperOpenId(String openId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("openId", (Object)openId);
        criteria.eq("upperSharerLevel", (Object)1);
        Date now = new Date();
        criteria.gt("expireTime", (Object)now);
        ShareOpenIdChain chain = (ShareOpenIdChain)this.mapper.select(criteria);
        if (chain != null) {
            return chain.getUpperOpenId();
        }
        return null;
    }

    public ShareOpenIdChain getUpperOpenIdChainIncludeSystem(String openId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("openId", (Object)openId);
        criteria.orderBy("upperSharerLevel ASC, createTime DESC");
        List list = this.mapper.selectList(criteria);
        if (list != null && list.size() > 0) {
            return (ShareOpenIdChain)list.get(0);
        }
        return null;
    }

    public ShareOpenIdChain getUpperOpenIdChainIncludeSystem2(String openId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("openId", (Object)openId);
        criteria.orderBy("upperSharerLevel ASC, createTime DESC");
        Date now = new Date();
        criteria.gt("expireTime", (Object)now);
        List list = this.mapper.selectList(criteria);
        if (list != null && list.size() > 0) {
            return (ShareOpenIdChain)list.get(0);
        }
        return null;
    }

    public void renewInsteadAndExpireTime(ShareOpenIdChain chainDb, SharerConfig config) {
        ShareOpenIdChain param = new ShareOpenIdChain();
        Date now = new Date();
        param.setId(chainDb.getId());
        param.setCreateTime(now);
        int expireDays = config.getChainExpireDays();
        param.setExpireDays(expireDays);
        param.setExpireTime(DateUtil.addDaysToDate((Date)now, (int)expireDays));
        int insteadDays = config.getChainInsteadDays();
        param.setInsteadDays(insteadDays);
        param.setInsteadTime(DateUtil.addDaysToDate((Date)now, (int)insteadDays));
        this.updateSelective(param);
    }

    public boolean isAuditedSharerId(String openId, String appId) {
        String memberId;
        Sharer sharer;
        MemberAccount account = this.memberAccountService.selectByUsername(openId, appId);
        if (account != null && (sharer = (Sharer)((Object)this.sharerMapper.selectById(memberId = account.getMemberId()))) != null) {
            return StringUtil.equals((String)sharer.getAuditStatus(), (String)SharerStatusEnum.AUDITED.value());
        }
        return false;
    }

    public List<ShareOpenIdChain> listUpperChainsExcludeSystemVirtualChain(String openId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("openId", (Object)openId);
        criteria.gt("upperSharerLevel", (Object)0);
        Date now = new Date();
        criteria.gt("expireTime", (Object)now);
        criteria.le("upperSharerLevel", (Object)3).orderBy("upperSharerLevel ASC");
        return this.mapper.selectList(criteria);
    }

    public CrudMapper<ShareOpenIdChain> getMapper() {
        return this.mapper;
    }

    public List<SharerFriendsWebPageResponse> selectFriendsPage(String appellation, String upperOpenId, String memberId, boolean showCommission, int accountType, Page page) {
        List<SharerFriendsWebPageResponse> openIdList;
        page.put((Object)"openId", (Object)upperOpenId);
        page.put((Object)"accountType", (Object)accountType);
        int maxLevel = 1;
        page.put((Object)"maxLevel", (Object)maxLevel);
        page.put((Object)"now", (Object)new Date());
        if (StringUtil.isNotBlank((String)appellation)) {
            page.put((Object)"name", (Object)("%" + appellation + "%"));
        }
        if (Checker.listIsEmpty(openIdList = this.mapper.selectFriendsPage(page))) {
            return openIdList;
        }
        if (showCommission) {
            int commissionLevel = 2;
            String type = "sharer";
            Map<String, Integer> commissionMap = this.distributerCommissionService.selectCommissionAsMap(openIdList, memberId, commissionLevel, type);
            for (SharerFriendsWebPageResponse openIdResponse : openIdList) {
                String openId = openIdResponse.getOpenId();
                Integer commission = commissionMap.get(openId);
                commission = commission == null ? 0 : commission;
                openIdResponse.setCommission(commission);
            }
        }
        return openIdList;
    }

    public List<SharerCustomersWebPageResponse> selectCustomersPage(String appellation, String upperOpenId, String memberId, boolean showCommission, Page page) {
        List<SharerCustomersWebPageResponse> openIdList;
        page.put((Object)"openId", (Object)upperOpenId);
        page.put((Object)"now", (Object)new Date());
        int maxLevel = 1;
        page.put((Object)"maxLevel", (Object)maxLevel);
        if (StringUtil.isNotBlank((String)appellation)) {
            page.put((Object)"name", (Object)("%" + appellation + "%"));
        }
        if (Checker.listIsEmpty(openIdList = this.mapper.selectCustomersPage(page))) {
            return openIdList;
        }
        if (showCommission) {
            Map<String, Integer> orderAmountMap = this.distributerCommissionService.selectOrderAmountAsMap(openIdList, memberId);
            for (SharerCustomersWebPageResponse response : openIdList) {
                String openId = response.getOpenId();
                Integer orderAmount = orderAmountMap.get(openId);
                orderAmount = orderAmount == null ? 0 : orderAmount;
                response.setAmount(orderAmount);
            }
        }
        return openIdList;
    }

    public int sumCustomerQuantity(String openId, String appId) {
        Map<String, Integer> map = this.sumCustomerQuantityAsMap(appId);
        return map.getOrDefault(openId, 0);
    }

    public Map<String, Integer> sumCustomerQuantityAsMap(String appId) {
        Date now = new Date();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int maxLevel = 1;
        List<Bootmap> list = this.mapper.sumCustomerQuantityAsMap(appId, now, maxLevel);
        if (Checker.listNotEmpty(list)) {
            for (Bootmap e : list) {
                map.put(e.getString("openId"), e.getInteger("quantity", Integer.valueOf(0)));
            }
        }
        return map;
    }

    public int sumLevel1FriendIncludeExpired(String openId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.select("DISTINCT(open_id)");
        criteria.eq("upperSharerLevel", (Object)1);
        criteria.eq("upperOpenId", (Object)openId);
        return this.mapper.selectCount(criteria);
    }
}

