/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.share.domain.SharerBecomeCondition;
import com.wego168.share.enums.SharerBecomeConditionEnum;
import com.wego168.share.persistence.SharerBecomeConditionMapper;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SharerBecomeConditionService
extends BaseService<SharerBecomeCondition> {
    @Autowired
    private SharerBecomeConditionMapper mapper;

    public List<SharerBecomeCondition> selectList(String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.orderBy("sort DESC");
        List<SharerBecomeCondition> list = this.selectList(criteria);
        if (list == null || list.size() == 0) {
            list = this.initCondition(appId);
        }
        return list;
    }

    public List<SharerBecomeCondition> selectListByIdArray(String[] idArray) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.in("id", (Object[])idArray);
        return this.mapper.selectList(criteria);
    }

    private List<SharerBecomeCondition> initCondition(String appId) {
        ArrayList<SharerBecomeCondition> list = new ArrayList<SharerBecomeCondition>(3);
        int sort = SharerBecomeConditionEnum.values().length;
        String groupId = SequenceUtil.createUuid();
        SharerBecomeConditionEnum[] sharerBecomeConditionEnumArray = SharerBecomeConditionEnum.values();
        int n = sharerBecomeConditionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SharerBecomeConditionEnum e = sharerBecomeConditionEnumArray[n2];
            SharerBecomeCondition condition = new SharerBecomeCondition();
            BaseDomainUtil.initBaseDomain((BaseDomain)condition, (String)appId);
            condition.setCondition(e.value());
            condition.setContent(e.description());
            condition.setSort(sort--);
            condition.setGroupId(groupId);
            list.add(condition);
            ++n2;
        }
        this.mapper.insertBatch(list);
        return list;
    }

    public CrudMapper<SharerBecomeCondition> getMapper() {
        return this.mapper;
    }
}

