/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.share.domain.SharerConfig;
import com.wego168.share.enums.SharerChainModeEnum;
import com.wego168.share.persistence.SharerConfigMapper;
import com.wego168.util.BaseDomainUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SharerConfigService
extends CrudService<SharerConfig> {
    @Autowired
    private SharerConfigMapper sharerConfigMapper;

    public CrudMapper<SharerConfig> getMapper() {
        return this.sharerConfigMapper;
    }

    public SharerConfig selectByAppId(String appId) {
        SharerConfig config = (SharerConfig)((Object)this.selectById(appId));
        if (config == null) {
            config = this.init(appId);
        }
        return config;
    }

    private SharerConfig init(String appId) {
        SharerConfig config = new SharerConfig();
        BaseDomainUtil.initBaseDomain((BaseDomain)config, (String)appId);
        config.setId(appId);
        config.setChainExpireDays(7300);
        config.setChainInsteadDays(1);
        config.setChainMode(SharerChainModeEnum.REPLACEABLE.value());
        config.setMaxCommissionLevel(1);
        this.sharerConfigMapper.insert((Object)config);
        return config;
    }
}

