/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.share.model.response.SharerAdminPageResponseV2;
import com.wego168.share.persistence.ShareOpenIdChainMapper;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SharerFriendsService {
    @Autowired
    private SimpleRedisTemplate redisTemplate;
    @Autowired
    private ShareOpenIdChainMapper chainMapper;
    @Autowired
    private ShareOpenIdChainService chainService;
    @Autowired
    private MemberAccountService memberAccountService;
    private Logger logger = LoggerFactory.getLogger(SharerFriendsService.class);

    @Async
    public void updateShareFriendsQuantityAsync(String sharerOpenId, String sharerId, String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("upperOpenId", (Object)sharerOpenId);
        int friendsQuantity = this.chainMapper.selectCount(criteria);
        String redisKey = "sharer-fans-quantity-" + appId;
        String mapKey = sharerId;
        this.redisTemplate.putMap(redisKey, mapKey, (Object)friendsQuantity);
        this.logger.error("\u66f4\u65b0\u63a8\u5e7f\u8005{}\u7684\u56e2\u961f\u4eba\u6570\u4e3a{}\u4eba", (Object)sharerOpenId, (Object)friendsQuantity);
    }

    @Async
    public void updateShareFriendsQuantityAsync(String sharerOpenId, String appId) {
        String memberId;
        MemberAccount account = this.memberAccountService.selectByUsername(sharerOpenId, appId);
        if (account != null && StringUtil.isBlank((String)(memberId = account.getMemberId()))) {
            this.updateShareFriendsQuantityAsync(sharerOpenId, memberId, appId);
        }
    }

    public List<SharerAdminPageResponseV2> assembleCustomerQuantity(List<SharerAdminPageResponseV2> list, String appId) {
        if (Checker.listNotEmpty(list)) {
            Map<String, Integer> customerQuantityAsMap = this.chainService.sumCustomerQuantityAsMap(appId);
            for (SharerAdminPageResponseV2 e : list) {
                String openId = e.getOpenId();
                e.setCustomerQuantity(customerQuantityAsMap.getOrDefault(openId, 0));
            }
        }
        return list;
    }
}

