/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.service.StorableService;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.share.domain.SharerLevel;
import com.wego168.share.domain.SharerLevelCondition;
import com.wego168.share.enums.SharerLevelConditionGoalTypeEnum;
import com.wego168.share.model.response.SharerLevelAdminPageResponse;
import com.wego168.share.persistence.SharerLevelConditionMapper;
import com.wego168.share.persistence.SharerLevelMapper;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SharerLevelService
extends CrudService<SharerLevel> {
    @Autowired
    private SharerLevelMapper mapper;
    @Autowired
    private SharerLevelConditionMapper sharerLevelConditionMapper;
    @Autowired
    private StorableService storableService;

    public CrudMapper<SharerLevel> getMapper() {
        return this.mapper;
    }

    public SharerLevel selectByLevel(String appId, int level) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.eq("level", (Object)level);
        criteria.eq("isDeleted", (Object)false);
        SharerLevel sharerLevel = (SharerLevel)((Object)this.mapper.select(criteria));
        if (level == 1 && sharerLevel == null) {
            this.init(appId);
            return this.selectByLevel(appId, level);
        }
        return sharerLevel;
    }

    @Transactional
    public String insert(String icon, String name, int level, int commissionRate, int commissionRate2, int pointRate, int goalQuantity, String goalType, String description, String serverId, String appId) {
        SharerLevel sharerLevel = new SharerLevel();
        BaseDomainUtil.initBaseDomain((BaseDomain)sharerLevel, (String)appId);
        sharerLevel.setCommissionRate(commissionRate);
        sharerLevel.setCommissionRate2(commissionRate2);
        sharerLevel.setPointRate(pointRate);
        if (StringUtil.isNotBlank((String)icon)) {
            sharerLevel.setIcon(icon);
        }
        sharerLevel.setLevel(level);
        sharerLevel.setName(name);
        sharerLevel.setServerId(serverId);
        SharerLevelCondition condition = new SharerLevelCondition();
        condition.setGoalQuantity(goalQuantity);
        condition.setGoalType(goalType);
        condition.setId(SequenceUtil.createUuid());
        condition.setLevelId(sharerLevel.getId());
        condition.setLogic("and");
        condition.setSort(1);
        if (StringUtil.equals((String)goalType, (String)SharerLevelConditionGoalTypeEnum.FRIENDS_QUANTITY.value())) {
            sharerLevel.setDescription("\u7d2f\u8ba1\u63a8\u5e7f\u4f1a\u5458\u8fbe\u5230" + goalQuantity + "\u4eba\uff0c\u5347\u7ea7\u4e3a" + name + "\u3002");
        } else if (StringUtil.equals((String)goalType, (String)SharerLevelConditionGoalTypeEnum.ORDER_AMOUNT.value())) {
            sharerLevel.setDescription("\u7d2f\u8ba1\u8ba2\u5355\u91d1\u989d\u8fbe\u5230" + goalQuantity + "\u5143\uff0c\u5347\u7ea7\u4e3a" + name + "\u3002");
        }
        if (level == 1) {
            sharerLevel.setDescription("\u7528\u6237\u6210\u4e3a\u63a8\u5e7f\u8005\u65f6\uff0c\u9ed8\u8ba4\u662f\u8be5\u7b49\u7ea7\u3002");
        }
        this.sharerLevelConditionMapper.insert(condition);
        this.mapper.insert((Object)sharerLevel);
        return sharerLevel.getId();
    }

    @Transactional
    public void update(String id, String icon, String name, int level, int commissionRate, int commissionRate2, int pointRate, int goalQuantity, String goalType, String description, String serverId) {
        SharerLevel param = new SharerLevel();
        param.setId(id);
        param.setCommissionRate(commissionRate);
        param.setCommissionRate2(commissionRate2);
        param.setPointRate(pointRate);
        if (StringUtil.isNotBlank((String)icon)) {
            param.setIcon(icon);
        }
        param.setLevel(level);
        param.setName(name);
        param.setServerId(serverId);
        param.setUpdateTime(new Date());
        SharerLevelCondition condition = new SharerLevelCondition();
        condition.setGoalQuantity(goalQuantity);
        condition.setGoalType(goalType);
        condition.setId(SequenceUtil.createUuid());
        condition.setLevelId(id);
        condition.setLogic("and");
        condition.setSort(1);
        if (StringUtil.equals((String)goalType, (String)SharerLevelConditionGoalTypeEnum.FRIENDS_QUANTITY.value())) {
            param.setDescription("\u7d2f\u8ba1\u63a8\u5e7f\u4f1a\u5458\u8fbe\u5230" + goalQuantity + "\u4eba\uff0c\u5347\u7ea7\u4e3a" + name + "\u3002");
        } else if (StringUtil.equals((String)goalType, (String)SharerLevelConditionGoalTypeEnum.ORDER_AMOUNT.value())) {
            param.setDescription("\u7d2f\u8ba1\u8ba2\u5355\u91d1\u989d\u8fbe\u5230" + goalQuantity + "\u5143\uff0c\u5347\u7ea7\u4e3a" + name + "\u3002");
        }
        if (level == 1) {
            param.setDescription("\u7528\u6237\u6210\u4e3a\u63a8\u5e7f\u8005\u65f6\uff0c\u9ed8\u8ba4\u662f\u8be5\u7b49\u7ea7\u3002");
        }
        this.sharerLevelConditionMapper.delete(JpaCriteria.builder().eq("levelId", (Object)id));
        this.sharerLevelConditionMapper.insert(condition);
        this.mapper.updateSelective((Object)param);
    }

    @Transactional
    public void deleteLevelAndCondition(String id) {
        this.sharerLevelConditionMapper.delete(JpaCriteria.builder().eq("levelId", (Object)id));
        this.mapper.deleteById(id);
    }

    public List<SharerLevelAdminPageResponse> selectPageForAdmin(String appId, Page page) {
        page.eq("appId", (Object)appId);
        page.eq("isDeleted", (Object)false);
        page.orderBy("level ASC");
        List<SharerLevelAdminPageResponse> list = this.selectList((JpaCriteria)page, SharerLevelAdminPageResponse.class);
        if (list == null || list.size() == 0) {
            list = this.init(appId);
        }
        this.storableService.assembleHost(list);
        return list;
    }

    private List<SharerLevelAdminPageResponse> init(String appId) {
        String icon = null;
        int level = 1;
        String name = "\u666e\u901a\u63a8\u5e7f\u8005";
        int commissionRate = 10;
        int pointRate = 0;
        int goalQuantity = 0;
        String goalType = SharerLevelConditionGoalTypeEnum.FRIENDS_QUANTITY.value();
        String serverId = "1";
        String levelId = this.insert(icon, name, level, commissionRate, commissionRate, pointRate, goalQuantity, goalType, null, serverId, appId);
        SharerLevelAdminPageResponse response = new SharerLevelAdminPageResponse();
        response.setDescription("\u7528\u6237\u6210\u4e3a\u63a8\u5e7f\u8005\u65f6\uff0c\u9ed8\u8ba4\u662f\u8be5\u7b49\u7ea7\u3002");
        response.setIcon(icon);
        response.setId(levelId);
        response.setLevel(level);
        response.setName(name);
        response.setServerId(serverId);
        ArrayList<SharerLevelAdminPageResponse> list = new ArrayList<SharerLevelAdminPageResponse>(1);
        list.add(response);
        return list;
    }
}

