/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.JpaCriteria;
import com.wego168.distribute.enums.FieldTypeEnum;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.share.domain.SharerRegistField;
import com.wego168.share.model.SharerRegistData;
import com.wego168.share.model.response.SharerRegistFieldResponse;
import com.wego168.share.persistence.SharerRegistFieldMapper;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SharerRegistFieldService
extends BaseService<SharerRegistField> {
    @Autowired
    private SharerRegistFieldMapper mapper;

    public CrudMapper<SharerRegistField> getMapper() {
        return this.mapper;
    }

    public SharerRegistData checkRegistrationData(Map<String, String> registrationData, String appId) {
        List<SharerRegistFieldResponse> fieldList = this.selectList(appId);
        return this.checkRegistrationData(registrationData, fieldList);
    }

    public SharerRegistData checkRegistrationData(Map<String, String> registrationData, List<SharerRegistFieldResponse> fieldList) {
        String name = null;
        String mobile = null;
        for (SharerRegistFieldResponse field : fieldList) {
            String fieldCode = field.getField();
            String value = registrationData.get(fieldCode);
            this.checkValue(value, field);
            if (StringUtil.equals((String)fieldCode, (String)"name")) {
                name = value;
            }
            if (!StringUtil.equals((String)fieldCode, (String)"phone")) continue;
            mobile = value;
        }
        SharerRegistData registrationDataResponse = new SharerRegistData();
        registrationDataResponse.setName(name);
        registrationDataResponse.setMobile(mobile);
        return registrationDataResponse;
    }

    public List<SharerRegistFieldResponse> selectList(String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.eq("isDeleted", (Object)false);
        criteria.orderBy("sortNumber DESC");
        List list = this.selectList(criteria, SharerRegistFieldResponse.class);
        if (list == null || list.size() == 0) {
            this.init(appId);
            return this.selectList(appId);
        }
        return list;
    }

    private List<SharerRegistField> init(String appId) {
        ArrayList<SharerRegistField> list = new ArrayList<SharerRegistField>(2);
        SharerRegistField name = new SharerRegistField();
        BaseDomainUtil.initBaseDomain((BaseDomain)name, (String)appId);
        name.setField("name");
        name.setMaxLength(16);
        name.setMinLength(0);
        name.setName("\u59d3\u540d");
        name.setNotBlank(true);
        name.setSortNumber(100);
        name.setSystem(true);
        name.setType(FieldTypeEnum.TEXT.value());
        list.add(name);
        SharerRegistField mobile = new SharerRegistField();
        BaseDomainUtil.initBaseDomain((BaseDomain)mobile, (String)appId);
        mobile.setField("phone");
        mobile.setMaxLength(11);
        mobile.setMinLength(0);
        mobile.setName("\u624b\u673a\u53f7\u7801");
        mobile.setNotBlank(true);
        mobile.setSortNumber(90);
        mobile.setSystem(true);
        mobile.setType(FieldTypeEnum.MOBILE.value());
        list.add(mobile);
        this.mapper.insertBatch(list);
        return list;
    }

    private void checkValue(String value, SharerRegistFieldResponse field) {
        String fieldName = field.getName();
        int maxLength = field.getMaxLength();
        String type = field.getType();
        if (StringUtil.equals((String)type, (String)FieldTypeEnum.MOBILE.value())) {
            Checker.checkMobilePhoneNumber((String)value);
        } else if (StringUtil.equals((String)type, (String)FieldTypeEnum.NUMBER.value())) {
            int intValue = Checker.checkStringIsPositiveInteger((String)value, (String)fieldName);
            Checker.checkCondition((intValue > maxLength ? 1 : 0) != 0, (String)(String.valueOf(fieldName) + "\u4e0d\u80fd\u8d85\u8fc7" + maxLength));
        } else if (StringUtil.equals((String)type, (String)FieldTypeEnum.TEXT.value())) {
            boolean notBlank = field.getNotBlank();
            if (notBlank) {
                if (maxLength > 0) {
                    Checker.checkBlankAndLength((String)value, (String)fieldName, (int)maxLength);
                } else {
                    Checker.checkBlank((String)value, (String)fieldName);
                }
            } else if (maxLength > 0) {
                Checker.checkBlankOrLength((String)value, (String)fieldName, (int)maxLength);
            } else {
                Checker.checkBlank((String)value, (String)fieldName);
            }
        }
    }
}

