/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.distribute.enums.SharerAuditStatusEnum;
import com.wego168.distribute.enums.SharerStatusEnum;
import com.wego168.domain.BaseDomain;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.share.domain.ShareOpenIdChain;
import com.wego168.share.domain.Sharer;
import com.wego168.share.model.SharerRegistData;
import com.wego168.share.model.response.SharerAdminPageResponse;
import com.wego168.share.model.response.SharerAdminPageResponseV2;
import com.wego168.share.model.response.SharerPlatformAuditResponse;
import com.wego168.share.persistence.SharerMapper;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SharerService
extends BaseService<Sharer> {
    @Autowired
    private SharerMapper sharerMapper;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private ShareOpenIdChainService shareOpenIdChainService;

    public Map<String, Sharer> selectMapByIdArray(String[] idArray) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.in("id", (Object[])idArray);
        List list = this.sharerMapper.selectList(criteria);
        HashMap<String, Sharer> map = new HashMap<String, Sharer>();
        for (Sharer sharer : list) {
            map.put(sharer.getId(), sharer);
        }
        return map;
    }

    public String ensureMemberAndAccountWhenRegist(SharerRegistData sharerRegistData, String openId, String unionId, String appId) {
        MemberAccount mobileAccount;
        MemberAccount openWechatAccount;
        MemberAccount sharerWechatAccount = this.memberAccountService.selectByUsername(openId, appId);
        String name = sharerRegistData.getName();
        String mobile = sharerRegistData.getMobile();
        if (sharerWechatAccount == null) {
            int defaultSex = 0;
            Member member = this.memberService.createByWechat(name, null, Integer.valueOf(defaultSex));
            member.setMobilePhoneNumber(mobile);
            member.setAppId(appId);
            if (StringUtil.isNotBlank((String)name)) {
                member.setName(name);
            } else {
                member.setName(null);
            }
            String memberId = member.getId();
            MemberAccount wechatAccount = this.memberAccountService.createProgramAccount(openId, memberId, appId);
            MemberAccount mobileAccount2 = null;
            if (StringUtil.isNotBlank((String)mobile)) {
                mobileAccount2 = this.memberAccountService.createMobileAccount(mobile, memberId, appId);
            }
            MemberAccount openWechatAccount2 = null;
            if (StringUtil.isNotBlank((String)unionId)) {
                openWechatAccount2 = this.memberAccountService.createOpenWechatAccount(unionId, memberId, appId);
            }
            this.memberService.registInWechatWithMobile(member, wechatAccount, mobileAccount2, openWechatAccount2);
            return member.getId();
        }
        String memberId = sharerWechatAccount.getMemberId();
        if (StringUtil.isNotBlank((String)unionId) && (openWechatAccount = this.memberAccountService.selectWechatAccount(memberId)) == null) {
            openWechatAccount = this.memberAccountService.createOpenWechatAccount(unionId, memberId, appId);
            this.memberAccountService.insert((Object)openWechatAccount);
        }
        if (StringUtil.isNotBlank((String)mobile) && (mobileAccount = this.memberAccountService.selectMobileAccount(memberId)) == null) {
            mobileAccount = this.memberAccountService.createMobileAccount(mobile, memberId, appId);
            this.memberAccountService.insert((Object)mobileAccount);
        }
        return memberId;
    }

    @Transactional
    public Sharer transferMemberWithoutAccount(Member member, String openId) {
        Map<String, String> registrationData = null;
        String storeId = member.getAppId();
        String auditStatus = SharerStatusEnum.AUDITED.value();
        return this.transferMemberWithoutAccount(registrationData, member, openId, storeId, auditStatus);
    }

    @Transactional
    public Sharer transferMemberWithoutAccount(Map<String, String> registrationData, Member member, String openId, String storeId, String auditStatus) {
        String memberId = member.getId();
        String number = SequenceUtil.createRandomNumberSequence((int)12);
        String appId = member.getAppId();
        Sharer sharer = new Sharer();
        BaseDomainUtil.initBaseDomain((BaseDomain)sharer, (String)appId);
        sharer.setId(memberId);
        if (registrationData == null || registrationData.size() == 0) {
            if (StringUtil.isNotBlank((String)member.getMobilePhoneNumber())) {
                sharer.setMobile(member.getMobilePhoneNumber());
            } else {
                sharer.setMobile("");
            }
            String sharerName = member.getName();
            if (StringUtil.isBlank((String)sharerName)) {
                sharerName = member.getAppellation();
            }
            if (StringUtil.isNotBlank((String)sharerName)) {
                sharer.setName(sharerName);
            } else {
                sharer.setName(null);
            }
        } else {
            String name = registrationData.get("name");
            String mobilePhoneNumber = registrationData.get("phone");
            sharer.setName(name);
            sharer.setMobile(mobilePhoneNumber);
            StringBuffer registrationDataBuffer = new StringBuffer("{");
            for (Map.Entry<String, String> entry : registrationData.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                registrationDataBuffer.append("\"" + key + "\": ").append("\"" + value + "\",");
            }
            registrationDataBuffer.deleteCharAt(registrationDataBuffer.length() - 1);
            registrationDataBuffer.append("}");
            sharer.setRegistrationData(registrationDataBuffer.toString());
        }
        sharer.setNumber(number);
        sharer.setAuditStatus(auditStatus);
        if (StringUtil.equals((String)auditStatus, (String)SharerAuditStatusEnum.AUDITED.value())) {
            sharer.setStatus(SharerStatusEnum.AUDITED.value());
        } else {
            sharer.setStatus(SharerStatusEnum.WAITING_AUDIT.value());
        }
        if (StringUtil.isBlank((String)storeId) || StringUtil.equals((String)storeId, (String)member.getAppId())) {
            sharer.setType("default");
            sharer.setStoreId(member.getAppId());
        } else {
            sharer.setType("store");
            sharer.setStoreId(storeId);
        }
        sharer.setLevel(1);
        this.sharerMapper.insert((Object)sharer);
        ShareOpenIdChain chain = this.shareOpenIdChainService.getUpperOpenIdChainIncludeSystem2(openId);
        if (chain == null || chain.getExpireDays() < 365) {
            ShareOpenIdChain openIdChain = this.shareOpenIdChainService.createSystemVirtualChain(openId, appId);
            openIdChain.setAppId(appId);
            this.shareOpenIdChainService.insert(openIdChain);
        }
        return sharer;
    }

    public List<SharerAdminPageResponse> selectPageForAdmin(String appellation, String mobile, String appId, String orderBy, Page page) {
        page.put((Object)"appId", (Object)appId);
        if (StringUtil.isNotBlank((String)appellation)) {
            page.put((Object)"appellation", (Object)("%" + appellation + "%"));
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            page.put((Object)"mobile", (Object)("%" + mobile + "%"));
        }
        if (StringUtil.equals((String)orderBy, (String)"highLevelFirst")) {
            page.put((Object)"orderBy", (Object)"s.level DESC,s.create_time DESC");
        } else if (StringUtil.equals((String)orderBy, (String)"oldFirst")) {
            page.put((Object)"orderBy", (Object)"s.create_time ASC");
        } else if (StringUtil.equals((String)orderBy, (String)"newFirst")) {
            page.put((Object)"orderBy", (Object)"s.create_time DESC");
        } else {
            page.put((Object)"orderBy", (Object)"s.create_time DESC");
        }
        return this.sharerMapper.selectPageForAdmin(page);
    }

    public List<SharerAdminPageResponseV2> selectPageForAdminV2(String name, String mobile, String auditStatus, Integer level, String appId, Page page) {
        page.put((Object)"appId", (Object)appId);
        page.put((Object)"auditStatus", (Object)auditStatus);
        if (level != null) {
            page.put((Object)"level", (Object)level);
        }
        if (StringUtil.isNotBlank((String)name)) {
            page.put((Object)"name", (Object)("%" + name + "%"));
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            page.put((Object)"mobile", (Object)("%" + mobile + "%"));
        }
        return this.sharerMapper.selectPageForAdminV2(page);
    }

    public List<SharerAdminPageResponseV2> selectPageForStoreV2(String name, String mobile, Integer level, String storeId, Page page) {
        page.put((Object)"storeId", (Object)storeId);
        if (level != null) {
            page.put((Object)"level", (Object)level);
        }
        if (StringUtil.isNotBlank((String)name)) {
            page.put((Object)"name", (Object)("%" + name + "%"));
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            page.put((Object)"mobile", (Object)("%" + mobile + "%"));
        }
        return this.sharerMapper.selectPageForStoreV2(page);
    }

    public List<SharerPlatformAuditResponse> selectPlatformAuditPage(String mobile, String auditStatus, String appId, Page page) {
        String type = "default";
        page.put((Object)"appId", (Object)appId);
        page.put((Object)"platform", (Object)type);
        page.put((Object)"auditStatus", (Object)auditStatus);
        if (StringUtil.isNotBlank((String)mobile)) {
            page.put((Object)"mobile", (Object)mobile);
        }
        return this.sharerMapper.selectPlatformAuditPage(page);
    }

    public List<SharerPlatformAuditResponse> selectStoreAuditPage(String mobile, String auditStatus, String storeId, Page page) {
        String type = "store";
        page.put((Object)"storeId", (Object)storeId);
        page.put((Object)"store", (Object)type);
        page.put((Object)"auditStatus", (Object)auditStatus);
        if (StringUtil.isNotBlank((String)mobile)) {
            page.put((Object)"mobile", (Object)mobile);
        }
        return this.sharerMapper.selectStoreAuditPage(page);
    }

    public CrudMapper<Sharer> getMapper() {
        return this.sharerMapper;
    }
}

