/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.task;

import com.wego168.distribute.enums.DistributerCommissionTypeEnum;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.share.domain.Sharer;
import com.wego168.share.enums.SharerLevelConditionGoalTypeEnum;
import com.wego168.share.model.response.SharerLevelAdminGetResponse;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.share.service.SharerLevelConditionService;
import com.wego168.share.service.SharerService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SharerLevelCalculator {
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private SharerService sharerService;
    @Autowired
    private ShareOpenIdChainService shareOpenIdChainService;
    @Autowired
    private SharerLevelConditionService sharerLevelConditionService;
    @Autowired
    private DistributerCommissionService distributerCommissionService;
    private Logger logger = LoggerFactory.getLogger(SharerLevelCalculator.class);

    @Async
    public void calculateSharerLevelByBinding(String sharerOpenId, String appId) {
        String goalType = SharerLevelConditionGoalTypeEnum.FRIENDS_QUANTITY.value();
        List<SharerLevelAdminGetResponse> conditionList = this.sharerLevelConditionService.selectByGoal(goalType, appId);
        if (conditionList == null || conditionList.size() == 0) {
            this.logger.error("\u4e0d\u5b58\u5728\u56e2\u961f\u4eba\u6570\u6761\u4ef6\u7684\u5347\u7ea7");
            return;
        }
        MemberAccount account = this.memberAccountService.selectByUsername(sharerOpenId, appId);
        if (account == null) {
            this.logger.error("\u4e0d\u5b58\u5728\u5fae\u4fe1\u8d26\u53f7");
            return;
        }
        String sharerId = account.getMemberId();
        Sharer sharer = (Sharer)((Object)this.sharerService.selectById(sharerId));
        int level = sharer.getLevel();
        int friendsQuantity = this.shareOpenIdChainService.sumLevel1FriendIncludeExpired(sharerOpenId);
        for (SharerLevelAdminGetResponse condition : conditionList) {
            int goalQuantity;
            int conditionLevel = condition.getLevel();
            if (conditionLevel <= level || friendsQuantity < (goalQuantity = condition.getGoalQuantity().intValue())) continue;
            Sharer param = new Sharer();
            param.setId(sharerId);
            param.setUpdateTime(new Date());
            param.setLevel(conditionLevel);
            this.sharerService.updateSelective((Object)param);
            this.logger.error(String.valueOf(sharer.getName()) + "\u5df2\u5347\u5230" + conditionLevel + "\u7ea7");
            return;
        }
    }

    @Async
    public void calculateSharerLevelByCommission(String sharerId, String appId) {
        String goalType = SharerLevelConditionGoalTypeEnum.ORDER_AMOUNT.value();
        List<SharerLevelAdminGetResponse> conditionList = this.sharerLevelConditionService.selectByGoal(goalType, appId);
        if (conditionList == null || conditionList.size() == 0) {
            this.logger.error("\u4e0d\u5b58\u5728\u63a8\u5e7f\u8ba2\u5355\u91d1\u989d\u6761\u4ef6\u7684\u5347\u7ea7");
            return;
        }
        Sharer sharer = (Sharer)((Object)this.sharerService.selectById(sharerId));
        int level = sharer.getLevel();
        String type = DistributerCommissionTypeEnum.SHARER.value();
        int orderAmount = this.distributerCommissionService.sumCustomerOrderAmount(sharerId, type);
        for (SharerLevelAdminGetResponse condition : conditionList) {
            int goalQuantity;
            int conditionLevel = condition.getLevel();
            if (conditionLevel <= level || orderAmount < (goalQuantity = condition.getGoalQuantity().intValue()) * 100) continue;
            Sharer param = new Sharer();
            param.setId(sharerId);
            param.setUpdateTime(new Date());
            param.setLevel(conditionLevel);
            this.sharerService.updateSelective((Object)param);
            this.logger.error(String.valueOf(sharer.getName()) + "\u5df2\u5347\u5230" + conditionLevel + "\u7ea7");
            return;
        }
    }
}

