/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.EntityModel;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleFormat
extends Format {
    private static final long serialVersionUID = 4595245575868697702L;
    private final boolean primitive;
    private SimpleFormat wrapperFormat;

    SimpleFormat(Catalog catalog, Class type, boolean primitive) {
        super(catalog, type);
        this.primitive = primitive;
    }

    void setWrapperFormat(SimpleFormat wrapperFormat) {
        this.wrapperFormat = wrapperFormat;
    }

    @Override
    Format getWrapperFormat() {
        return this.wrapperFormat;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
    }

    @Override
    void initialize(Catalog catalog, EntityModel model, int initVersion) {
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) {
        return o;
    }

    @Override
    boolean evolve(Format newFormat, Evolver evolver) {
        evolver.useOldFormat(this, newFormat);
        return true;
    }

    Object newPrimitiveArray(int len, EntityInput input) throws RefreshException {
        throw DbCompat.unexpectedState();
    }

    void writePrimitiveArray(Object o, EntityOutput output) {
        throw DbCompat.unexpectedState();
    }

    int getPrimitiveLength() {
        throw DbCompat.unexpectedState();
    }

    void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException, RefreshException {
        throw DbCompat.unexpectedState();
    }

    void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
        throw DbCompat.unexpectedState();
    }

    void skipPrimitiveArray(int len, RecordInput input) {
        input.skipFast(len * this.getPrimitiveLength());
    }

    void copySecMultiKeyPrimitiveArray(int len, RecordInput input, Set results) {
        int primLen = this.getPrimitiveLength();
        for (int i = 0; i < len; ++i) {
            DatabaseEntry entry = new DatabaseEntry(input.getBufferBytes(), input.getBufferOffset(), primLen);
            results.add(entry);
            input.skipFast(primLen);
        }
    }

    public static class FDate
    extends SimpleFormat {
        private static final long serialVersionUID = -5665773229869034145L;

        FDate(Catalog catalog) {
            super(catalog, Date.class, false);
        }

        Object newArray(int len) {
            return new Date[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return new Date(input.readLong());
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeLong(((Date)o).getTime());
        }

        void skipContents(RecordInput input) {
            input.skipFast(8);
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), 8);
            input.skipFast(8);
        }
    }

    public static class FBigDec
    extends SimpleFormat {
        private static final long serialVersionUID = 6108874887143696463L;

        FBigDec(Catalog catalog) {
            super(catalog, BigDecimal.class, false);
        }

        Object newArray(int len) {
            return new BigDecimal[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return input.readSortedBigDecimal();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeSortedBigDecimal((BigDecimal)o);
        }

        void skipContents(RecordInput input) {
            input.skipFast(input.getSortedBigDecimalByteLength());
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            int len = input.getSortedBigDecimalByteLength();
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), len);
            input.skipFast(len);
        }

        public boolean allowEvolveFromProxy() {
            return true;
        }
    }

    public static class FBigInt
    extends SimpleFormat {
        private static final long serialVersionUID = -5027098112507644563L;

        FBigInt(Catalog catalog) {
            super(catalog, BigInteger.class, false);
        }

        Object newArray(int len) {
            return new BigInteger[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return input.readBigInteger();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeBigInteger((BigInteger)o);
        }

        void skipContents(RecordInput input) {
            input.skipFast(input.getBigIntegerByteLength());
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            int len = input.getBigIntegerByteLength();
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), len);
            input.skipFast(len);
        }
    }

    public static class FString
    extends SimpleFormat {
        private static final long serialVersionUID = 5710392786480064612L;

        FString(Catalog catalog) {
            super(catalog, String.class, false);
        }

        Object newArray(int len) {
            return new String[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return input.readString();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeString((String)o);
        }

        void skipContents(RecordInput input) {
            input.skipFast(input.getStringByteLength());
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            int len = input.getStringByteLength();
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), len);
            input.skipFast(len);
        }
    }

    public static class FChar
    extends SimpleFormat {
        private static final long serialVersionUID = -7609118195770005374L;

        FChar(Catalog catalog, boolean primitive) {
            super(catalog, primitive ? Character.TYPE : Character.class, primitive);
        }

        Object newArray(int len) {
            return new Character[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return Character.valueOf(input.readChar());
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeChar(((Character)o).charValue());
        }

        void skipContents(RecordInput input) {
            input.skipFast(2);
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) throws RefreshException {
            char[] a = new char[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readChar();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            char[] a = (char[])o;
            int len = a.length;
            output.writeArrayLength(len);
            for (int i = 0; i < len; ++i) {
                output.writeChar(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 2;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException, RefreshException {
            field.setChar(o, input.readChar());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeChar(field.getChar(o));
        }
    }

    public static class FDouble
    extends SimpleFormat {
        private static final long serialVersionUID = 646904456811041423L;

        FDouble(Catalog catalog, boolean primitive) {
            super(catalog, primitive ? Double.TYPE : Double.class, primitive);
        }

        Object newArray(int len) {
            return new Double[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return input.readSortedDouble();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeSortedDouble(((Number)o).doubleValue());
        }

        void skipContents(RecordInput input) {
            input.skipFast(8);
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), 8);
            input.skipFast(8);
        }

        Object newPrimitiveArray(int len, EntityInput input) throws RefreshException {
            double[] a = new double[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readSortedDouble();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            double[] a = (double[])o;
            int len = a.length;
            output.writeArrayLength(len);
            for (int i = 0; i < len; ++i) {
                output.writeSortedDouble(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 8;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException, RefreshException {
            field.setDouble(o, input.readSortedDouble());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeSortedDouble(field.getDouble(o));
        }
    }

    public static class FFloat
    extends SimpleFormat {
        private static final long serialVersionUID = 1033413049495053602L;

        FFloat(Catalog catalog, boolean primitive) {
            super(catalog, primitive ? Float.TYPE : Float.class, primitive);
        }

        Object newArray(int len) {
            return new Float[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return Float.valueOf(input.readSortedFloat());
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeSortedFloat(((Number)o).floatValue());
        }

        void skipContents(RecordInput input) {
            input.skipFast(4);
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) throws RefreshException {
            float[] a = new float[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readSortedFloat();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            float[] a = (float[])o;
            int len = a.length;
            output.writeArrayLength(len);
            for (int i = 0; i < len; ++i) {
                output.writeSortedFloat(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 4;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException, RefreshException {
            field.setFloat(o, input.readSortedFloat());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeSortedFloat(field.getFloat(o));
        }
    }

    public static class FLong
    extends SimpleFormat {
        private static final long serialVersionUID = 1872661106534776520L;

        FLong(Catalog catalog, boolean primitive) {
            super(catalog, primitive ? Long.TYPE : Long.class, primitive);
        }

        Object newArray(int len) {
            return new Long[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return input.readLong();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeLong(((Number)o).longValue());
        }

        void skipContents(RecordInput input) {
            input.skipFast(8);
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.getBufferBytes(), input.getBufferOffset(), 8);
            input.skipFast(8);
        }

        Object newPrimitiveArray(int len, EntityInput input) throws RefreshException {
            long[] a = new long[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readLong();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            long[] a = (long[])o;
            int len = a.length;
            output.writeArrayLength(len);
            for (int i = 0; i < len; ++i) {
                output.writeLong(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 8;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException, RefreshException {
            field.setLong(o, input.readLong());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeLong(field.getLong(o));
        }

        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FInt
    extends SimpleFormat {
        private static final long serialVersionUID = 2695910006049980013L;

        FInt(Catalog catalog, boolean primitive) {
            super(catalog, primitive ? Integer.TYPE : Integer.class, primitive);
        }

        Object newArray(int len) {
            return new Integer[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return input.readInt();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeInt(((Number)o).intValue());
        }

        void skipContents(RecordInput input) {
            input.skipFast(4);
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) throws RefreshException {
            int[] a = new int[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readInt();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            int[] a = (int[])o;
            int len = a.length;
            output.writeArrayLength(len);
            for (int i = 0; i < len; ++i) {
                output.writeInt(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 4;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException, RefreshException {
            field.setInt(o, input.readInt());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeInt(field.getInt(o));
        }

        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FShort
    extends SimpleFormat {
        private static final long serialVersionUID = -4909138198491785624L;

        FShort(Catalog catalog, boolean primitive) {
            super(catalog, primitive ? Short.TYPE : Short.class, primitive);
        }

        Object newArray(int len) {
            return new Short[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return input.readShort();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeShort(((Number)o).shortValue());
        }

        void skipContents(RecordInput input) {
            input.skipFast(2);
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) throws RefreshException {
            short[] a = new short[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readShort();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            short[] a = (short[])o;
            int len = a.length;
            output.writeArrayLength(len);
            for (int i = 0; i < len; ++i) {
                output.writeShort(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 2;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException, RefreshException {
            field.setShort(o, input.readShort());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeShort(field.getShort(o));
        }

        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FByte
    extends SimpleFormat {
        private static final long serialVersionUID = 3651752958101447257L;

        FByte(Catalog catalog, boolean primitive) {
            super(catalog, primitive ? Byte.TYPE : Byte.class, primitive);
        }

        Object newArray(int len) {
            return new Byte[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return input.readByte();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeByte(((Number)o).byteValue());
        }

        void skipContents(RecordInput input) {
            input.skipFast(1);
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) throws RefreshException {
            byte[] a = new byte[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readByte();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            byte[] a = (byte[])o;
            int len = a.length;
            output.writeArrayLength(len);
            for (int i = 0; i < len; ++i) {
                output.writeByte(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 1;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException, RefreshException {
            field.setByte(o, input.readByte());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeByte(field.getByte(o));
        }

        Format getSequenceKeyFormat() {
            return this;
        }
    }

    public static class FBool
    extends SimpleFormat {
        private static final long serialVersionUID = -7724949525068533451L;

        FBool(Catalog catalog, boolean primitive) {
            super(catalog, primitive ? Boolean.TYPE : Boolean.class, primitive);
        }

        Object newArray(int len) {
            return new Boolean[len];
        }

        public Object newInstance(EntityInput input, boolean rawAccess) throws RefreshException {
            return input.readBoolean();
        }

        void writeObject(Object o, EntityOutput output, boolean rawAccess) {
            output.writeBoolean((Boolean)o);
        }

        void skipContents(RecordInput input) {
            input.skipFast(1);
        }

        void copySecKey(RecordInput input, RecordOutput output) {
            output.writeFast(input.readFast());
        }

        Object newPrimitiveArray(int len, EntityInput input) throws RefreshException {
            boolean[] a = new boolean[len];
            for (int i = 0; i < len; ++i) {
                a[i] = input.readBoolean();
            }
            return a;
        }

        void writePrimitiveArray(Object o, EntityOutput output) {
            boolean[] a = (boolean[])o;
            int len = a.length;
            output.writeArrayLength(len);
            for (int i = 0; i < len; ++i) {
                output.writeBoolean(a[i]);
            }
        }

        int getPrimitiveLength() {
            return 1;
        }

        void readPrimitiveField(Object o, EntityInput input, Field field) throws IllegalAccessException, RefreshException {
            field.setBoolean(o, input.readBoolean());
        }

        void writePrimitiveField(Object o, EntityOutput output, Field field) throws IllegalAccessException {
            output.writeBoolean(field.getBoolean(o));
        }
    }
}

