/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractDriver;
import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBDatabaseMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class TSDBDriver
extends AbstractDriver {
    @Deprecated
    private static final String URL_PREFIX1 = "jdbc:TSDB://";
    public static final String URL_PREFIX = "jdbc:TAOS://";
    public static final String PROPERTY_KEY_PRODUCT_NAME = "productName";
    public static final String PROPERTY_KEY_HOST = "host";
    public static final String PROPERTY_KEY_PORT = "port";
    public static final String PROPERTY_KEY_DBNAME = "dbname";
    public static final String PROPERTY_KEY_USER = "user";
    public static final String PROPERTY_KEY_PASSWORD = "password";
    public static final String PROPERTY_KEY_TOKEN = "token";
    public static final String PROPERTY_KEY_USE_SSL = "useSSL";
    public static final String PROPERTY_KEY_CONFIG_DIR = "cfgdir";
    public static final String PROPERTY_KEY_TIME_ZONE = "timezone";
    public static final String PROPERTY_KEY_LOCALE = "locale";
    public static final String PROPERTY_KEY_CHARSET = "charset";
    public static final String PROPERTY_KEY_BATCH_LOAD = "batchfetch";
    public static final String PROPERTY_KEY_BATCH_ERROR_IGNORE = "batchErrorIgnore";
    public static final String PROPERTY_KEY_MESSAGE_WAIT_TIMEOUT = "messageWaitTimeout";
    public static final String PROPERTY_KEY_CONNECT_MODE = "conmode";
    public static final String PROPERTY_KEY_ENABLE_COMPRESSION = "enableCompression";
    public static final String PROPERTY_KEY_ENABLE_AUTO_RECONNECT = "enableAutoReconnect";
    public static final String PROPERTY_KEY_SLAVE_CLUSTER_HOST = "slaveClusterHost";
    public static final String PROPERTY_KEY_SLAVE_CLUSTER_PORT = "slaveClusterPort";
    public static final String PROPERTY_KEY_RECONNECT_INTERVAL_MS = "reconnectIntervalMs";
    public static final String PROPERTY_KEY_RECONNECT_RETRY_COUNT = "reconnectRetryCount";
    public static final String PROPERTY_KEY_DISABLE_SSL_CERT_VALIDATION = "disableSSLCertValidation";
    public static final String PROPERTY_KEY_MAX_CONCURRENT_REQUEST = "maxConcurrentRequest";
    public static final String HTTP_POOL_SIZE = "httpPoolSize";
    public static final String HTTP_KEEP_ALIVE = "httpKeepAlive";
    public static final String HTTP_CONNECT_TIMEOUT = "httpConnectTimeout";
    public static final String HTTP_SOCKET_TIMEOUT = "httpSocketTimeout";
    public static final String HTTP_TIME_ZONE = "tz";
    private TSDBDatabaseMetaData dbMetaData = null;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = this.parseURL(url, info);
        if (props == null) {
            return null;
        }
        if (!props.containsKey(PROPERTY_KEY_USER)) {
            throw TSDBError.createSQLException(8985);
        }
        if (!props.containsKey(PROPERTY_KEY_PASSWORD)) {
            throw TSDBError.createSQLException(8986);
        }
        try {
            TSDBJNIConnector.init(props);
            return new TSDBConnection(props, this.dbMetaData);
        }
        catch (SQLWarning sqlWarning) {
            return new TSDBConnection(props, this.dbMetaData);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            throw new SQLException("SQLException:" + ex, ex);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw TSDBError.createSQLException(8978);
        }
        return url.trim().length() > 0 && (url.startsWith(URL_PREFIX) || url.startsWith(URL_PREFIX1));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = this.parseURL(url, info);
        }
        return this.getPropertyInfo(info);
    }

    @Override
    public Properties parseURL(String url, Properties defaults) {
        int indexOfColon;
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? defaults : new Properties();
        if (url == null || url.length() <= 0 || url.trim().length() <= 0) {
            return null;
        }
        if (!url.startsWith(URL_PREFIX) && !url.startsWith(URL_PREFIX1)) {
            return null;
        }
        String urlForMeta = url;
        int beginningOfSlashes = url.indexOf("//");
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1);
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreElements()) {
                String oneToken = queryParams.nextToken();
                String[] pair = oneToken.split("=");
                if (pair[0] == null || pair[0].trim().length() <= 0 || pair[1] == null || pair[1].trim().length() <= 0) continue;
                urlProps.setProperty(pair[0].trim(), pair[1].trim());
            }
        }
        String dbProductName = url.substring(0, beginningOfSlashes);
        dbProductName = dbProductName.substring(dbProductName.indexOf(":") + 1);
        dbProductName = dbProductName.substring(0, dbProductName.indexOf(":"));
        urlProps.setProperty(PROPERTY_KEY_PRODUCT_NAME, dbProductName);
        url = url.substring(beginningOfSlashes + 2);
        int indexOfSlash = url.indexOf("/");
        if (indexOfSlash != -1) {
            if (indexOfSlash + 1 < url.length()) {
                urlProps.setProperty(PROPERTY_KEY_DBNAME, url.substring(indexOfSlash + 1).toLowerCase());
            }
            url = url.substring(0, indexOfSlash);
        }
        if ((indexOfColon = url.indexOf(":")) != -1) {
            if (indexOfColon + 1 < url.length()) {
                urlProps.setProperty(PROPERTY_KEY_PORT, url.substring(indexOfColon + 1));
            }
            url = url.substring(0, indexOfColon);
        }
        if (url.length() > 0 && url.trim().length() > 0) {
            urlProps.setProperty(PROPERTY_KEY_HOST, url);
        }
        this.dbMetaData = new TSDBDatabaseMetaData(urlForMeta, urlProps.getProperty(PROPERTY_KEY_USER));
        return urlProps;
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new TSDBDriver());
        }
        catch (SQLException e) {
            throw TSDBError.createRuntimeException(8976, e);
        }
    }
}

