/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.WrapperImpl;
import com.taosdata.jdbc.enums.DataType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class TSDBResultSetMetaData
extends WrapperImpl
implements ResultSetMetaData {
    private String tableName = "";
    private String database = "";
    private List<ColumnMetaData> colMetaDataList;

    public TSDBResultSetMetaData(List<ColumnMetaData> metaDataList) {
        this.colMetaDataList = metaDataList;
    }

    public TSDBResultSetMetaData(List<ColumnMetaData> metaDataList, String database, String tableName) {
        this.colMetaDataList = metaDataList;
        this.database = database;
        this.tableName = tableName;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.colMetaDataList.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return column == 1;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (column < 1 && column >= this.colMetaDataList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        if (column == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        if (column < 1 && column >= this.colMetaDataList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        ColumnMetaData meta = this.colMetaDataList.get(column - 1);
        switch (meta.getColType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        if (column < 1 && column >= this.colMetaDataList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        return this.colMetaDataList.get(column - 1).getColSize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (column < 1 && column >= this.colMetaDataList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        return this.colMetaDataList.get(column - 1).getColName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (column < 1 && column >= this.colMetaDataList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        return this.colMetaDataList.get(column - 1).getColName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (column < 1 && column >= this.colMetaDataList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (column < 1 && column >= this.colMetaDataList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        ColumnMetaData columnMetaData = this.colMetaDataList.get(column - 1);
        switch (columnMetaData.getColType()) {
            case 6: {
                return 5;
            }
            case 7: {
                return 9;
            }
            case 8: 
            case 10: {
                return columnMetaData.getColSize();
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (column < 1 && column >= this.colMetaDataList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        ColumnMetaData meta = this.colMetaDataList.get(column - 1);
        switch (meta.getColType()) {
            case 6: {
                return 5;
            }
            case 7: {
                return 9;
            }
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.tableName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.database;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnMetaData meta = this.colMetaDataList.get(column - 1);
        return DataType.convertTaosType2DataType(meta.getColType()).getJdbcTypeValue();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnMetaData meta = this.colMetaDataList.get(column - 1);
        return DataType.convertTaosType2DataType(meta.getColType()).getTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        String columnClassName = "";
        switch (columnType) {
            case 93: {
                columnClassName = Timestamp.class.getName();
                break;
            }
            case 1: {
                columnClassName = String.class.getName();
                break;
            }
            case 8: {
                columnClassName = Double.class.getName();
                break;
            }
            case 6: {
                columnClassName = Float.class.getName();
                break;
            }
            case -5: {
                columnClassName = Long.class.getName();
                break;
            }
            case 4: {
                columnClassName = Integer.class.getName();
                break;
            }
            case 5: {
                columnClassName = Short.class.getName();
                break;
            }
            case -6: {
                columnClassName = Byte.class.getName();
                break;
            }
            case -7: {
                columnClassName = Boolean.class.getName();
            }
        }
        return columnClassName;
    }
}

