/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.cache;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.provider.RedisCache;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import com.dtyunxi.vicutu.commons.cache.IVicutuCacheService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.ShardedJedis;

public class VicutuCacheServiceImpl
extends RedisCache
implements IVicutuCacheService {
    Logger logger = LoggerFactory.getLogger(VicutuCacheServiceImpl.class);

    public VicutuCacheServiceImpl(String group, CacheRegistryVo cacheRegistryVo) {
        this.init(group, cacheRegistryVo);
    }

    public void init(String group, CacheRegistryVo cacheRegistryVo) {
        super.init(group, cacheRegistryVo);
    }

    @Override
    public <T> void hset(String key, String cacheField, T cacheObj) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        JedisCluster jedisCluster = null;
        String combineKey = this.combineKey(this.group, key);
        String value = JSON.toJSONString(cacheObj);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            jedisCluster = this.getJedisCluster();
            if (jds != null) {
                jds.hset(combineKey, cacheField, value);
            } else if (shardedJedis != null) {
                shardedJedis.hset(combineKey, cacheField, value);
            } else if (jedisCluster != null) {
                jedisCluster.hset(combineKey, cacheField, value);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bbe\u7f6emap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={},cacheField={}, value={}", new Object[]{combineKey, cacheField, JSON.toJSONString(cacheObj), e});
            throw new RuntimeException(e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void hset(String group, String key, String cacheField, T cacheObj, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        JedisCluster jedisCluster = null;
        String combineKey = this.combineKey(group, key);
        String value = JSON.toJSONString(cacheObj);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            jedisCluster = this.getJedisCluster();
            if (jds != null) {
                jds.hset(combineKey, cacheField, value);
                this.expire(combineKey, seconds);
            } else if (shardedJedis != null) {
                shardedJedis.hset(combineKey, cacheField, value);
                shardedJedis.expire(combineKey, seconds);
            } else if (jedisCluster != null) {
                jedisCluster.hset(combineKey, cacheField, value);
                jedisCluster.expire(combineKey, seconds);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bbe\u7f6emap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={},field={},value={}", new Object[]{combineKey, cacheField, JSON.toJSONString((Object)value), e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean hdel(String key, String cacheField) {
        Boolean flag = false;
        Long result = 0L;
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        JedisCluster jedisCluster = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            jedisCluster = this.getJedisCluster();
            if (jds != null) {
                result = jds.hdel(combineKey, new String[]{cacheField});
            } else if (shardedJedis != null) {
                result = shardedJedis.hdel(combineKey, new String[]{cacheField});
            } else if (jedisCluster != null) {
                result = jedisCluster.hdel(combineKey, new String[]{cacheField});
            }
            if (result > 0L) {
                flag = true;
            }
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664map\u5143\u7d20\u6570\u636e\u51fa\u9519: key={},cacheField={}", new Object[]{combineKey, cacheField, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T hget(String key, String field, Class<T> clazz) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        JedisCluster jedisCluster = null;
        String combineKey = this.combineKey(this.group, key);
        Object cacheObj = null;
        String jsonData = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            jedisCluster = this.getJedisCluster();
            if (jds != null) {
                jsonData = jds.hget(combineKey, field);
            } else if (shardedJedis != null) {
                jsonData = shardedJedis.hget(combineKey, field);
            } else if (jedisCluster != null) {
                jsonData = jedisCluster.hget(combineKey, field);
            }
            cacheObj = this.checkRedisDataNotNull(jsonData) != false ? JSON.parseObject((String)jsonData, clazz) : null;
        }
        catch (Exception e) {
            this.logger.error("\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return (T)cacheObj;
    }

    public Boolean checkRedisDataNotNull(String jsonData) {
        return StringUtils.isNotBlank((CharSequence)jsonData) && !"null".equals(jsonData) && !"nil".equals(jsonData);
    }
}

