/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.enums.trade;

import java.util.HashMap;
import java.util.Map;

public enum ShopTypeEnum {
    ONLINE("online", "\u5e97\u94fa"),
    OFFLINE("offline", "\u95e8\u5e97"),
    FRANCHISEE("1", "\u52a0\u76df\u5546"),
    OFFICE("2", "\u529e\u4e8b\u5904"),
    FRANCHISED_STORE("3", "\u52a0\u76df\u95e8\u5e97"),
    DIRECT_STORE("4", "\u76f4\u8425\u95e8\u5e97"),
    E_COMMERCE("5", "\u7535\u5546"),
    OTHER("6", "\u5176\u4ed6");

    public static final Map<String, ShopTypeEnum> CODE_MAP;
    String code;
    String msg;

    private ShopTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static boolean isFranchise(String code) {
        return FRANCHISEE.getCode().equals(code) || FRANCHISED_STORE.getCode().equals(code);
    }

    public static boolean isFirstLevelShop(String code) {
        return FRANCHISEE.getCode().equals(code) || OFFICE.getCode().equals(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    static {
        CODE_MAP = new HashMap<String, ShopTypeEnum>(ShopTypeEnum.values().length);
        for (ShopTypeEnum orderBizTypeEnum : ShopTypeEnum.values()) {
            CODE_MAP.put(orderBizTypeEnum.getCode(), orderBizTypeEnum);
        }
    }
}

