/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import com.dtyunxi.cube.starter.oss.CubeOssProperties;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.util.DateUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CSVUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exportCsv(IObjectStorageService objectStorageService, CubeOssProperties cubeOssProperties, String fileName, List<String> dataList) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            if (dataList == null) return null;
            if (dataList.isEmpty()) return null;
            byte[] uft8bom = new byte[]{-17, -69, -65};
            os.write(uft8bom);
            for (String data : dataList) {
                os.write(data.getBytes());
                os.write("\r".getBytes());
            }
            ByteArrayInputStream in = new ByteArrayInputStream(os.toByteArray());
            String dataStr = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
            String key = cubeOssProperties.getDir() + dataStr + "/" + fileName;
            objectStorageService.put(cubeOssProperties.getBucketName(), key, (InputStream)in);
            StringBuilder sb = new StringBuilder();
            sb.append(cubeOssProperties.getEndpoint());
            sb.append("/");
            sb.append(cubeOssProperties.getDir());
            sb.append(dataStr);
            sb.append("/");
            sb.append(fileName);
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> importCsv(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            List<String> list = CSVUtils.read(new BufferedInputStream(in));
            return list;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            in = null;
        }
        return new ArrayList<String>();
    }

    private static List<String> read(InputStream in) {
        ArrayList<String> dataList = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, CSVUtils.codeString(in)));){
            String line = "";
            while ((line = br.readLine()) != null) {
                dataList.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataList;
    }

    public static List<String> importCsv(String path) {
        File file = new File(path);
        return CSVUtils.importCsv(file);
    }

    private static String codeString(InputStream bin) throws Exception {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(bin);
            bin.mark(0);
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                return charset;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                charset = "UTF-16BE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = "UTF-8";
                checked = true;
            }
            bis.reset();
            if (!checked) {
                while ((read = bis.read()) != -1 && read < 240 && (128 > read || read > 191)) {
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
            }
            bin.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> importCsvFromServer(String fileUrl) {
        URL url = null;
        BufferedInputStream bin = null;
        try {
            url = new URL(fileUrl);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setRequestProperty("Charset", StandardCharsets.UTF_8.name());
            httpURLConnection.connect();
            bin = new BufferedInputStream(httpURLConnection.getInputStream());
            List<String> list = CSVUtils.read(bin);
            return list;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            if (null != bin) {
                try {
                    bin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            bin = null;
        }
        return new ArrayList<String>();
    }

    public static void main(String[] args) {
        List<String> list = CSVUtils.importCsvFromServer("https://vicutu-test.oss-cn-beijing.aliyuncs.com/vicutu-uat/J2wxDrNH8t.csv");
        System.out.println(list.size());
    }
}

