/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CommonUtils {
    private static final String SINGLE_WORD = "'";
    private static final String STRING_COMMA = ",";
    private static final String RESULT_MSG = "resultMsg";
    private static final int MAX = 9999;

    public static String listToStrs(List<Long> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        StringBuilder groups = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                groups.append(STRING_COMMA);
            }
            groups.append(SINGLE_WORD).append(list.get(i)).append(SINGLE_WORD);
        }
        return groups.toString();
    }

    public static String argsToString(Object object) {
        try {
            String str = JSON.toJSONString((Object)object);
            if (StringUtils.isNotEmpty((String)str) && str.length() > 9999) {
                str = str.substring(0, 9999);
            }
            return str;
        }
        catch (Exception exception) {
            return String.valueOf(object);
        }
    }

    public static String listStrToStrs(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        StringBuilder groups = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                groups.append(STRING_COMMA);
            }
            groups.append(SINGLE_WORD).append(list.get(i)).append(SINGLE_WORD);
        }
        return groups.toString();
    }

    public static synchronized String autoGenerateCode(int figure) {
        int i = 1;
        if (figure > 0) {
            for (int j = 1; j < figure; ++j) {
                i *= 10;
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date d = new Date();
        String sysDateStr = sdf.format(d).toString();
        return sysDateStr + (int)((Math.random() * 9.0 + 1.0) * (double)i);
    }

    public static void checkResponseCode(RestResponse restResponse) {
        if (restResponse == null) {
            throw new BizException("RestResponse\u4e3anull");
        }
        if ("100000".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultMsg());
        }
    }

    public static String getSelfDefineExceptionInfo(String restResponse) {
        if (StringUtils.isBlank((String)restResponse)) {
            return "";
        }
        int i = restResponse.lastIndexOf(RESULT_MSG);
        if (i < 1) {
            return restResponse;
        }
        String last = restResponse.substring(i);
        int colon = last.indexOf(":");
        int comma = last.indexOf(STRING_COMMA);
        if (colon < 1 || comma < 1 || comma <= colon) {
            return last;
        }
        return last.substring(colon + 1, comma).replace("\\", "").replace("\"", "");
    }

    public static String replaceStringTrim(String str) {
        return str.replaceAll("[\\s\\u00A0]+", "").trim();
    }
}

