/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vicutu.commons.annotation.ExcelStyle;
import com.dtyunxi.vicutu.commons.enums.excel.DataFormatEnum;
import com.dtyunxi.vicutu.commons.enums.excel.FontColorEnum;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.slf4j.Logger;

public class ExcelStyleUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelStyleUtil.class);

    public static CellStyle setBorderStyle(CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        return cellStyle;
    }

    public static CellStyle getCellStyleByFontInfo(Workbook workbook, String fontName, int fontHeightInPoints, int[] fontColorRGB, String dataFormat) {
        Objects.requireNonNull(workbook);
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName(fontName);
        font.setFontHeightInPoints((short)fontHeightInPoints);
        if (fontColorRGB.length >= 3) {
            ((XSSFFont)font).setColor(new XSSFColor(new Color(fontColorRGB[0], fontColorRGB[1], fontColorRGB[2])));
        }
        cellStyle.setWrapText(false);
        cellStyle.setFont(font);
        cellStyle.setDataFormat(workbook.createDataFormat().getFormat(dataFormat));
        return ExcelStyleUtil.setBorderStyle(cellStyle);
    }

    public static Map<String, CellStyle> initCellStyleMap(Workbook workbook) {
        Objects.requireNonNull(workbook);
        HashMap cellStyleMap = Maps.newHashMap();
        FontColorEnum[] fontColorEnums = FontColorEnum.values();
        DataFormatEnum[] dataFormatEnums = DataFormatEnum.values();
        for (int i = 0; i < fontColorEnums.length; ++i) {
            for (int j = 0; j < dataFormatEnums.length; ++j) {
                cellStyleMap.put(fontColorEnums[i].getFontColor() + dataFormatEnums[j].getDataformat(), ExcelStyleUtil.getCellStyleByFontInfo(workbook, "\u5fae\u8f6f\u96c5\u9ed1", 8, fontColorEnums[i].getFontColorRGB(), dataFormatEnums[j].getDataformat()));
            }
        }
        return cellStyleMap;
    }

    public static void setCellByField(Class clazz, String fieldName, Object object, Cell cell, Map<String, CellStyle> cellStyleMap) {
        Field field = ExcelStyleUtil.getField(clazz, fieldName);
        try {
            if (field != null) {
                field.setAccessible(true);
                String fontColor = null;
                String dataFormat = null;
                if (field.isAnnotationPresent(ExcelStyle.class)) {
                    ExcelStyle excelStyle = field.getAnnotation(ExcelStyle.class);
                    FontColorEnum fontColorEnum = excelStyle.fontColor();
                    DataFormatEnum dataFormatEnum = excelStyle.dataFormat();
                    fontColor = fontColorEnum.getFontColor();
                    dataFormat = dataFormatEnum.getDataformat();
                }
                cell.setCellStyle(cellStyleMap.get((fontColor == null ? FontColorEnum.BLACK.getFontColor() : fontColor) + (dataFormat == null ? DataFormatEnum.GENERAL.getDataformat() : dataFormat)));
                if (null == object) {
                    return;
                }
                Object value = field.get(object);
                if (value != null) {
                    switch (value.getClass().getName()) {
                        case "java.lang.String": {
                            cell.setCellValue((String)value);
                            break;
                        }
                        case "java.lang.Integer": {
                            cell.setCellValue((double)((Integer)value).intValue());
                            break;
                        }
                        case "java.lang.Long": {
                            cell.setCellValue((double)((Long)value).longValue());
                            break;
                        }
                        case "java.math.BigDecimal": {
                            cell.setCellValue(Optional.ofNullable((BigDecimal)value).orElse(BigDecimal.ZERO).doubleValue());
                            break;
                        }
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            logger.error("\u53cd\u5c04\u8bbe\u7f6e\u5355\u5143\u683c\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
    }

    public static Field getField(Class clazz, String fieldName) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            return fields[i];
        }
        Class superclazz = clazz.getSuperclass();
        if (superclazz != null) {
            return ExcelStyleUtil.getField(superclazz, fieldName);
        }
        return null;
    }
}

