/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import com.dtyunxi.cube.starter.oss.CubeOssProperties;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getExcelUpload(CubeOssProperties cubeOssProperties, IObjectStorageService objectStorageService, Workbook wb, String fileName) {
        ByteArrayOutputStream os = null;
        ByteArrayInputStream in = null;
        try {
            os = new ByteArrayOutputStream();
            wb.write((OutputStream)os);
            in = new ByteArrayInputStream(os.toByteArray());
            objectStorageService.put(cubeOssProperties.getBucketName(), cubeOssProperties.getDir() + fileName, (InputStream)in);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406excel\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (Exception e) {
                    logger.error("\u5173\u95edworkbook\u5931\u8d25");
                }
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95edos\u6d41\u5931\u8d25");
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95edin\u6d41\u5931\u8d25");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getExcelDownload(IObjectStorageService objectStorageService, String fileName) {
        ByteArrayInputStream in = null;
        ByteArrayOutputStream os = null;
        try {
            os = (ByteArrayOutputStream)objectStorageService.get(fileName);
            in = new ByteArrayInputStream(os.toByteArray());
        }
        catch (Exception e) {
            logger.error("\u5904\u7406excel\u4e0b\u8f7d\u5931\u8d25");
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95edos\u6d41\u5931\u8d25");
            }
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95edin\u6d41\u5931\u8d25");
            }
        }
        return in;
    }
}

