/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.vicutu.commons.dto.ExportPageDto;
import com.dtyunxi.vicutu.commons.util.IExportService;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class ExportFileUtils<REQ extends ExportPageDto, RESP> {
    private static final Logger logger = LoggerFactory.getLogger(ExportFileUtils.class);
    @Value(value="${huieryun.ossregistryvo.maxSize:100000}")
    public Integer MAX_SIZE;
    @Value(value="${huieryun.ossregistryvo.fileCountLimit:20000}")
    private Integer fileCountLimit;
    @Value(value="${huieryun.ossregistryvo.bucketName}")
    private String bucketName;
    @Value(value="${huieryun.ossregistryvo.endpoint}")
    private String endpoint;
    @Resource
    private IObjectStorageService objectStorageService;

    public String upload(IExportService<REQ, RESP> exportService, String fileName, REQ req, Class<RESP> clazz) {
        List<RESP> list = exportService.submit(req);
        int size = list.size();
        long startTime = System.currentTimeMillis();
        String url = this.uploadOss(fileName, clazz, list);
        long endTime = System.currentTimeMillis();
        logger.info("\u672c\u6b21\u5bfc\u51fa\u4e0a\u4f20\u65f6\u957f{}, \u5bfc\u51fa\u6761\u6570{}", (Object)(endTime - startTime), (Object)size);
        return url;
    }

    public String dynamicUpload(IExportService<REQ, RESP> exportService, String fileName, REQ req) {
        List<RESP> list = exportService.submit(req);
        int size = list.size();
        long startTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(((ExportPageDto)req).getStyles())) {
            throw new BizException(fileName + "\u5bfc\u51fa\u7684Excel\u6837\u5f0f\u4e3a\u7a7a");
        }
        ArrayList<ExcelExportEntity> colList = new ArrayList<ExcelExportEntity>();
        ((ExportPageDto)req).getStyles().forEach(export -> colList.add(new ExcelExportEntity(export.getName(), (Object)export.getField(), 20)));
        ArrayList exportData = new ArrayList();
        HashMap map = new HashMap();
        list.forEach(data -> {
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)data));
            req.getStyles().forEach(export -> map.put(export.getField(), jsonObject.get((Object)export.getField())));
            exportData.add(map);
        });
        String url = this.uploadOss(fileName, colList, list);
        long endTime = System.currentTimeMillis();
        logger.info("\u672c\u6b21\u5bfc\u51fa\u4e0a\u4f20\u65f6\u957f{}, \u5bfc\u51fa\u6761\u6570{}", (Object)(endTime - startTime), (Object)size);
        return url;
    }

    public List<String> uploadBatch(IExportService<REQ, RESP> exportService, String fileName, REQ req, Class<RESP> clazz) {
        List<RESP> list = exportService.submit(req);
        int size = list.size();
        if (this.fileCountLimit >= size) {
            return Lists.newArrayList((Object[])new String[]{this.uploadOss(fileName, clazz, list)});
        }
        long startTime = System.currentTimeMillis();
        int limitCount = (int)Math.ceil((double)size / (double)this.fileCountLimit.intValue());
        CompletableFuture[] completableFutures = new CompletableFuture[limitCount];
        for (int i = 1; i <= limitCount; ++i) {
            String name = fileName + "_" + i;
            int startSize = this.fileCountLimit * (i - 1);
            int endSize = i == limitCount ? size : this.fileCountLimit * i;
            ArrayList<RESP> minList = new ArrayList<RESP>(list.subList(startSize, endSize));
            completableFutures[i - 1] = CompletableFuture.supplyAsync(() -> this.uploadOss(name, clazz, minList));
        }
        CompletableFuture.allOf(completableFutures);
        long endTime = System.currentTimeMillis();
        List<String> urls = Stream.of(completableFutures).map(CompletableFuture::join).collect(Collectors.toList());
        logger.info("\u5bfc\u51fa\u5b8c\u6210,\u672c\u6b21\u5bfc\u51fa\u4e0a\u4f20\u65f6\u957f:{}, \u5bfc\u51fa\u6761\u6570:{}", (Object)(endTime - startTime), (Object)list.size());
        return urls;
    }

    @NonNull
    public String uploadOss(String fileName, List<ExcelExportEntity> clazz, List<RESP> list) {
        fileName = fileName + "_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xlsx";
        ExportParams params = new ExportParams(fileName, "", ExcelType.XSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, clazz, list);
        return this.getUploadOssUrl(fileName, workbook);
    }

    @NonNull
    private String getUploadOssUrl(String fileName, Workbook workbook) {
        String url;
        ByteArrayOutputStream fos = null;
        try {
            url = this.endpoint + "/" + URLEncoder.encode(fileName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BizException(fileName + "\u6587\u4ef6\u540d\u79f0\u8f6c\u6362\u5f02\u5e38");
        }
        try {
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            fos.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            logger.info("\u4e0a\u4f20oss\u5f00\u59cb.");
            this.objectStorageService.put(this.bucketName, fileName, (InputStream)byteArrayInputStream);
        }
        catch (Exception ex) {
            logger.error("{}\u5bfc\u51faexcel\u5f02\u5e38{}", new Object[]{fileName, ex.getMessage(), ex});
            throw new BizException(fileName + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
        finally {
            try {
                if (fos != null) {
                    logger.info("\u5173\u95ed\u6587\u4ef6\u6d41.");
                    fos.close();
                }
            }
            catch (IOException ex) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38", (Throwable)ex);
            }
        }
        return url.replaceFirst("-internal", "");
    }

    @NonNull
    public String uploadOss(String fileName, Class<RESP> clazz, List<RESP> list) {
        fileName = fileName + "_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xlsx";
        ExportParams params = new ExportParams(fileName, "", ExcelType.XSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, clazz, list);
        return this.getUploadOssUrl(fileName, workbook);
    }
}

