/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static void getUploadInformation(String path, String mode, String obj) {
        try {
            URL url = new URL(path);
            StringBuffer sbuffer = null;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod(mode);
            connection.setRequestProperty("Host", "*******");
            connection.setRequestProperty("Content-Type", " application/json");
            connection.setRequestProperty("Accept-Charset", "utf-8");
            connection.setRequestProperty("X-Auth-Token", "token");
            connection.setRequestProperty("Connection", "keep-alive");
            connection.setRequestProperty("Transfer-Encoding", "chunked");
            connection.setRequestProperty("Content-Length", obj.toString().getBytes().length + "");
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            connection.connect();
            OutputStream out = connection.getOutputStream();
            out.write(obj.toString().getBytes());
            out.flush();
            out.close();
            if (200 == connection.getResponseCode()) {
                String lines;
                InputStreamReader inputStream = new InputStreamReader(connection.getInputStream());
                BufferedReader reader = new BufferedReader(inputStream);
                sbuffer = new StringBuffer("");
                while ((lines = reader.readLine()) != null) {
                    lines = new String(lines.getBytes(), "utf-8");
                    sbuffer.append(lines);
                }
                reader.close();
            } else {
                logger.error("\u8bf7\u6c42\u5931\u8d25:{}", (Object)connection.getResponseCode());
            }
            connection.disconnect();
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String invokeUrl(String url, String params, Map<String, String> headers, HttpContentType httpContentType, HttpMethod method) {
        logger.info("\u8c03\u7528\u63a5\u53e3[" + url + "]\uff0c\u53c2\u6570\uff1a" + params);
        if (StringUtils.isNotEmpty((CharSequence)params) && method == HttpMethod.GET) {
            url = url + "?" + params;
        }
        URL uUrl = null;
        HttpURLConnection conn = null;
        OutputStream out = null;
        BufferedReader in = null;
        try {
            String line;
            uUrl = new URL(url);
            conn = (HttpURLConnection)uUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            if (httpContentType == HttpContentType.Json) {
                conn.setRequestProperty("content-type", "application/json");
            } else {
                conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            }
            conn.setRequestMethod(method.toString());
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            if (headers != null && headers.size() > 0) {
                Set<String> headerSet = headers.keySet();
                for (String key : headerSet) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)params) && method != HttpMethod.GET) {
                out = conn.getOutputStream();
                out.write(params.getBytes());
                out.flush();
            }
            StringBuilder result = new StringBuilder();
            if (conn.getResponseCode() == 200) {
                in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                if (in != null) {
                    line = "";
                    while ((line = in.readLine()) != null) {
                        result.append(line);
                    }
                }
            } else {
                result.append(conn.getResponseCode());
            }
            line = result.toString();
            return line;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63a5\u53e3[" + url + "]\u5931\u8d25\uff01\u8bf7\u6c42URL\uff1a" + url + "\uff0c\u53c2\u6570\uff1a" + params + " ,error: {}", (Object)e.toString());
            try {
                byte[] buf = new byte[100];
                InputStream es = conn.getErrorStream();
                if (es != null) {
                    while (es.read(buf) > 0) {
                    }
                    es.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    private static String buildFormParams(Map params) {
        StringBuilder paramsStr = null;
        if (params != null) {
            paramsStr = new StringBuilder();
            Set entries = params.entrySet();
            for (Map.Entry entry : entries) {
                String value = entry.getValue() != null ? String.valueOf(entry.getValue()) : "";
                paramsStr.append(entry.getKey() + "=" + value + "&");
            }
        }
        return paramsStr.toString();
    }

    public static String postJson(String url, String params, Map<String, String> headers) {
        return HttpUtils.invokeUrl(url, params, headers, HttpContentType.Json, HttpMethod.POST);
    }

    public static String postJson(String url, String params) {
        return HttpUtils.invokeUrl(url, params, null, HttpContentType.Json, HttpMethod.POST);
    }

    public static String postForm(String url, Map mapParams, Map<String, String> headers) {
        String params = HttpUtils.buildFormParams(mapParams);
        return HttpUtils.invokeUrl(url, params, headers, HttpContentType.Form, HttpMethod.POST);
    }

    public static String postForm(String url, Map mapParams) {
        String params = HttpUtils.buildFormParams(mapParams);
        return HttpUtils.invokeUrl(url, params, null, HttpContentType.Form, HttpMethod.POST);
    }

    public static String getForm(String url, Map mapParams) {
        String params = HttpUtils.buildFormParams(mapParams);
        return HttpUtils.invokeUrl(url, params, null, HttpContentType.Form, HttpMethod.GET);
    }

    public static String getJson(String url, Map mapParams) {
        String params = HttpUtils.buildFormParams(mapParams);
        return HttpUtils.invokeUrl(url, params, null, HttpContentType.Json, HttpMethod.GET);
    }

    public static String putJson(String url, String params) {
        return HttpUtils.invokeUrl(url, params, null, HttpContentType.Json, HttpMethod.PUT);
    }

    public static enum HttpContentType {
        Form,
        Json;

    }

    public static enum HttpMethod {
        POST,
        DELETE,
        GET,
        PUT,
        HEAD;

    }
}

