/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.vicutu.commons.dto.ExportPageDto;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;

public interface IExportService<REQ extends ExportPageDto, RESP> {
    public static final int ASYNC_FLAG = 2;
    public static final AtomicInteger cacheClearCount = new AtomicInteger(1);
    @Value(value="${huieryun.ossregistryvo.singleQueryCount:10000}")
    public static final Integer singleQueryCount = 20000;
    @Value(value="${huieryun.ossregistryvo.maxSize:100000}")
    public static final Integer MAX_SIZE = 100000;
    public static final int POOL_SIZE = 4 > Runtime.getRuntime().availableProcessors() ? 8 : Runtime.getRuntime().availableProcessors() << 1;
    public static final ForkJoinPool FK_POOL = new ForkJoinPool(POOL_SIZE);

    public PageInfo<RESP> fetchData(REQ var1);

    default public CompletableFuture<PageInfo<RESP>> fetchDataAsync(REQ req) {
        AtomicReference<ExportPageDto> reference = new AtomicReference<ExportPageDto>();
        try {
            String json = JSON.toJSONString(req);
            ExportPageDto reqClone = (ExportPageDto)JSON.parseObject((String)json, req.getClass());
            if (reqClone != null) {
                reference.set(reqClone);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CompletableFuture.supplyAsync(() -> this.fetchData((ExportPageDto)reference.get()), FK_POOL);
    }

    default public List<RESP> submit(REQ req) {
        PageInfo<RESP> join = this.fetchData(req);
        List respList = join.getList();
        if (join.getTotal() > (long)((ExportPageDto)req).getPageSize().intValue()) {
            int times;
            int i = (int)Math.ceil((double)join.getTotal() / (double)((ExportPageDto)req).getPageSize().intValue());
            if (i > (times = MAX_SIZE / ((ExportPageDto)req).getPageSize())) {
                i = times;
            }
            if (2 == i) {
                ((ExportPageDto)req).setPageNum(i);
                PageInfo<RESP> join2 = this.fetchData(req);
                respList.addAll(join2.getList());
                return respList;
            }
            cacheClearCount.addAndGet(i - 1);
            CompletableFuture[] list = new CompletableFuture[i - 1];
            for (int j = 0; j < i - 1; ++j) {
                ((ExportPageDto)req).setPageNum(j + 2);
                list[j] = this.fetchDataAsync(req);
            }
            CompletableFuture.allOf(list);
            Stream.of(list).map(CompletableFuture::join).sorted(Comparator.comparing(PageInfo::getPageNum)).forEach(y -> {
                if (CollectionUtils.isNotEmpty((Collection)y.getList())) {
                    respList.addAll(y.getList());
                }
            });
        }
        return respList;
    }
}

