/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class IPWhiteListUtil {
    private static Pattern pattern = Pattern.compile("(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})");

    public static Set<String> getAvaliIpList(String allowIp) {
        HashSet<String> ipList = new HashSet<String>();
        for (String allow : allowIp.replaceAll("\\s", "").split(";")) {
            if (allow.indexOf("*") > -1) {
                String[] ips = allow.split("\\.");
                String[] from = new String[]{"0", "0", "0", "0"};
                String[] end = new String[]{"255", "255", "255", "255"};
                List<Object> tem = new ArrayList();
                for (int i = 0; i < ips.length; ++i) {
                    if (ips[i].indexOf("*") > -1) {
                        tem = IPWhiteListUtil.complete(ips[i]);
                        from[i] = null;
                        end[i] = null;
                        continue;
                    }
                    from[i] = ips[i];
                    end[i] = ips[i];
                }
                StringBuffer fromIP = new StringBuffer();
                StringBuffer endIP = new StringBuffer();
                for (int i = 0; i < 4; ++i) {
                    if (from[i] != null) {
                        fromIP.append(from[i]).append(".");
                        endIP.append(end[i]).append(".");
                        continue;
                    }
                    fromIP.append("[*].");
                    endIP.append("[*].");
                }
                fromIP.deleteCharAt(fromIP.length() - 1);
                endIP.deleteCharAt(endIP.length() - 1);
                for (String string : tem) {
                    String ip = fromIP.toString().replace("[*]", string.split(";")[0]) + "-" + endIP.toString().replace("[*]", string.split(";")[1]);
                    if (!IPWhiteListUtil.validate(ip)) continue;
                    ipList.add(ip);
                }
                continue;
            }
            if (!IPWhiteListUtil.validate(allow)) continue;
            ipList.add(allow);
        }
        return ipList;
    }

    public static Set<String> getAvaliIpList(Set<String> ipSet) {
        HashSet<String> ipList = new HashSet<String>();
        for (String allow : ipSet) {
            if (allow.indexOf("*") > -1) {
                String[] ips = allow.split("\\.");
                String[] from = new String[]{"0", "0", "0", "0"};
                String[] end = new String[]{"255", "255", "255", "255"};
                List<Object> tem = new ArrayList();
                for (int i = 0; i < ips.length; ++i) {
                    if (ips[i].indexOf("*") > -1) {
                        tem = IPWhiteListUtil.complete(ips[i]);
                        from[i] = null;
                        end[i] = null;
                        continue;
                    }
                    from[i] = ips[i];
                    end[i] = ips[i];
                }
                StringBuffer fromIP = new StringBuffer();
                StringBuffer endIP = new StringBuffer();
                for (int i = 0; i < 4; ++i) {
                    if (from[i] != null) {
                        fromIP.append(from[i]).append(".");
                        endIP.append(end[i]).append(".");
                        continue;
                    }
                    fromIP.append("[*].");
                    endIP.append("[*].");
                }
                fromIP.deleteCharAt(fromIP.length() - 1);
                endIP.deleteCharAt(endIP.length() - 1);
                for (String string : tem) {
                    String ip = fromIP.toString().replace("[*]", string.split(";")[0]) + "-" + endIP.toString().replace("[*]", string.split(";")[1]);
                    if (!IPWhiteListUtil.validate(ip)) continue;
                    ipList.add(ip);
                }
                continue;
            }
            if (!IPWhiteListUtil.validate(allow)) continue;
            ipList.add(allow);
        }
        return ipList;
    }

    private static List<String> complete(String arg) {
        ArrayList<String> com = new ArrayList<String>();
        if (arg.length() == 1) {
            com.add("0;255");
        } else if (arg.length() == 2) {
            String s2;
            String s1 = IPWhiteListUtil.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
            if ((s2 = IPWhiteListUtil.complete(arg, 2)) != null) {
                com.add(s2);
            }
        } else {
            String s1 = IPWhiteListUtil.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
        }
        return com;
    }

    private static String complete(String arg, int length) {
        String from = "";
        String end = "";
        if (length == 1) {
            from = arg.replace("*", "0");
            end = arg.replace("*", "9");
        } else {
            from = arg.replace("*", "00");
            end = arg.replace("*", "99");
        }
        if (Integer.valueOf(from) > 255) {
            return null;
        }
        if (Integer.valueOf(end) > 255) {
            end = "255";
        }
        return from + ";" + end;
    }

    private static boolean validate(String ip) {
        for (String s : ip.split("-")) {
            if (pattern.matcher(s).matches()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkLoginIP(String ip, Set<String> ipList) {
        if (ipList.contains(ip)) {
            return true;
        }
        for (String allow : ipList) {
            if (allow.indexOf("-") <= -1) continue;
            String[] from = allow.split("-")[0].split("\\.");
            String[] end = allow.split("-")[1].split("\\.");
            String[] tag = ip.split("\\.");
            boolean check = true;
            for (int i = 0; i < 4; ++i) {
                int s = Integer.valueOf(from[i]);
                int t = Integer.valueOf(tag[i]);
                int e = Integer.valueOf(end[i]);
                if (s <= t && t <= e) continue;
                check = false;
                break;
            }
            if (!check) continue;
            return true;
        }
        return false;
    }

    public static boolean checkLoginIP(String ip, String ipWhiteConfig) {
        Set<String> ipList = IPWhiteListUtil.getAvaliIpList(ipWhiteConfig);
        return IPWhiteListUtil.checkLoginIP(ip, ipList);
    }

    public static boolean checkIpList(String ip, List<String> ipList) {
        Set<String> ipSet = new HashSet<String>();
        for (String ipStr : ipList) {
            if (ipStr.trim().startsWith("#")) continue;
            ipSet.add(ipStr.trim());
        }
        ipSet = IPWhiteListUtil.getAvaliIpList(ipSet);
        return IPWhiteListUtil.checkLoginIP(ip, ipSet);
    }

    public static boolean checkIp(String ip, String ipStr) {
        Set<String> ipSet = new HashSet<String>();
        if (!ipStr.trim().startsWith("#")) {
            ipSet.add(ipStr.trim());
        }
        ipSet = IPWhiteListUtil.getAvaliIpList(ipSet);
        return IPWhiteListUtil.checkLoginIP(ip, ipSet);
    }

    public static void main(String[] args) {
        String ipWhilte = "192.168.1.1;192.168.2.*;192.168.3.17-192.168.3.38";
        boolean flag = IPWhiteListUtil.checkLoginIP("192.168.2.2", ipWhilte);
        System.out.println(flag);
    }
}

