/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import com.dtyunxi.vicutu.commons.util.AssertUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LocalDateTimeUtil {
    private static final int ZERO = 0;
    private static final int LAST_HOUR = 23;
    private static final int LAST_SECOND = 59;
    public static final int ONE_DAY = 86400;

    @CheckReturnValue
    public static LocalDateTime getStartDate() {
        return LocalDateTimeUtil.getLocalDate(0, 0, 0);
    }

    @CheckReturnValue
    public static String getStartDateForString() {
        return new Action1<Object, TimeEnum, LocalDateTime>().call(null, TimeEnum.DATETIME_FORMAT, LocalDateTimeUtil.getStartDate());
    }

    private static LocalDateTime getLocalDate(int hour, int minute, int second) {
        return LocalDateTime.now().withHour(hour).withMinute(minute).withSecond(second);
    }

    @CheckReturnValue
    public static LocalDateTime getEndDate() {
        return LocalDateTimeUtil.getLocalDate(23, 59, 59);
    }

    @CheckReturnValue
    public static String getEndDateForString() {
        return new Action1<Object, TimeEnum, LocalDateTime>().call(null, TimeEnum.DATETIME_FORMAT, LocalDateTimeUtil.getEndDate());
    }

    @CheckReturnValue
    @Nullable
    public static Long getLong(@NonNull String time) {
        Objects.requireNonNull(time);
        return new Action2<String, TimeEnum, Object>().call(time, TimeEnum.DATETIME_FORMAT, null).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    @CheckReturnValue
    @Nullable
    public static LocalDateTime parseString(@NonNull String time) {
        Objects.requireNonNull(time);
        return new Action2<String, TimeEnum, Object>().call(time, TimeEnum.DATETIME_FORMAT, null);
    }

    @CheckReturnValue
    @Nullable
    public static LocalDateTime parseString(@NonNull String time, @NonNull TimeEnum pattern) {
        Objects.requireNonNull(time);
        Objects.requireNonNull(pattern);
        return new Action2<String, TimeEnum, Object>().call(time, pattern, null);
    }

    @CheckReturnValue
    @Nullable
    public static String format(@NonNull LocalDateTime localDateTime, @NonNull TimeEnum pattern) {
        Objects.requireNonNull(localDateTime);
        Objects.requireNonNull(pattern);
        return new Action1<Object, TimeEnum, LocalDateTime>().call(null, pattern, localDateTime);
    }

    @CheckReturnValue
    @Nullable
    public static String format(@NonNull LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime);
        return new Action1<Object, TimeEnum, LocalDateTime>().call(null, TimeEnum.DATETIME_FORMAT, localDateTime);
    }

    @CheckReturnValue
    @Nullable
    public static String getString(@Nullable Long time) {
        return Optional.ofNullable(time).map(x -> new Action1<Object, TimeEnum, LocalDateTime>().call(null, TimeEnum.DATETIME_FORMAT, LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()))).orElse(LocalDateTimeUtil.getNow());
    }

    public static String getNow() {
        return new Action1<Object, TimeEnum, LocalDateTime>().call(null, TimeEnum.DATETIME_FORMAT, LocalDateTime.now());
    }

    @CheckReturnValue
    @NonNull
    public static LocalDateTime getInvalidTime(@NonNull Integer invalidDay) {
        Objects.requireNonNull(invalidDay);
        return LocalDateTime.now().plusDays(invalidDay.intValue());
    }

    @CheckReturnValue
    @NonNull
    public static Integer checkTime(@NonNull LocalDateTime checkTime, @NonNull LocalDateTime startTime, @NonNull LocalDateTime endTime) {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(endTime);
        Objects.requireNonNull(checkTime);
        if (checkTime.isBefore(startTime)) {
            return -1;
        }
        if (checkTime.isAfter(endTime)) {
            return 1;
        }
        return 0;
    }

    @CheckReturnValue
    public static String getPattern(@NonNull TimeEnum pattern, @Nullable Long time) {
        Objects.requireNonNull(pattern, "time format pattern can not be null");
        Instant times = Instant.ofEpochMilli(time);
        LocalDateTime dateTime = LocalDateTime.ofInstant(times, ZoneId.systemDefault());
        DateTimeFormatter format = DateTimeFormatter.ofPattern(pattern.code, Locale.CHINA);
        return format.format(dateTime);
    }

    static class Action2<S extends String, P extends TimeEnum, D extends LocalDateTime>
    implements Action0<D, S, P, D> {
        Action2() {
        }

        @Override
        public D call(@NonNull S s, @NonNull P p, @Nullable D d) {
            Objects.requireNonNull(s);
            Objects.requireNonNull(p);
            return (D)LocalDateTime.parse(s, DateTimeFormatter.ofPattern(((TimeEnum)((Object)p)).getCode(), Locale.CHINA));
        }
    }

    static class Action1<S extends String, P extends TimeEnum, D extends LocalDateTime>
    implements Action0<S, S, P, D> {
        Action1() {
        }

        @Override
        @Nullable
        @CheckReturnValue
        public S call(@Nullable S s, @NonNull P p, @Nullable D d) {
            Objects.requireNonNull(p, "time format pattern can not be null");
            AssertUtil.isNotAllNull("time String and LocalDateTime can not be null at the same time", s, d);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(((TimeEnum)((Object)p)).getCode(), Locale.CHINA);
            return (S)Optional.ofNullable(d).map(formatter::format).orElseGet(() -> Optional.ofNullable(s).map(y -> formatter.format(LocalDateTime.parse(s, formatter))).orElse(null));
        }
    }

    static interface Action0<O, S, P, D> {
        public O call(S var1, P var2, D var3);
    }

    public static enum TimeEnum {
        DATETIME_FORMAT("yyyy-MM-dd HH:mm:ss"),
        ALL_DATE("yyyy-MM-dd HH:mm"),
        ALL_TIME("yyyyMMdd"),
        HOR_FORMAT("HH:mm:ss"),
        DATETIME_FORMAT_FIRST_TIME("yyyy-MM-dd 00:00:00"),
        DATETIME_FORMAT_END_TIME("yyyy-MM-dd 23:59:59"),
        FIRST_TIME(" 00:00:00"),
        END_TIME(" 23:59:59"),
        DATE_FORMAT("yyyy-MM-dd"),
        DATE_TODAY("yyMMdd"),
        DATE_MONTH_AND_DAY("MMdd"),
        DATE_ALL_TIME("yyyyMMddHHmmss");

        private final String code;

        private TimeEnum(String val) {
            this.code = val;
        }

        public String getCode() {
            return this.code;
        }
    }
}

