/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vicutu.commons.util.Consumer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service(value="repeatFilter")
public class RepeatFilter {
    private static final Logger logger = LoggerFactory.getLogger(RepeatFilter.class);
    private static final String REPEAT_FLAG_KEY = "REPEAT_FLAG_KEY";
    private static final Integer DEFAULT_LOCK_TIME = 10;
    @Resource
    private ICacheService cacheService;

    public void checkRepeat(String uniqueKey, Consumer consumer, boolean exception) {
        this.checkRepeat(uniqueKey, consumer, exception, "\u64cd\u4f5c\u9891\u7e41", DEFAULT_LOCK_TIME, () -> {});
    }

    public void checkRepeat(String uniqueKey, Consumer consumer, boolean exception, int time) {
        this.checkRepeat(uniqueKey, consumer, exception, "\u64cd\u4f5c\u9891\u7e41", time, () -> {});
    }

    public void checkRepeat(String uniqueKey, Consumer consumer, boolean exception, int time, Consumer falseConsumer) {
        this.checkRepeat(uniqueKey, consumer, exception, "", time, falseConsumer);
    }

    public void checkRepeat(String uniqueKey, Consumer consumer, boolean exception, String msg, int time, Consumer falseConsumer) {
        if (StringUtils.isEmpty((String)uniqueKey) || this.getRepeatFlag(uniqueKey, time)) {
            logger.info("\u552f\u4e00\u503c[{}]\u975e\u91cd\u590d\u6d88\u8d39,\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u5904\u7406", (Object)uniqueKey);
            consumer.accept();
            this.remove(uniqueKey);
        } else {
            logger.info("\u552f\u4e00\u503c[{}]\u91cd\u590d\u6d88\u8d39,\u4e0d\u5904\u7406", (Object)uniqueKey);
            if (exception) {
                throw new BizException(msg);
            }
        }
    }

    public void checkRepeat(String uniqueKey, Consumer consumer, boolean exception, String msg, int time) {
        this.checkRepeat(uniqueKey, consumer, exception, msg, time, () -> {});
    }

    public boolean getRepeatFlag(@NonNull String key, int time) {
        String comKey = this.combineKey(REPEAT_FLAG_KEY, key);
        Long set = this.cacheService.setnx(comKey, "1");
        this.cacheService.expire(comKey, time);
        return Objects.equals(1L, set);
    }

    public void remove(String key) {
        Objects.requireNonNull(key);
        this.cacheService.delCache(this.combineKey(REPEAT_FLAG_KEY, key));
    }

    public void lock(String key, int time) {
        Objects.requireNonNull(key);
        this.cacheService.add(key, (Object)"1", time);
    }

    private String combineKey(String ... keys) {
        List<String> keyList = Arrays.asList(keys);
        return StringUtils.join(keyList, (String)":");
    }
}

