/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.vicutu.commons.util;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.lang.NonNull;

public class SqlFilterBuilder<T extends BaseEo> {
    private final List<SqlFilter> filters = Lists.newArrayList();
    private T eo;

    public SqlFilterBuilder() {
    }

    public SqlFilterBuilder(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        this.eo = (BaseEo)clazz.newInstance();
        this.eo.setSqlFilters(this.filters);
    }

    public static SqlFilterBuilder<BaseEo> create() {
        return new SqlFilterBuilder<BaseEo>();
    }

    @NonNull
    public static <T extends BaseEo> SqlFilterBuilder<T> create(Class<T> clazz) {
        try {
            return new SqlFilterBuilder<T>(clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public SqlFilterBuilder<T> eq(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.eq((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> ge(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.ge((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> gt(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.gt((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> in(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.in((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> in(String property, List<Long> ids) {
        if (this.isAdd(property, ids) && CollectionUtils.isNotEmpty(ids)) {
            this.filters.add(SqlFilter.in((String)property, ids));
        } else {
            ArrayList list = Lists.newArrayList();
            list.add(-9999999L);
            this.filters.add(SqlFilter.in((String)property, (Object)list));
        }
        return this;
    }

    public SqlFilterBuilder<T> inExt(String property, List<Long> ids) {
        if (this.isAdd(property, ids) && CollectionUtils.isNotEmpty(ids)) {
            this.filters.add(SqlFilter.in((String)property, ids));
        }
        return this;
    }

    public SqlFilterBuilder<T> inString(String property, List<String> ids) {
        if (this.isAdd(property, ids) && CollectionUtils.isNotEmpty(ids)) {
            this.filters.add(SqlFilter.in((String)property, ids));
        }
        return this;
    }

    public SqlFilterBuilder<T> isNotNull(String property) {
        if (this.isAdd(property)) {
            this.filters.add(SqlFilter.isNotNull((String)property));
        }
        return this;
    }

    public SqlFilterBuilder<T> isNull(String property) {
        if (this.isAdd(property)) {
            this.filters.add(SqlFilter.isNull((String)property));
        }
        return this;
    }

    public SqlFilterBuilder<T> le(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.le((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> like(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.like((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> allLike(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.like((String)property, (Object)("%" + value + "%")));
        }
        return this;
    }

    public SqlFilterBuilder<T> leftLike(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.like((String)property, (Object)("%" + value)));
        }
        return this;
    }

    public SqlFilterBuilder<T> rightLike(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.like((String)property, (Object)(value + "%")));
        }
        return this;
    }

    public SqlFilterBuilder<T> lt(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.lt((String)property, (Object)value));
        }
        return this;
    }

    public SqlFilterBuilder<T> ne(String property, Object value) {
        if (this.isAdd(property, value)) {
            this.filters.add(SqlFilter.ne((String)property, (Object)value));
        }
        return this;
    }

    public List<SqlFilter> filters() {
        return this.filters;
    }

    public T eo() {
        return this.eo;
    }

    private boolean isAdd(String property, Object value) {
        if (Objects.nonNull(value) & value instanceof String) {
            value = ((String)value).trim();
        }
        return value instanceof String ? StringUtils.isNotBlank((String)((String)value)) && property != null : property != null && value != null;
    }

    private boolean isAdd(String property) {
        return property != null;
    }
}

