/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.dto.transform.consts;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OrderErrorType {
    GOODS_MAPPING("GOODS_MAPPING", 1001, "\u5546\u54c1\u6620\u5c04\u5f02\u5e38"),
    ADDRESS_MATCHING("ADDRESS_MATCHING", 1002, "\u5730\u5740\u5339\u914d\u5f02\u5e38"),
    SYSTEM_ERROR("SYSTEM_ERROR", 1003, "\u7cfb\u7edf\u5f02\u5e38"),
    CUSTOMER_ERROR("CUSTOMER_ERROR", 1004, "\u6838\u7b97\u5ba2\u6237\u5f02\u5e38"),
    CHANNEL_WAREHOUSE_ERROR("CHANNEL_WAREHOUSE_ERROR", 1005, "\u6e20\u9053\u4ed3\u5f02\u5e38"),
    LOGIC_WAREHOUSE_ERROR("LOGIC_WAREHOUSE_ERROR", 1006, "\u903b\u8f91\u4ed3\u5f02\u5e38"),
    LOGISTICS_ERROR("LOGISTICS_ERROR", 1010, "\u5e73\u53f0\u7269\u6d41\u6620\u5c04\u5f02\u5e38"),
    NO_ORIGINAL_ORDER_EXCEPTION("NO_ORIGINAL_ORDER_EXCEPTION", 2001, "\u65e0\u914d\u8d27\u5355\u5f02\u5e38"),
    AFTER_GOODS_MAPPING("AFTER_GOODS_MAPPING", 2002, "\u5546\u54c1\u6620\u5c04\u5f02\u5e38"),
    AFTER_SALES_WAREHOUSE_EXCEPTION("AFTER_SALES_WAREHOUSE_EXCEPTION", 2003, "\u552e\u540e\u4ed3\u5f02\u5e38"),
    SHIPPING_ERROR("SHIPPING_ERROR", 2004, "\u7269\u6d41\u4fe1\u606f\u5f02\u5e38"),
    AFTER_SYSTEM_ERROR("AFTER_SYSTEM_ERROR", 2005, "\u7cfb\u7edf\u5f02\u5e38"),
    NO_PLATFORM_ORDER_EXCEPTION("NO_PLATFORM_ORDER_EXCEPTION", 2006, "\u65e0\u5e73\u53f0\u5355\u5f02\u5e38");

    private static final Logger log;
    private final String code;
    private final Integer type;
    private final String name;

    public static OrderErrorType getByCode(String code) {
        for (OrderErrorType channel : OrderErrorType.values()) {
            if (!Objects.equals(code, channel.getCode())) continue;
            return channel;
        }
        return null;
    }

    public static String getNameByCode(String code) {
        OrderErrorType orderStatus = OrderErrorType.getByCode(code);
        if (Objects.isNull((Object)orderStatus)) {
            return "";
        }
        return orderStatus.getName();
    }

    public static OrderErrorType getByType(Integer type) {
        for (OrderErrorType channel : OrderErrorType.values()) {
            if (!Objects.equals(type, channel.getType())) continue;
            return channel;
        }
        return null;
    }

    public String joinMsg(String msg) {
        return this.getName() + ": " + msg;
    }

    public String joinMsg(String ... msg) {
        return this.getName() + ": " + StrUtil.concat((boolean)true, (CharSequence[])msg);
    }

    public static String convertExceptionType(String exceptionType) {
        if (StrUtil.isBlank((CharSequence)exceptionType)) {
            return "";
        }
        try {
            List exceptionTypeList = JSON.parseArray((String)exceptionType, String.class);
            return exceptionTypeList.stream().map(OrderErrorType::getNameByCode).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\u7c7b\u578b\u8f6c\u4e2d\u6587\u51fa\u9519exceptionType:{}  Exception:{}", (Object)exceptionType, (Object)e.getMessage());
            return "";
        }
    }

    public String getCode() {
        return this.code;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "OrderErrorType." + this.name() + "(code=" + this.getCode() + ", type=" + this.getType() + ", name=" + this.getName() + ")";
    }

    private OrderErrorType(String code, Integer type, String name) {
        this.code = code;
        this.type = type;
        this.name = name;
    }

    static {
        log = LoggerFactory.getLogger(OrderErrorType.class);
    }
}

