/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.mqc.inventory.conversion;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.BaseOrderAddressDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BaseOrderAddressPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.CsPhysicsWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseQueryDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.ThirdWarehouseReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.ThirdWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.proxy.entity.IBaseOrderAddressApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IThirdWarehouseQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.request.WmsStockEntryOrderReqDto;
import com.yunxi.dg.base.center.openapi.dto.wms.WmsItemLine;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.OrderTypeConstant;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.InOutNoticeOrderPusWmsDto;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PusWmsStockEntryOrderConvert {
    private static final Logger log = LoggerFactory.getLogger(PusWmsStockEntryOrderConvert.class);
    @Resource
    private IThirdWarehouseQueryApiProxy iThirdWarehouseQueryApiProxy;
    @Resource
    private IBaseOrderAddressApiProxy iBaseOrderAddressApiProxy;
    @Resource
    private IPhysicsWarehouseApiProxy physicsWarehouseApiProxy;

    public WmsStockEntryOrderReqDto toInPusWmsDto(InOutNoticeOrderPusWmsDto pusWmsDto) {
        AssertUtils.notBlank((String)pusWmsDto.getPhysicsWarehouseCode(), (String)"\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        PhysicsWarehouseQueryDto queryDto = new PhysicsWarehouseQueryDto();
        queryDto.setWarehouseCode(pusWmsDto.getPhysicsWarehouseCode());
        List csPhysicsWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseApiProxy.queryByParam(queryDto));
        AssertUtils.notEmpty((Collection)csPhysicsWarehouseRespDtoList, (String)"\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        CsPhysicsWarehouseRespDto physicsWarehouseRespDto = (CsPhysicsWarehouseRespDto)csPhysicsWarehouseRespDtoList.get(0);
        String linkWarehouseCode = StringUtils.isNotBlank((CharSequence)physicsWarehouseRespDto.getThirdCode()) ? physicsWarehouseRespDto.getThirdCode() : physicsWarehouseRespDto.getWarehouseCode();
        AssertUtils.notBlank((String)linkWarehouseCode, (String)"\u63a8\u9001\u7269\u7406\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        log.info("push wms in warehouse code: {}", (Object)linkWarehouseCode);
        WmsStockEntryOrderReqDto wmsStockOutOrderReqDto = new WmsStockEntryOrderReqDto();
        wmsStockOutOrderReqDto.setRemark(pusWmsDto.getRemark());
        wmsStockOutOrderReqDto.setOrderType(Optional.ofNullable(OrderTypeConstant.IN.get(pusWmsDto.getBusinessType())).orElse(OrderTypeConstant.COMMON_IN));
        wmsStockOutOrderReqDto.setBusinessType(pusWmsDto.getBusinessType());
        wmsStockOutOrderReqDto.setRelevanceNo(pusWmsDto.getRelevanceNo());
        wmsStockOutOrderReqDto.setDocumentNo(pusWmsDto.getDocumentNo());
        wmsStockOutOrderReqDto.setWarehouseCode(linkWarehouseCode);
        wmsStockOutOrderReqDto.setWarehouseName(physicsWarehouseRespDto.getWarehouseName());
        wmsStockOutOrderReqDto.setLogicWarehouseCode(pusWmsDto.getLogicWarehouseCode());
        wmsStockOutOrderReqDto.setLogicWarehouseName(pusWmsDto.getLogicWarehouseName());
        wmsStockOutOrderReqDto.setLogisticsCode(pusWmsDto.getShipmentEnterpriseCode());
        wmsStockOutOrderReqDto.setLogisticsName(pusWmsDto.getShipmentEnterpriseName());
        wmsStockOutOrderReqDto.setItemLines(pusWmsDto.getInOutNoticeOrderDetailEoList().stream().map(detailEo -> {
            WmsItemLine wmsItemLine = new WmsItemLine();
            wmsItemLine.setBatch(detailEo.getBatch());
            wmsItemLine.setItemCode(detailEo.getSkuCode());
            wmsItemLine.setCargoCode(detailEo.getSkuCode());
            if (null != detailEo.getPreOrderItemId()) {
                wmsItemLine.setTradeOrderItemId(String.valueOf(detailEo.getPreOrderItemId()));
            }
            wmsItemLine.setProductDate(DateUtil.formatDateTime((Date)detailEo.getProduceTime()));
            wmsItemLine.setArrivalDate(DateUtil.formatDateTime((Date)detailEo.getExpireTime()));
            wmsItemLine.setCargoName(detailEo.getSkuName());
            wmsItemLine.setPlanQuantity(detailEo.getPlanQuantity());
            return wmsItemLine;
        }).collect(Collectors.toList()));
        String customerId = this.getCustomerId(linkWarehouseCode);
        AssertUtils.notEmpty((String)customerId, (String)"\u7b2c\u4e09\u65b9\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u8005\u5b58\u5728\u591a\u4e2a\u7b2c\u4e09\u65b9\u4ed3\u5e93");
        wmsStockOutOrderReqDto.setCustomerId(customerId);
        List<BaseOrderAddressDto> addressDtoList = this.getReceiptAndDelivery(pusWmsDto);
        log.info("\u67e5\u8be2\u6536\u53d1\u8d27\u4fe1\u606faddressDtoList:{}", (Object)JSON.toJSONString(addressDtoList));
        if (ObjectUtil.isNotEmpty(addressDtoList)) {
            this.getDelivery(wmsStockOutOrderReqDto, addressDtoList);
        }
        log.info("transferWmsStockEntryOrderReqDto: {}", (Object)LogUtils.buildLogContent((Object)wmsStockOutOrderReqDto));
        return wmsStockOutOrderReqDto;
    }

    private List<BaseOrderAddressDto> getReceiptAndDelivery(InOutNoticeOrderPusWmsDto pusWmsDto) {
        BaseOrderAddressPageReqDto baseOrderAddressPageReqDto = new BaseOrderAddressPageReqDto();
        baseOrderAddressPageReqDto.setDocumentNo(pusWmsDto.getRelevanceNo());
        baseOrderAddressPageReqDto.setPageNum(Integer.valueOf(1));
        baseOrderAddressPageReqDto.setPageSize(Integer.valueOf(10));
        PageInfo addressDtoPageInfo = (PageInfo)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iBaseOrderAddressApiProxy.page(baseOrderAddressPageReqDto))).orElse(new PageInfo());
        List addressDtoList = addressDtoPageInfo.getList();
        return addressDtoList;
    }

    private void getDelivery(WmsStockEntryOrderReqDto wmsStockOutOrderReqDto, List<BaseOrderAddressDto> addressDtoList) {
        List deliveryrList = addressDtoList.stream().filter(o -> Objects.equals("consignor", o.getContactsType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deliveryrList)) {
            BaseOrderAddressDto baseOrderAddressDto = (BaseOrderAddressDto)deliveryrList.get(0);
            wmsStockOutOrderReqDto.setCountry(baseOrderAddressDto.getCountry());
            wmsStockOutOrderReqDto.setDistrictCode(baseOrderAddressDto.getDistrictCode());
            wmsStockOutOrderReqDto.setCity(baseOrderAddressDto.getCity());
            wmsStockOutOrderReqDto.setProvinceCode(baseOrderAddressDto.getProvinceCode());
            wmsStockOutOrderReqDto.setAreaCode(baseOrderAddressDto.getDistrictCode());
            wmsStockOutOrderReqDto.setProvince(baseOrderAddressDto.getProvince());
            wmsStockOutOrderReqDto.setPhone(baseOrderAddressDto.getPhone());
            wmsStockOutOrderReqDto.setDistrict(baseOrderAddressDto.getDistrict());
            wmsStockOutOrderReqDto.setDetailAddress(baseOrderAddressDto.getDetailAddress());
            wmsStockOutOrderReqDto.setContacts(baseOrderAddressDto.getContacts());
        }
    }

    private String getCustomerId(String linkWarehouseCode) {
        if (StringUtils.isNotEmpty((CharSequence)linkWarehouseCode)) {
            ThirdWarehouseReqDto thirdWarehouseReqDto = new ThirdWarehouseReqDto();
            thirdWarehouseReqDto.setWarehouseCode(linkWarehouseCode);
            PageInfo thirdWarehouseRespDtoPageInfo = (PageInfo)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iThirdWarehouseQueryApiProxy.queryByPage(Integer.valueOf(1), Integer.valueOf(10), thirdWarehouseReqDto))).orElse(new PageInfo());
            List warehouseRespDtoList = thirdWarehouseRespDtoPageInfo.getList();
            log.info("\u67e5\u8be2\u5230\u7b2c\u4e09\u65b9\u4ed3\u5e93\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)warehouseRespDtoList));
            if (CollectionUtils.isEmpty((Collection)warehouseRespDtoList) || warehouseRespDtoList.size() > 1) {
                return null;
            }
            ThirdWarehouseRespDto thirdWarehouseRespDto = (ThirdWarehouseRespDto)warehouseRespDtoList.get(0);
            if (StringUtils.isEmpty((CharSequence)thirdWarehouseRespDto.getCustomerId())) {
                return null;
            }
            return thirdWarehouseRespDto.getCustomerId();
        }
        return null;
    }
}

