/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.account.constants;

import java.util.Arrays;
import java.util.Objects;

public enum AccountUserTypeEnum {
    ENTERPRISE("ENTERPRISE", "\u4f01\u4e1a"),
    PERSONAL("PERSONAL", "\u4e2a\u4eba");

    private final String code;
    private final String description;

    private AccountUserTypeEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String getValueByCode(String code) {
        AccountUserTypeEnum[] values;
        for (AccountUserTypeEnum value : values = AccountUserTypeEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value.getDescription();
        }
        return "\u672a\u77e5";
    }

    public static AccountUserTypeEnum getEnumByCode(String code) {
        return Arrays.stream(AccountUserTypeEnum.values()).filter(bean -> bean.getCode().equals(code)).findFirst().orElse(null);
    }

    public static String getCodeByValue(String value) {
        return Arrays.stream(AccountUserTypeEnum.values()).filter(bean -> Objects.equals(bean.getDescription(), value)).findFirst().map(AccountUserTypeEnum::getCode).orElse(null);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

