/*
 * Decompiled with CFR 0.152.
 */
package com.wh.center.data.api.dto.response;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.wh.center.data.api.dto.response.AreaNodeDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AreaMatchRespDto {
    private List<AreaNodeDto> provinces;
    @JsonIgnore
    private transient Map<String, AreaNodeDto> map;

    public void process() {
        this.map = new HashMap<String, AreaNodeDto>();
        this.processParentField(this.provinces);
        this.processMap(this.provinces);
    }

    private void processParentField(List<AreaNodeDto> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        list.forEach(node -> Optional.ofNullable(node.getChildren()).ifPresent(children -> {
            children.forEach(child -> child.setParent((AreaNodeDto)node));
            this.processParentField((List<AreaNodeDto>)children);
        }));
    }

    private void processMap(List<AreaNodeDto> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        list.forEach(node -> {
            this.keys((AreaNodeDto)node).forEach(key -> this.map.put((String)key, (AreaNodeDto)node));
            this.processMap(node.getChildren());
        });
    }

    private List<String> keys(AreaNodeDto node) {
        return node.names().stream().map(k -> {
            String parentCode = node.getParent() == null ? "" : node.getParent().getCode();
            return AreaMatchRespDto.key(parentCode, node.getLevelId(), k);
        }).collect(Collectors.toList());
    }

    public static String key(String parentCode, Integer levelId, String childName) {
        return "Area:Name:" + (StrUtil.isNotBlank((CharSequence)parentCode) ? parentCode : "0") + "-" + levelId + "-" + childName;
    }

    public AreaNodeDto matchAndSet(AreaNodeDto parent, int levelId, Supplier<String> getter, Consumer<String> nameSetter) {
        return this.matchAndSet(parent, levelId, getter, null, nameSetter);
    }

    public AreaNodeDto matchAndSet(AreaNodeDto parent, int levelId, Supplier<String> getter, Consumer<String> codeSetter, Consumer<String> nameSetter) {
        String parentCode = parent == null ? "0" : parent.getCode();
        String key = AreaMatchRespDto.key(parentCode, levelId, getter.get());
        AreaNodeDto node = this.map.get(key);
        if (node != null && codeSetter != null && node.getCode() != null) {
            codeSetter.accept(node.getCode());
        }
        if (node != null && nameSetter != null && node.getName() != null) {
            nameSetter.accept(node.getName());
        }
        return node;
    }

    public List<AreaNodeDto> getProvinces() {
        return this.provinces;
    }

    public Map<String, AreaNodeDto> getMap() {
        return this.map;
    }

    public void setProvinces(List<AreaNodeDto> provinces) {
        this.provinces = provinces;
    }

    @JsonIgnore
    public void setMap(Map<String, AreaNodeDto> map) {
        this.map = map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AreaMatchRespDto)) {
            return false;
        }
        AreaMatchRespDto other = (AreaMatchRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AreaNodeDto> this$provinces = this.getProvinces();
        List<AreaNodeDto> other$provinces = other.getProvinces();
        return !(this$provinces == null ? other$provinces != null : !((Object)this$provinces).equals(other$provinces));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AreaMatchRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AreaNodeDto> $provinces = this.getProvinces();
        result = result * 59 + ($provinces == null ? 43 : ((Object)$provinces).hashCode());
        return result;
    }

    public String toString() {
        return "AreaMatchRespDto(provinces=" + this.getProvinces() + ", map=" + this.getMap() + ")";
    }
}

