/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.account.constants;

import java.util.Arrays;

public enum AccountStatusEnum {
    ACTIVATE("C", "\u6fc0\u6d3b"),
    FROZEN("X", "\u51bb\u7ed3"),
    LOSS("E", "\u6302\u5931"),
    REVOKE("D", "\u6ce8\u9500");

    private final String code;
    private final String description;

    private AccountStatusEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String getValueByCode(String code) {
        AccountStatusEnum statusEnum = AccountStatusEnum.getEnumByCode(code);
        if (statusEnum != null) {
            return statusEnum.getDescription();
        }
        return "\u672a\u77e5";
    }

    public static AccountStatusEnum getEnumByCode(String code) {
        return Arrays.stream(AccountStatusEnum.values()).filter(bean -> bean.getCode().equals(code)).findFirst().orElse(null);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

