/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.scheduler;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderPageDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderSearchDto;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.TransferOrderStatusEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="autoCommitO2OReturnTypeTransferOrderTask")
@Scope(value="prototype")
public class AutoCommitO2OReturnTypeTransferOrderTask
extends AbstractSingleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(AutoCommitO2OReturnTypeTransferOrderTask.class);
    @Resource
    private ITransferOrderApiProxy transferOrderApiProxy;
    @Resource
    private ICacheService cacheService;
    private static final String CACHE_KEY = "AutoCommitO2OReturnTypeTransferOrderTask";

    public void before(TaskMsg taskMsg) {
        log.info("\u6bcf\u65e5\u5b9a\u65f6\u62c9\u53d6\u5e76\u5c1d\u8bd5\u63d0\u4ea4-\u672a\u63d0\u4ea4\u7684O2O\u8c03\u62e8\u9000\u8d27\u6c47\u603b\u5355\u4efb\u52a1\u5f00\u59cb");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        if (!this.cacheService.setIfAbsent(CACHE_KEY, "1").booleanValue()) {
            log.error("\u5df2\u5b58\u5728\u81ea\u52a8\u6267\u884c\u62c9\u53d6\u5e76\u5c1d\u8bd5\u63d0\u4ea4-\u672a\u63d0\u4ea4\u7684O2O\u8c03\u62e8\u9000\u8d27\u6c47\u603b\u5355\u4efb\u52a1\u3002");
            return true;
        }
        try {
            this.doExecute();
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u62c9\u53d6\u5e76\u5c1d\u8bd5\u63d0\u4ea4-\u672a\u63d0\u4ea4\u7684O2O\u8c03\u62e8\u9000\u8d27\u6c47\u603b\u5355\u4efb\u52a1\u51fa\u9519\u4e86", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            log.info("\u6267\u884c\u62c9\u53d6\u5e76\u5c1d\u8bd5\u63d0\u4ea4-\u672a\u63d0\u4ea4\u7684O2O\u8c03\u62e8\u9000\u8d27\u6c47\u603b\u5355\u4efb\u52a1\u91ca\u653e\uff1a{}\uff0c{}", (Object)Thread.currentThread().getName(), (Object)System.currentTimeMillis());
            this.cacheService.delCache(CACHE_KEY);
        }
        return true;
    }

    public void doExecute() {
        ArrayList list = Lists.newArrayList();
        AtomicInteger pageNum = new AtomicInteger(1);
        TransferOrderSearchDto reqDto = new TransferOrderSearchDto();
        reqDto.setTypeList(Collections.singletonList(TransferOrderTypeEnum.REVERSE_O_TO_O_TRANSFER.getCode()));
        reqDto.setOrderStatusList(Collections.singletonList(TransferOrderStatusEnum.PENDING.getCode()));
        reqDto.setCreatePerson("system");
        reqDto.setPageSize(Integer.valueOf(1000));
        while (true) {
            int pagNum = pageNum.get();
            reqDto.setPageNum(Integer.valueOf(pagNum));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.page(reqDto));
            if (pageInfo == null || !CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break;
            list.addAll(pageInfo.getList());
            log.info("\u67e5\u8be2\u672a\u63d0\u4ea4\u7684O2O\u8c03\u62e8\u9000\u8d27\u6c47\u603b\u5355\u8c03\u62e8\u5355, \u5f53\u524d\u7b2c{}\u9875", (Object)pagNum);
            pageNum.addAndGet(1);
        }
        log.info("\u67e5\u8be2\u672a\u63d0\u4ea4\u7684O2O\u8c03\u62e8\u9000\u8d27\u6c47\u603b\u5355\u8c03\u62e8\u5355\u5b8c\u6bd5");
        for (TransferOrderPageDto orderPageDto : list) {
            try {
                this.transferOrderApiProxy.commitTransferOrder(orderPageDto.getTransferOrderNo());
            }
            catch (Exception e) {
                log.error("\u63d0\u4ea4\u8c03\u62e8\u5355\uff1a{}\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object)orderPageDto.getTransferOrderNo());
            }
        }
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u6bcf\u65e5\u5b9a\u65f6\u62c9\u53d6\u5e76\u5c1d\u8bd5\u63d0\u4ea4-\u672a\u63d0\u4ea4\u7684O2O\u8c03\u62e8\u9000\u8d27\u6c47\u603b\u5355\u4efb\u52a1\u7ed3\u675f");
    }
}

