/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.scheduler;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.report.api.order.IDgOrderReportApi;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleOrder2TransferReqDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.api.shopbiz.IDgShopQueryApi;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="autoCreateReverseTransferOrderTask")
@Scope(value="prototype")
public class AutoCreateReverseTransferOrderTask
extends AbstractSingleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(AutoCreateReverseTransferOrderTask.class);
    @Resource
    private IDgOrderReportApi dgOrderReportApi;
    @Resource(name="warehouseApiProxy")
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IPhysicsWarehouseApiProxy physicsWarehouseApiProxy;
    @Resource
    private ITransferOrderApiProxy transferOrderApiProxy;
    @Resource
    private IDgShopQueryApi dgShopQueryApi;
    @Resource
    private IDictQueryApiProxy iDictQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgAfterSaleOrderApiProxy dgAfterSaleOrderApiProxy;
    private static final String CACHE_KEY = "AutoCreateReverseTransferOrderTask";
    private static final String PROCESS_CACHE_KEY = "AutoCreateReverseTransferOrderTask:processKey";

    public void before(TaskMsg taskMsg) {
        log.info("\u6bcf\u65e5\u81ea\u52a8\u6267\u884c\u9000\u8d27\u5355\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u5f00\u59cb");
        ServiceContext.getContext().setAttachment("yes.req.requestId", (String)StringUtils.defaultIfBlank((CharSequence)ServiceContext.getContext().getRequestId(), (CharSequence)UUID.randomUUID().toString()));
    }

    public boolean execute(TaskMsg taskMsg) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.iDictQueryApiProxy.queryByGroupCodeAndCode("COMMON_CONFIG", "AUTO_TRANSFER_4_SETTLEMENT_CONFIG"));
        String config = "";
        if (dictDto == null || StrUtil.isBlank((CharSequence)(config = JSONObject.parseObject((String)dictDto.getValue()).getString("salesReturnTransferIn")))) {
            log.info("\u5e73\u53f0\u5382\u9001\u7684\u5e97\u94fa\u672a\u914d\u7f6e\u9000\u8d27\u5355\u8c03\u62e8\u7ed3\u7b97\u4ed3\u914d\u7f6e\u3002");
            return true;
        }
        String requestId = ServiceContext.getContext().getRequestId();
        log.info("\u6bcf\u65e5\u81ea\u52a8\u6267\u884c\u9000\u8d27\u5355\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u5f00\u59cb,reqid:{}", (Object)requestId);
        String finalConfig = config;
        CompletableFuture.runAsync(() -> {
            MDC.put((String)"yes.req.requestId", (String)requestId);
            Date date = DateUtil.addDays((Date)new Date(), (int)0);
            AfterSaleOrder2TransferReqDto param = new AfterSaleOrder2TransferReqDto();
            param.setConfig(finalConfig);
            param.setBizModel("B2C");
            param.setCompleteDateStart(DateUtil.getDayBegin((Date)date));
            param.setCompleteDateEnd(DateUtil.getDayEnd((Date)date));
            log.info("\u6bcf\u65e5\u81ea\u52a8\u6267\u884c\u9000\u8d27\u5355\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u6267\u884c\u751f\u6210\u8c03\u62e8\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)param));
            this.dgAfterSaleOrderApiProxy.executeAfterSaleOrder2Transfer(param);
        });
        return true;
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u6bcf\u65e5\u81ea\u52a8\u751f\u6210\u8c03\u62e8\u5355\u4efb\u52a1\u7ed3\u675f");
    }
}

