/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.scheduler;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUpdateShipmentInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderExtRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IReceiveDeliveryNoticeOrderApiProxy;
import com.yunxi.dg.base.center.source.dto.DgOrderAddrPageReqDto;
import com.yunxi.dg.base.center.source.dto.DgOrderItemPageReqDto;
import com.yunxi.dg.base.center.source.dto.DgSourceOrderResultReqDto;
import com.yunxi.dg.base.center.source.proxy.IDgOrderOptApiProxy;
import com.yunxi.dg.base.center.trade.dto.entity.DgClueWarehouseGroupRuleShipmentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.enums.SourceStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="batchLogisticsSourceTask")
@Scope(value="prototype")
public class BatchLogisticsSourceTask
extends AbstractSingleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(BatchLogisticsSourceTask.class);
    private static final String LOGISTICS_SOURCE_TAG = "batchLogisticsSourceResult";
    @Resource
    private IReceiveDeliveryNoticeOrderApiProxy receiveDeliveryNoticeOrderApiProxy;
    @Resource
    private IDgOrderOptApiProxy dgOrderOptApiProxy;
    @Resource
    private ICommonsMqService mqService;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;

    public void before(TaskMsg taskMsg) {
        log.info("\u6279\u91cf\u7269\u6d41\u5bfb\u6e90\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        log.info("\u6279\u91cf\u7269\u6d41\u5bfb\u6e90\u5f00\u59cb\u6267\u884c");
        try {
            this.seek();
        }
        catch (Exception e) {
            log.info("\u6279\u91cf\u7269\u6d41\u5bfb\u6e90\u6267\u884c\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return Boolean.TRUE;
    }

    public boolean seek() {
        List<ReceiveDeliveryNoticeOrderExtRespDto> receiveDeliveryNoticeOrderExtRespDtoList = this.queryData();
        if (CollectionUtils.isEmpty(receiveDeliveryNoticeOrderExtRespDtoList)) {
            log.info("\u62c9\u53d6\u4e0d\u5230\u5f85\u4e0b\u53d1\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u5355\u3002");
            return true;
        }
        List list = receiveDeliveryNoticeOrderExtRespDtoList.stream().map(ReceiveDeliveryNoticeOrderExtRespDto::getSkuCode).distinct().collect(Collectors.toList());
        Map<String, Integer> map = ((List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode(list))).stream().filter(r -> Objects.nonNull(r.getPackageNum())).collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getPackageNum, (o, o1) -> o));
        receiveDeliveryNoticeOrderExtRespDtoList.stream().filter(r -> map.containsKey(r.getSkuCode())).forEach(r -> {
            Integer i = (Integer)map.get(r.getSkuCode());
            r.setItemNum(BigDecimalUtils.divide((BigDecimal)r.getPlanQuantity(), (BigDecimal)new BigDecimal(i), (int)6));
        });
        Map<String, List<ReceiveDeliveryNoticeOrderExtRespDto>> key2ReceiveDeliveryNoticeOrderListMap = receiveDeliveryNoticeOrderExtRespDtoList.stream().collect(Collectors.groupingBy(ReceiveDeliveryNoticeOrderExtRespDto::genKey));
        ArrayList resultVos = new ArrayList();
        for (String key : key2ReceiveDeliveryNoticeOrderListMap.keySet()) {
            List<ReceiveDeliveryNoticeOrderExtRespDto> receiveDeliveryNoticeOrderExtRespList = key2ReceiveDeliveryNoticeOrderListMap.get(key);
            if (CollectionUtils.isEmpty(receiveDeliveryNoticeOrderExtRespList)) {
                log.info("[\u6279\u91cf\u7269\u6d41\u5bfb\u6e90]\u53d1\u8d27\u901a\u77e5\u5355\u5bfb\u6e90\u7684\u8bf7\u6c42\u5546\u54c1\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5bfb\u6e90\u5904\u7406\uff01");
                continue;
            }
            try {
                DgSourceOrderResultReqDto dgSourceOrderResultReqDto = this.buildDgSourceOrderResultReqDto(receiveDeliveryNoticeOrderExtRespList);
                log.info("[\u6279\u91cf\u7269\u6d41\u5bfb\u6e90]\u53d1\u8d27\u901a\u77e5\u5355\u5bfb\u6e90\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)dgSourceOrderResultReqDto));
                DgSourceOrderResultRespDto dgSourceOrderResultRespDto = (DgSourceOrderResultRespDto)RestResponseHelper.extractData((RestResponse)this.dgOrderOptApiProxy.addSourceOrder(dgSourceOrderResultReqDto));
                log.info("[\u6279\u91cf\u7269\u6d41\u5bfb\u6e90]\u53d1\u8d27\u901a\u77e5\u5355\u5bfb\u6e90\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)dgSourceOrderResultRespDto));
                if (dgSourceOrderResultRespDto == null) continue;
                boolean flag = SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(dgSourceOrderResultRespDto.getSgStatus()) || SourceStatusEnum.SOURCE_FAIL.getCode().equals(dgSourceOrderResultRespDto.getSgStatus());
                DgClueWarehouseGroupRuleShipmentDto clueWarehouseGroupRuleShipmentDto = null;
                if (flag) {
                    OrderUpdateShipmentInfoReqDto infoReqDto = new OrderUpdateShipmentInfoReqDto();
                    infoReqDto.setDocumentNos(receiveDeliveryNoticeOrderExtRespList.stream().map(ReceiveDeliveryNoticeOrderDto::getDocumentNo).distinct().collect(Collectors.toList()));
                    if (CollectionUtils.isNotEmpty((Collection)dgSourceOrderResultRespDto.getClueWarehouseGroupRuleShipmentRespDtoList()) && ObjectUtil.isNotNull((Object)(clueWarehouseGroupRuleShipmentDto = (DgClueWarehouseGroupRuleShipmentDto)dgSourceOrderResultRespDto.getClueWarehouseGroupRuleShipmentRespDtoList().get(0)))) {
                        infoReqDto.setShipmentEnterpriseCode(clueWarehouseGroupRuleShipmentDto.getShipmentEnterpriseCode());
                        infoReqDto.setShipmentEnterpriseName(clueWarehouseGroupRuleShipmentDto.getShipmentEnterpriseName());
                        infoReqDto.setTransportTypeCode(clueWarehouseGroupRuleShipmentDto.getTransportTypeCode());
                    }
                    RestResponse restResponse = this.receiveDeliveryNoticeOrderApiProxy.updateOrderShipmentInfoBatch(Collections.singletonList(infoReqDto));
                    log.info("[\u6279\u91cf\u7269\u6d41\u5bfb\u6e90]\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)restResponse));
                }
                Map deliveryNoticeOrderExtRespDtoMap = receiveDeliveryNoticeOrderExtRespList.stream().collect(Collectors.toMap(ReceiveDeliveryNoticeOrderDto::getRelevanceNo, Function.identity(), (o, o1) -> o));
                deliveryNoticeOrderExtRespDtoMap.forEach((k, v) -> {
                    BatchLogisticsSourceResultVo batchLogisticsSourceResultVo = new BatchLogisticsSourceResultVo();
                    batchLogisticsSourceResultVo.setFlag(SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(dgSourceOrderResultRespDto.getSgStatus()));
                    batchLogisticsSourceResultVo.setErrMsg(dgSourceOrderResultRespDto.getSgFailResultDesc());
                    batchLogisticsSourceResultVo.setOrderNo((String)k);
                    batchLogisticsSourceResultVo.setDocumentNo(v.getDocumentNo());
                    batchLogisticsSourceResultVo.setDgClueWarehouseGroupRuleShipmentDtos(dgSourceOrderResultRespDto.getClueWarehouseGroupRuleShipmentRespDtoList());
                    resultVos.add(batchLogisticsSourceResultVo);
                });
            }
            catch (Exception e) {
                log.error("[\u6279\u91cf\u7269\u6d41\u5bfb\u6e90]\u53d1\u8d27\u901a\u77e5\u5355\u5bfb\u6e90\u7684\u51fa\u9519\u4e86", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(resultVos)) {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSONObject.toJSONString(resultVos));
            this.mqService.publishMessage(LOGISTICS_SOURCE_TAG, (Object)messageVo);
            log.info("[\u6279\u91cf\u7269\u6d41\u5bfb\u6e90]\u53d1\u9001\u5bfb\u6e90\u7ed3\u679c\u5e7f\u64ad\u540e\uff1a{}", (Object)JSONObject.toJSONString((Object)messageVo));
        }
        return true;
    }

    public List<ReceiveDeliveryNoticeOrderExtRespDto> queryData() {
        ReceiveDeliveryNoticeOrderPageReqDto reqDto = new ReceiveDeliveryNoticeOrderPageReqDto();
        reqDto.setOrderSyncDateEnd(new Date());
        reqDto.setPageSize(Integer.valueOf(50));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.receiveDeliveryNoticeOrderApiProxy.queryByOrderSyncDatePage(reqDto));
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new ArrayList<ReceiveDeliveryNoticeOrderExtRespDto>();
        }
        List receiveDeliveryNoticeOrderExtRespDtoList = pageInfo.getList();
        int page = pageInfo.getPages();
        int curPage = 1;
        while (curPage++ < page) {
            log.info("\u5f53\u524d\u83b7\u53d6\u7b2c{}\u9875\u6570\u636e", (Object)curPage);
            reqDto.setId(((ReceiveDeliveryNoticeOrderExtRespDto)pageInfo.getList().get(pageInfo.getList().size() - 1)).getId());
            pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.receiveDeliveryNoticeOrderApiProxy.queryByOrderSyncDatePage(reqDto));
            receiveDeliveryNoticeOrderExtRespDtoList.addAll(pageInfo.getList());
        }
        return receiveDeliveryNoticeOrderExtRespDtoList;
    }

    public DgSourceOrderResultReqDto buildDgSourceOrderResultReqDto(List<ReceiveDeliveryNoticeOrderExtRespDto> receiveDeliveryNoticeOrderExtRespList) {
        ReceiveDeliveryNoticeOrderExtRespDto respDto = receiveDeliveryNoticeOrderExtRespList.get(0);
        DgSourceOrderResultReqDto sourceOrderResultReqDto = new DgSourceOrderResultReqDto();
        sourceOrderResultReqDto.setLinkOrderNo(respDto.getDocumentNo());
        sourceOrderResultReqDto.setLinkOrderType(respDto.getJumpDocumentType());
        sourceOrderResultReqDto.setLinkOrderCustomerCode(respDto.getCustomerCode());
        sourceOrderResultReqDto.setLinkOrderCustomerName(respDto.getCustomerName());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseCode(respDto.getDeliveryLogicWarehouseCode());
        sourceOrderResultReqDto.setLinkOrderLogicWarehouseName(respDto.getDeliveryLogicWarehouseName());
        sourceOrderResultReqDto.setBizModel("INVOICE_ORDER");
        sourceOrderResultReqDto.setSgType("SHIPMENT");
        sourceOrderResultReqDto.setLinkShopId(respDto.getShopId());
        sourceOrderResultReqDto.setLinkOrderShopCode(respDto.getShopCode());
        sourceOrderResultReqDto.setLinkOrderShopName(respDto.getShopName());
        sourceOrderResultReqDto.setShipmentEnterpriseCode(respDto.getShipmentEnterpriseCode());
        DgOrderAddrPageReqDto orderAddrReqDto = new DgOrderAddrPageReqDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)respDto, (String[])new String[]{"id"});
        orderAddrReqDto.setCounty(respDto.getDistrict());
        orderAddrReqDto.setCountyCode(respDto.getDistrictCode());
        sourceOrderResultReqDto.setOrderAddrReqDto(orderAddrReqDto);
        Map<String, BigDecimal> noticeOrder2ItemNumMap = receiveDeliveryNoticeOrderExtRespList.stream().collect(Collectors.toMap(ReceiveDeliveryNoticeOrderExtRespDto::getSkuCode, ReceiveDeliveryNoticeOrderExtRespDto::getItemNum, BigDecimal::add));
        List orderItemReqDtoList = receiveDeliveryNoticeOrderExtRespList.stream().map(extRespDto -> {
            DgOrderItemPageReqDto orderItemReqDto = new DgOrderItemPageReqDto();
            orderItemReqDto.setLinkOrderItemId(extRespDto.getId());
            orderItemReqDto.setItemSkuCode(extRespDto.getSkuCode());
            orderItemReqDto.setItemSkuName(extRespDto.getSkuName());
            orderItemReqDto.setItemBatchNo(extRespDto.getBatch());
            orderItemReqDto.setOrderItemUnit(extRespDto.getUnit());
            orderItemReqDto.setBasicUnit(extRespDto.getBasicUnit());
            orderItemReqDto.setItemNum((BigDecimal)noticeOrder2ItemNumMap.get(extRespDto.getSkuCode()));
            return orderItemReqDto;
        }).collect(Collectors.toList());
        sourceOrderResultReqDto.setLinkOrderTotalItemNum(noticeOrder2ItemNumMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add));
        sourceOrderResultReqDto.setOrderItemReqDtoList(orderItemReqDtoList);
        return sourceOrderResultReqDto;
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u6279\u91cf\u7269\u6d41\u5bfb\u6e90\u7ed3\u675f");
    }

    static class BatchLogisticsSourceResultVo {
        boolean flag;
        String errMsg;
        String orderNo;
        String documentNo;
        List<DgClueWarehouseGroupRuleShipmentDto> dgClueWarehouseGroupRuleShipmentDtos;

        BatchLogisticsSourceResultVo() {
        }

        public boolean isFlag() {
            return this.flag;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public String getOrderNo() {
            return this.orderNo;
        }

        public String getDocumentNo() {
            return this.documentNo;
        }

        public List<DgClueWarehouseGroupRuleShipmentDto> getDgClueWarehouseGroupRuleShipmentDtos() {
            return this.dgClueWarehouseGroupRuleShipmentDtos;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public void setDocumentNo(String documentNo) {
            this.documentNo = documentNo;
        }

        public void setDgClueWarehouseGroupRuleShipmentDtos(List<DgClueWarehouseGroupRuleShipmentDto> dgClueWarehouseGroupRuleShipmentDtos) {
            this.dgClueWarehouseGroupRuleShipmentDtos = dgClueWarehouseGroupRuleShipmentDtos;
        }
    }
}

