/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.account.constants.AccountStatusEnum;
import com.yunxi.dg.base.center.account.constants.AccountUserTypeEnum;
import com.yunxi.dg.base.center.account.constants.BalanceTypeEnum;
import com.yunxi.dg.base.center.account.constants.CurrencyEnum;
import com.yunxi.dg.base.center.account.dto.entity.AccountOwnerDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountPageReqDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountApiProxy;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountOwnerApiProxy;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchListReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerSearchListRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.ITransactionCustomerQueryApiProxy;
import com.yunxi.dg.base.center.user.dto.dto.OrganizationDto;
import com.yunxi.dg.base.center.user.proxy.IDgOrganizationApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ExportAccountFileDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ImportAccountFileDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_account_file")
public class AccountFileCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(AccountFileCommonServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(AccountFileCommonServiceImpl.class);
    @Resource
    private IAccountOwnerApiProxy accountOwnerApiProxy;
    @Resource
    private IDgOrganizationApiProxy dgOrganizationApiProxy;
    @Resource
    private ITransactionCustomerQueryApiProxy transactionCustomerQueryApiProxy;
    @Resource
    private IAccountApiProxy accountApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        this.logger.info("\u8bfb\u53d6\u6570\u91cf===============>{}", (Object)result.getList().size());
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportAccountFileDto.class);
        this.logger.info("\u5bfc\u5165\u6570\u91cf===============>{}", (Object)list.size());
        ArrayList<ImportAccountFileDto> passList = new ArrayList<ImportAccountFileDto>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Map<Object, Object> saleCompanyMap = Maps.newHashMap();
        List saleCompanyCodes = list.stream().map(ImportAccountFileDto::getSaleCompanyCode).filter(org.apache.commons.lang3.StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(saleCompanyCodes)) {
            saleCompanyMap = ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgOrganizationApiProxy.queryOrgListByCode(saleCompanyCodes))).orElse(new ArrayList())).stream().collect(Collectors.toMap(OrganizationDto::getCode, Function.identity(), (a, b) -> a));
        }
        Map<Object, Object> customerMap = Maps.newHashMap();
        List customerNos = list.stream().map(ImportAccountFileDto::getCustomerNo).filter(org.apache.commons.lang3.StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerNos)) {
            DgCustomerSearchListReqDto customerInfoQueryDto = new DgCustomerSearchListReqDto();
            customerInfoQueryDto.setCustomerCodeList(customerNos);
            customerMap = ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.transactionCustomerQueryApiProxy.queryList(customerInfoQueryDto))).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgCustomerSearchListRespDto::getCode, Function.identity(), (a, b) -> a));
        }
        HashMap customerRelationMap = Maps.newHashMap();
        for (ImportAccountFileDto dto : list) {
            Boolean verify = this.accountVerify(dto, (Map<String, OrganizationDto>)saleCompanyMap, (Map<String, DgCustomerSearchListRespDto>)customerMap);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            try {
                AccountOwnerDto reqDto = new AccountOwnerDto();
                reqDto.setSaleCompanyCode(dto.getSaleCompanyCode());
                reqDto.setSaleCompanyName(((OrganizationDto)saleCompanyMap.get(dto.getSaleCompanyCode())).getName());
                reqDto.setCustomerNo(dto.getCustomerNo());
                reqDto.setCustomerName(((DgCustomerSearchListRespDto)customerMap.get(dto.getCustomerNo())).getName());
                reqDto.setCustomerSimpleName(((DgCustomerSearchListRespDto)customerMap.get(dto.getCustomerNo())).getName());
                reqDto.setUserType(AccountUserTypeEnum.getCodeByValue((String)dto.getUserType()));
                RestResponseHelper.checkOrThrow((RestResponse)this.accountOwnerApiProxy.insert(reqDto));
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u8d26\u6237\u9519\u8bef", (Throwable)e);
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5199\u5165\u5931\u8d25:" + e.getMessage()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        dataMap.put("passList", passList);
        dataMap.put("saleCompanyMap", saleCompanyMap);
        dataMap.put("customerMap", customerMap);
        return dataMap;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        Map dataMap = (Map)object;
        List passList = (List)dataMap.get("passList");
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        Map saleCompanyMap = (Map)dataMap.get("saleCompanyMap");
        Map customerMap = (Map)dataMap.get("customerMap");
        Map shopMap = (Map)dataMap.get("shopMap");
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode: {}", (Object)commonReqDto.getCreatePerson());
        log.info("\u6210\u529f\u6570\u91cf: {}", (Object)passList.size());
    }

    public List<ExportAccountFileDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) {
        List accountDtos;
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        log.info("\u5ba2\u6237\u8d26\u6237\u6863\u6848\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        AssertUtils.isTrue((boolean)FileModeTypeEnum.ACCOUNT_FILE.getKey().equals(key), (String)"\u4e1a\u52a1key\u6709\u8bef");
        ArrayList<ExportAccountFileDto> list = new ArrayList<ExportAccountFileDto>();
        AccountPageReqDto reqDto = new AccountPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            reqDto = (AccountPageReqDto)JSON.parseObject((String)filter, AccountPageReqDto.class);
        }
        if (CollectionUtils.isNotEmpty((Collection)(accountDtos = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.accountApiProxy.page(reqDto))).getList()))) {
            list.addAll(accountDtos.stream().map(o -> {
                ExportAccountFileDto exportDto = (ExportAccountFileDto)BeanCopyUtil.copyProperties((Object)o, ExportAccountFileDto.class);
                if (Objects.nonNull(o.getBalanceType())) {
                    exportDto.setBalanceType(BalanceTypeEnum.codeToName((Integer)o.getBalanceType()));
                }
                if (Objects.nonNull(o.getCurrency())) {
                    exportDto.setCurrency(CurrencyEnum.codeToName((String)o.getCurrency()));
                }
                if (Objects.nonNull(o.getStatus())) {
                    exportDto.setStatus(AccountStatusEnum.getValueByCode((String)o.getStatus()));
                }
                if (Objects.nonNull(o.getCreateTime())) {
                    exportDto.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                return exportDto;
            }).collect(Collectors.toList()));
        }
        log.info("\u5ba2\u6237\u8d26\u6237\u6863\u6848\u5bfc\u51fa\u5927\u5c0f:{}", (Object)list.size());
        return list;
    }

    private Boolean accountVerify(ImportAccountFileDto dto, Map<String, OrganizationDto> saleCompanyMap, Map<String, DgCustomerSearchListRespDto> customerMap) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.getUserType())) {
            dto.setErrorMsg("\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.getSaleCompanyCode())) {
            dto.setErrorMsg("\u9500\u552e\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.getCustomerNo())) {
            dto.setErrorMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        String code = AccountUserTypeEnum.getCodeByValue((String)dto.getUserType());
        if (code == null) {
            dto.setErrorMsg("\u7528\u6237\u7c7b\u578b\u4e0d\u6b63\u786e");
            return false;
        }
        if (!saleCompanyMap.containsKey(dto.getSaleCompanyCode())) {
            dto.setErrorMsg("\u9500\u552e\u516c\u53f8\u4e0d\u5b58\u5728\uff1a" + dto.getSaleCompanyCode());
            return false;
        }
        if (!customerMap.containsKey(dto.getCustomerNo())) {
            dto.setErrorMsg("\u5ba2\u6237\u4e0d\u5b58\u5728\uff1a" + dto.getCustomerNo());
            return false;
        }
        return true;
    }
}

