/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualGroupDto;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualGroupPageReqDto;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualWarehouseDto;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualWarehousePageReqDto;
import com.yunxi.dg.base.center.share.proxy.warehouse.IDgVirtualGroupApiProxy;
import com.yunxi.dg.base.center.share.proxy.warehouse.IDgVirtualWarehouseApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.enums.ChannelWarehouseStatusEnum;
import com.yunxi.dg.base.mgmt.service.enums.VirtualWarehouseGroupChoiceEnum;
import com.yunxi.dg.base.mgmt.service.enums.VirtualWarehouseTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportVirtualWarehouseModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_virtual_warehouse_import")
public class VirtualWarehouseCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(VirtualWarehouseCommonServiceImpl.class);
    @Resource
    private IDgVirtualWarehouseApiProxy virtualWarehouseApiProxy;
    @Resource
    private IDgVirtualGroupApiProxy virtualGroupApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u4f9b\u8d27\u4ed3\u6863\u6848");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList<ImportVirtualWarehouseModeDto> passList = new ArrayList<ImportVirtualWarehouseModeDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportVirtualWarehouseModeDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u4f9b\u8d27\u4ed3\u6863\u6848,\u5bfc\u5165\u4f9b\u8d27\u4ed3\u6863\u6848\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        List virtualWarehouseDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.virtualWarehouseApiProxy.list(new DgVirtualWarehousePageReqDto()))).orElse(new ArrayList());
        List<String> warehouseNameList = virtualWarehouseDtos.stream().map(DgVirtualWarehouseDto::getWarehouseName).collect(Collectors.toList());
        List<String> groupNameList = virtualWarehouseDtos.stream().map(DgVirtualWarehouseDto::getGroupName).collect(Collectors.toList());
        Map<String, String> organizationMap = virtualWarehouseDtos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrganizationCode())).collect(Collectors.toMap(DgVirtualWarehouseDto::getOrganizationName, DgVirtualWarehouseDto::getOrganizationCode, (o1, o2) -> o1));
        List virtualGroupDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.virtualGroupApiProxy.queryList(new DgVirtualGroupPageReqDto()))).orElse(new ArrayList());
        Map<String, DgVirtualGroupDto> virtualGroupDtoMap = virtualGroupDtos.stream().collect(Collectors.toMap(DgVirtualGroupDto::getName, Function.identity(), (o1, o2) -> o1));
        for (ImportVirtualWarehouseModeDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, warehouseNameList, groupNameList, virtualGroupDtoMap, organizationMap);
            if (!isPass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        log.info("\u5bfc\u5165\u4f9b\u8d27\u4ed3\u6863\u6848\u6570\u636e:{}", (Object)JSON.toJSONString((Object)passList));
        List dgVirtualWarehouseDtos = BeanUtil.copyToList((Collection)passList, DgVirtualWarehouseDto.class);
        this.virtualWarehouseApiProxy.batchInsert(dgVirtualWarehouseDtos);
    }

    private boolean paramVerify(ImportVirtualWarehouseModeDto dto, List<String> warehouseNameList, List<String> groupNameList, Map<String, DgVirtualGroupDto> virtualGroupDtoMap, Map<String, String> organizationMap) {
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseName())) {
            this.setErrorMsg(dto, "\u9009\u9879\u4f9b\u8d27\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (CollectionUtil.isNotEmpty(warehouseNameList) && warehouseNameList.contains(dto.getWarehouseName())) {
            this.setErrorMsg(dto, dto.getWarehouseName() + "\u4f9b\u8d27\u4ed3\u540d\u79f0\u5df2\u5b58\u5728");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getGroupChoice())) {
            this.setErrorMsg(dto, "\u9009\u9879\u4f9b\u8d27\u4ed3\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        List<String> descList = VirtualWarehouseGroupChoiceEnum.getDescList();
        if (CollectionUtil.isNotEmpty(descList) && !descList.contains(dto.getGroupChoice())) {
            this.setErrorMsg(dto, "\u4f9b\u8d27\u4ed3\u5206\u7ec4\u586b\u5199\u6709\u8bef,\u8bf7\u68c0\u67e5");
            return false;
        }
        if (VirtualWarehouseGroupChoiceEnum.CREATE.getDesc().equals(dto.getGroupChoice())) {
            if (StringUtils.isBlank((CharSequence)dto.getMajorWarehouse())) {
                this.setErrorMsg(dto, "\u9009\u9879\u8bbe\u7f6e\u4e3b\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (!"\u662f".equals(dto.getMajorWarehouse())) {
                this.setErrorMsg(dto, "\u3010\u8bbe\u7f6e\u4e3b\u4ed3\u3011\u5fc5\u987b=\u662f");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)dto.getGroupName())) {
                this.setErrorMsg(dto, "\u9009\u9879\u4f9b\u8d27\u4ed3\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (groupNameList.contains(dto.getGroupName())) {
                this.setErrorMsg(dto, dto.getGroupName() + "\u4f9b\u8d27\u4ed3\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728");
                return false;
            }
            dto.setGroupChoice(VirtualWarehouseGroupChoiceEnum.CREATE.getCode());
            dto.setWarehouseType(VirtualWarehouseTypeEnum.MAIN.getCode());
        } else {
            if (StringUtils.isBlank((CharSequence)dto.getGroupName())) {
                this.setErrorMsg(dto, "\u9009\u9879\u4f9b\u8d27\u4ed3\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (!virtualGroupDtoMap.containsKey(dto.getGroupName())) {
                this.setErrorMsg(dto, "\u9009\u9879\u4f9b\u8d27\u4ed3\u5206\u7ec4\u540d\u79f0\u4e0d\u5b58\u5728");
                return false;
            }
            DgVirtualWarehousePageReqDto reqDto = new DgVirtualWarehousePageReqDto();
            reqDto.setGroupCode(virtualGroupDtoMap.get(dto.getGroupName()).getCode());
            List virtualWarehouseDtoList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.virtualWarehouseApiProxy.list(reqDto))).orElse(new ArrayList());
            if (StringUtils.isBlank((CharSequence)dto.getMajorWarehouse())) {
                this.setErrorMsg(dto, "\u9009\u9879\u8bbe\u7f6e\u4e3b\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (CollectionUtil.isEmpty((Collection)virtualWarehouseDtoList) && "\u5426".equals(dto.getMajorWarehouse())) {
                this.setErrorMsg(dto, "\u8be5\u5206\u7ec4\u6ca1\u6709\u4e3b\u4ed3\uff0c\u8bf7\u8bbe\u7f6e\uff01");
                return false;
            }
            List warehouseTypeList = virtualWarehouseDtoList.stream().map(DgVirtualWarehouseDto::getWarehouseType).collect(Collectors.toList());
            if (warehouseTypeList.contains(VirtualWarehouseTypeEnum.MAIN.getCode()) && "\u662f".equals(dto.getMajorWarehouse())) {
                this.setErrorMsg(dto, "\u8be5\u5206\u7ec4\u5df2\u6709\u4e3b\u4ed3\uff0c\u4e0d\u5141\u8bb8\u66f4\u6362\uff01");
                return false;
            }
            if ("\u662f".equals(dto.getMajorWarehouse())) {
                dto.setWarehouseType(VirtualWarehouseTypeEnum.MAIN.getCode());
            }
            if ("\u5426".equals(dto.getMajorWarehouse())) {
                dto.setWarehouseType(VirtualWarehouseTypeEnum.SUB.getCode());
            }
            dto.setGroupChoice(VirtualWarehouseGroupChoiceEnum.EXIST.getCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getOrganizationName())) {
            this.setErrorMsg(dto, "\u9009\u9879\u6240\u5c5e\u4f9b\u8d27\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (organizationMap.containsKey(dto.getOrganizationName())) {
            dto.setOrganizationCode(organizationMap.get(dto.getOrganizationName()));
        }
        dto.setWarehouseStatus(ChannelWarehouseStatusEnum.ENABLE.getCode());
        return true;
    }

    private String setErrorMsg(ImportVirtualWarehouseModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }
}

