/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.UnitDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.business.IBatchAdjustmentOrderApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IDgLogicInventoryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.unit.IUnitDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.context.OcsConfig;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.ItemUnitConversionDgDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.BatchAdjustmentInventoryOrderImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_batch_adjustment_inventory_order_import")
public class BatchAdjustmentInventoryOrderOperationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(BatchAdjustmentInventoryOrderOperationCommonServiceImpl.class);
    @Resource
    private IBatchAdjustmentOrderApiProxy batchAdjustmentOrderApiProxy;
    @Resource
    private IDgLogicInventoryApiProxy dgLogicInventoryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IUnitDgQueryApiProxy unitDgQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList<BatchAdjustmentInventoryOrderImportDto> passList = new ArrayList<BatchAdjustmentInventoryOrderImportDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), BatchAdjustmentInventoryOrderImportDto.class);
        List<String> skuCodes = resultList.stream().map(BatchAdjustmentInventoryOrderImportDto::getSkuCode).collect(Collectors.toList());
        List<String> warehouseCodes = resultList.stream().map(BatchAdjustmentInventoryOrderImportDto::getWarehouseCode).collect(Collectors.toList());
        List<String> batches = resultList.stream().map(BatchAdjustmentInventoryOrderImportDto::getBatch).collect(Collectors.toList());
        List inventoryPropertyList = resultList.stream().map(BatchAdjustmentInventoryOrderImportDto::getInventoryProperty).collect(Collectors.toList());
        ArrayList<String> inventoryPropertyCodeList = new ArrayList<String>();
        for (String name : inventoryPropertyList) {
            LogicWarehouseQualityEnum qualityEnum = LogicWarehouseQualityEnum.getByDesc((String)name);
            if (!ObjectUtil.isNotEmpty((Object)qualityEnum)) continue;
            inventoryPropertyCodeList.add(qualityEnum.getCode());
        }
        List<DgLogicInventoryDto> dgLogicInventoryDtos = this.getDgLogicInventoryDtos(skuCodes, warehouseCodes, batches, inventoryPropertyCodeList);
        Map<String, DgLogicInventoryDto> warehouseCodeMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(DgLogicInventoryDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map<String, List<DgLogicInventoryDto>> warehouseInventoryMap = dgLogicInventoryDtos.stream().collect(Collectors.groupingBy(o -> o.getWarehouseCode() + o.getSkuCode()));
        Map<String, DgLogicInventoryDto> skuCodeMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(DgLogicInventoryDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        Map<String, DgLogicInventoryDto> batchMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(DgLogicInventoryDto::getBatch, Function.identity(), (k1, k2) -> k1));
        Map<String, DgLogicInventoryDto> skuBatchMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(o -> o.getWarehouseCode() + o.getSkuCode() + o.getBatch(), Function.identity(), (k1, k2) -> k1));
        Map<String, DgItemSkuDetailRespDto> itemUnitMap = this.getItemUnitMap(skuCodes);
        Map<String, UnitDgRespDto> unitMap = this.getUnitMap();
        log.info("\u67e5\u8be2\u5230\u903b\u8f91\u4ed3\u4fe1\u606fdgLogicInventoryDtos:{}", (Object)JSON.toJSONString(dgLogicInventoryDtos));
        log.info("\u83b7\u53d6\u5546\u54c1\u5355\u4f4d\u4fe1\u606fitemUnitMap:{}", (Object)JSON.toJSONString(itemUnitMap));
        log.info("\u83b7\u53d6\u6240\u6709\u5355\u4f4d\u4fe1\u606funitMap:{}", (Object)JSON.toJSONString(unitMap));
        for (BatchAdjustmentInventoryOrderImportDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, warehouseCodeMap, skuCodeMap, batchMap, itemUnitMap, unitMap, skuBatchMap, warehouseInventoryMap);
            if (isPass) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        try {
            ArrayList<AdjustmentOrderDto> orderDtoList = new ArrayList<AdjustmentOrderDto>();
            this.assembleDtos(orderDtoList, passList);
            log.info("\u65b0\u589e\u5e93\u5b58\u72b6\u6001\u8c03\u6574\u5355\u5165\u53c2orderDtoList:{}", (Object)JSON.toJSONString(orderDtoList));
            this.batchAdjustmentOrderApiProxy.insertBatch(orderDtoList);
        }
        catch (Exception e) {
            log.info("\u5bfc\u5165\u6279\u6b21\u8c03\u6574\u5355\u5931\u8d25:{}", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    private void assembleDtos(List<AdjustmentOrderDto> orderDtoList, List<BatchAdjustmentInventoryOrderImportDto> passList) {
        Map<String, List<BatchAdjustmentInventoryOrderImportDto>> passMap = passList.stream().collect(Collectors.groupingBy(this::getGroupKey));
        passMap.forEach((key, importDtos) -> {
            AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
            ArrayList adjustmentOrderDetailDtos = new ArrayList();
            BatchAdjustmentInventoryOrderImportDto importDto = (BatchAdjustmentInventoryOrderImportDto)importDtos.get(0);
            adjustmentOrderDto.setOrderType("BATCH_ADJUSTMENT");
            adjustmentOrderDto.setBusinessType(LogicWarehouseQualityEnum.getByDesc((String)importDto.getBizType()).getCode());
            adjustmentOrderDto.setWarehouseCode(importDto.getWarehouseCode());
            adjustmentOrderDto.setWarehouseName(importDto.getWarehouseName());
            adjustmentOrderDto.setPhysicsWarehouseCode(importDto.getPhysicsWarehouseCode());
            adjustmentOrderDto.setPhysicsWarehouseName(importDto.getPhysicsWarehouseName());
            adjustmentOrderDto.setOrganizationCode(importDto.getCargoOrganizationCode());
            adjustmentOrderDto.setOrganizationName(importDto.getCargoOrganizationName());
            adjustmentOrderDto.setInventoryProperty(LogicWarehouseQualityEnum.getByDesc((String)importDto.getInventoryProperty()).getCode());
            adjustmentOrderDto.setNewInventoryProperty(LogicWarehouseQualityEnum.getByDesc((String)importDto.getNewInventoryProperty()).getCode());
            adjustmentOrderDto.setRemark(importDto.getRemark());
            adjustmentOrderDto.setBizDate((Date)DateUtil.parse((CharSequence)(importDto.getBizDate() + " 00:00:00"), (String)"yyyy/MM/dd HH:mm:ss"));
            adjustmentOrderDto.setPushSap(YesNoEnum.YES.getValue());
            adjustmentOrderDto.setPushWms(YesNoEnum.YES.getValue());
            Map<String, List<BatchAdjustmentInventoryOrderImportDto>> detailmap = importDtos.stream().collect(Collectors.groupingBy(this::getGroupDetailKey));
            detailmap.forEach((detailKey, detailDtos) -> {
                AdjustmentOrderDetailDto orderDetailDto = new AdjustmentOrderDetailDto();
                BatchAdjustmentInventoryOrderImportDto detailDto = (BatchAdjustmentInventoryOrderImportDto)detailDtos.get(0);
                orderDetailDto.setSkuCode(detailDto.getSkuCode());
                orderDetailDto.setBatch(detailDto.getBatch());
                orderDetailDto.setOrigBatch(detailDto.getOrigBatch());
                orderDetailDto.setSkuName(detailDto.getSkuName());
                orderDetailDto.setSpuCode(detailDto.getSpuCode());
                orderDetailDto.setSpuName(detailDto.getSpuName());
                orderDetailDto.setUnit(detailDto.getUnit());
                orderDetailDto.setInventoryProperty(LogicWarehouseQualityEnum.getByDesc((String)detailDto.getInventoryProperty()).getCode());
                orderDetailDto.setNewInventoryProperty(LogicWarehouseQualityEnum.getByDesc((String)detailDto.getNewInventoryProperty()).getCode());
                if (StringUtils.isNotBlank((CharSequence)detailDto.getProduceTime())) {
                    orderDetailDto.setProduceTime((Date)DateUtil.parseTime((CharSequence)detailDto.getProduceTime()));
                }
                orderDetailDto.setExpireTime(detailDto.getExpireTime());
                orderDetailDto.setOrigExpireTime(detailDto.getOrigExpireTime());
                orderDetailDto.setOrigProduceTime(detailDto.getOrigProduceTime());
                orderDetailDto.setChangeType("increase");
                BigDecimal changeQuantity = detailDtos.stream().map(k -> new BigDecimal(k.getChangeQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
                orderDetailDto.setChangeQuantity(changeQuantity);
                adjustmentOrderDetailDtos.add(orderDetailDto);
            });
            adjustmentOrderDto.setAdjustmentOrderDetailDtos(adjustmentOrderDetailDtos);
            orderDtoList.add(adjustmentOrderDto);
        });
    }

    private Map<String, UnitDgRespDto> getUnitMap() {
        List unitRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.unitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(new ArrayList());
        Map<String, UnitDgRespDto> unitMap = unitRespDtos.stream().collect(Collectors.toMap(UnitDgRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        return unitMap;
    }

    private Map<String, DgItemSkuDetailRespDto> getItemUnitMap(List<String> skuCodes) {
        ItemQueryDgReqDto itemReqDto = new ItemQueryDgReqDto();
        itemReqDto.setSkuCodes(skuCodes);
        List dgItemSkuDetailRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.querySkuList(itemReqDto))).orElse(new ArrayList());
        Map<String, DgItemSkuDetailRespDto> itemUnitMap = dgItemSkuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        return itemUnitMap;
    }

    private List<DgLogicInventoryDto> getDgLogicInventoryDtos(List<String> skuCodes, List<String> warehouseCodes, List<String> batches, List<String> inventoryPropertyCodeList) {
        DgLogicInventoryListReqDto reqDto = new DgLogicInventoryListReqDto();
        reqDto.setLogicWarehouseCodeList(warehouseCodes);
        List dgLogicInventoryDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryApiProxy.queryList(reqDto))).orElse(new ArrayList());
        return dgLogicInventoryDtos;
    }

    private boolean paramVerify(BatchAdjustmentInventoryOrderImportDto dto, Map<String, DgLogicInventoryDto> warehouseCodeMap, Map<String, DgLogicInventoryDto> skuCodeMap, Map<String, DgLogicInventoryDto> batchMap, Map<String, DgItemSkuDetailRespDto> itemUnitMap, Map<String, UnitDgRespDto> unitMap, Map<String, DgLogicInventoryDto> skuBatchMap, Map<String, List<DgLogicInventoryDto>> warehouseInventoryMap) {
        StringBuffer errorMsg = new StringBuffer();
        if (ObjectUtil.isEmpty((Object)LogicWarehouseQualityEnum.getByDesc((String)dto.getBizType()))) {
            errorMsg.append("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        DgLogicInventoryDto inventoryDto = warehouseCodeMap.get(dto.getWarehouseCode());
        if (ObjectUtil.isEmpty((Object)inventoryDto)) {
            errorMsg.append("\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        dto.setWarehouseName(inventoryDto.getWarehouseName());
        dto.setPhysicsWarehouseCode(inventoryDto.getPhysicsWarehouseCode());
        dto.setPhysicsWarehouseName(inventoryDto.getPhysicsWarehouseName());
        dto.setCargoOrganizationCode(inventoryDto.getOrganizationCode());
        dto.setCargoOrganizationName(inventoryDto.getOrganizationName());
        if (StringUtils.isNotBlank((CharSequence)dto.getSkuCode()) && ObjectUtil.isEmpty((Object)skuCodeMap.get(dto.getSkuCode()))) {
            errorMsg.append("SKU\u7f16\u7801\u4e0d\u5b58\u5728;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        DgLogicInventoryDto dgLogicInventoryDto = skuCodeMap.get(dto.getSkuCode());
        dto.setSkuName(dgLogicInventoryDto.getSkuName());
        dto.setSpuCode(dgLogicInventoryDto.getSpuCode());
        dto.setSpuName(dgLogicInventoryDto.getSpuName());
        List<DgLogicInventoryDto> inventoryDtos = warehouseInventoryMap.get(dto.getWarehouseCode() + dto.getSkuCode());
        List inventoryPropertyList = ((List)Optional.ofNullable(inventoryDtos).orElse(new ArrayList())).stream().map(DgLogicInventoryDto::getInventoryProperty).collect(Collectors.toList());
        LogicWarehouseQualityEnum qualityEnum = LogicWarehouseQualityEnum.getByDesc((String)dto.getInventoryProperty());
        if (ObjectUtils.isEmpty((Object)qualityEnum) || !inventoryPropertyList.contains(qualityEnum.getCode())) {
            errorMsg.append("\u5e93\u5b58\u72b6\u6001\u7c7b\u578b\u4e0d\u5b58\u5728;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrigBatch()) && ObjectUtil.isEmpty((Object)batchMap.get(dto.getOrigBatch()))) {
            errorMsg.append("\u539f\u6279\u6b21\u53f7\u4e0d\u5b58\u5728;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        if (ObjectUtil.isEmpty((Object)LogicWarehouseQualityEnum.getByDesc((String)dto.getNewInventoryProperty()))) {
            errorMsg.append("\u65b0\u5e93\u5b58\u72b6\u6001\u7c7b\u578b\u4e0d\u5b58\u5728;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        if (Objects.equals(dto.getBizType(), LogicWarehouseQualityEnum.BATCH_ADJUSTMENT.getDesc()) && !Objects.equals(dto.getInventoryProperty(), dto.getNewInventoryProperty())) {
            errorMsg.append("\u6279\u6b21\u8c03\u6574\uff0c\u65b0\u5e93\u5b58\u72b6\u6001\u548c\u539f\u5e93\u5b58\u72b6\u6001\u5fc5\u987b\u76f8\u540c;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        if (Objects.equals(dto.getBizType(), LogicWarehouseQualityEnum.INVENTORY_STATUS_ADJUSTMENT.getDesc()) && Objects.equals(dto.getInventoryProperty(), dto.getNewInventoryProperty())) {
            errorMsg.append("\u5e93\u5b58\u72b6\u6001\u8c03\u6574\uff0c\u65b0\u5e93\u5b58\u72b6\u6001\u548c\u539f\u5e93\u5b58\u72b6\u6001\u5fc5\u987b\u4e0d\u540c;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        if (Objects.equals(dto.getBizType(), LogicWarehouseQualityEnum.INVENTORY_STATUS_ADJUSTMENT.getDesc())) {
            dto.setBatch(dto.getOrigBatch());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBatch()) && ObjectUtil.isEmpty((Object)batchMap.get(dto.getBatch()))) {
            errorMsg.append("\u65b0\u6279\u6b21\u53f7\u4e0d\u5b58\u5728;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        String origKey = String.format("%s%s%s", dto.getWarehouseCode(), dto.getSkuCode(), dto.getOrigBatch());
        if (skuBatchMap.containsKey(origKey)) {
            DgLogicInventoryDto logicInventoryDto = skuBatchMap.get(origKey);
            dto.setOrigProduceTime(logicInventoryDto.getProduceTime());
            dto.setOrigExpireTime(logicInventoryDto.getExpireTime());
        }
        String key = String.format("%s%s%s", dto.getWarehouseCode(), dto.getSkuCode(), dto.getBatch());
        if (StringUtils.isNotBlank((CharSequence)dto.getProduceTime()) && !dto.getProduceTime().matches("\\d{4}/\\d{2}/\\d{2}")) {
            errorMsg.append("\u65b0\u6279\u6b21\u7684\u751f\u4ea7\u65e5\u671f\u4e0d\u7b26\u5408\u201cYYYY/MM/DD\u201d\u7684\u683c\u5f0f\uff0c\u8bf7\u8c03\u6574;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        if (StringUtils.isBlank((CharSequence)dto.getProduceTime()) && skuBatchMap.containsKey(key)) {
            DgLogicInventoryDto logicInventoryDto = skuBatchMap.get(key);
            dto.setExpireTime(logicInventoryDto.getExpireTime());
            dto.setProduceTime(DateUtil.formatDate((Date)logicInventoryDto.getProduceTime()));
        }
        if (Objects.equals(dto.getBizType(), LogicWarehouseQualityEnum.INVENTORY_STATUS_ADJUSTMENT.getDesc())) {
            dto.setProduceTime(null);
            dto.setExpireTime(null);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getChangeQuantity()) && !dto.getChangeQuantity().matches("^[+]{0,1}(\\d+)$")) {
            errorMsg.append("\u8c03\u6574\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        if (OcsConfig.isUnitConversion()) {
            DgItemSkuDetailRespDto itemSkuRespDto;
            if (StringUtils.isBlank((CharSequence)dto.getUnit())) {
                itemSkuRespDto = Optional.ofNullable(itemUnitMap.get(dto.getSkuCode())).orElse(new DgItemSkuDetailRespDto());
                dto.setUnit(itemSkuRespDto.getUnit());
            } else {
                itemSkuRespDto = Optional.ofNullable(itemUnitMap.get(dto.getSkuCode())).orElse(new DgItemSkuDetailRespDto());
                List unitList = ((List)Optional.ofNullable(itemSkuRespDto.getUnitConvertList()).orElse(new ArrayList())).stream().map(ItemUnitConversionDgDto::getConversionUnit).collect(Collectors.toList());
                unitList.add(itemSkuRespDto.getUnit());
                log.info("unitList\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString(unitList));
                ArrayList<String> unitNameList = new ArrayList<String>();
                for (String unit : unitList) {
                    UnitDgRespDto unitDgRespDto = Optional.ofNullable(unitMap.get(unit)).orElse(new UnitDgRespDto());
                    unitNameList.add(unitDgRespDto.getName());
                }
                if (CollectionUtil.isNotEmpty(unitNameList) && !unitNameList.contains(dto.getUnit())) {
                    errorMsg.append(dto.getSkuCode() + "\u7269\u6599\u4e0d\u5b58\u5728\u8be5\u5355\u4f4d" + dto.getUnit());
                    dto.setErrorMsg(errorMsg.toString());
                    return true;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRemark()) && dto.getRemark().length() > 200) {
            errorMsg.append("\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7200\u4e2a\u5b57\u7b26;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        if (StringUtils.isBlank((CharSequence)dto.getBizDate())) {
            dto.setBizDate(DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd"));
        } else if (!dto.getBizDate().matches("^\\d{4}(\\-|\\/|\\.)\\d{1,2}\\1\\d{1,2}$")) {
            errorMsg.append("\u4e1a\u52a1\u65e5\u671f\u4e0d\u7b26\u5408\u201cYYYY/MM/DD\u201d\u7684\u683c\u5f0f\uff0c\u8bf7\u8c03\u6574;");
            dto.setErrorMsg(errorMsg.toString());
            return true;
        }
        dto.setErrorMsg(errorMsg.toString());
        return false;
    }

    private String getGroupKey(BatchAdjustmentInventoryOrderImportDto o) {
        String groupKey = o.getBizType() + o.getWarehouseCode() + o.getInventoryProperty() + o.getNewInventoryProperty() + o.getBizDate();
        return groupKey;
    }

    private String getGroupDetailKey(BatchAdjustmentInventoryOrderImportDto o) {
        return o.getSkuCode() + o.getOrigBatch() + o.getBatch();
    }
}

