/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yunxi.dg.base.center.item.api.brand.IBrandDgApi;
import com.yunxi.dg.base.center.item.api.brand.IBrandDgQueryApi;
import com.yunxi.dg.base.center.item.dto.request.BrandPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.BrandReqDto;
import com.yunxi.dg.base.center.item.dto.response.BrandDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportBrandModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_brand_import")
public class BrandCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(BrandCommonServiceImpl.class);
    @Resource
    private IBrandDgApi brandDgApi;
    @Resource
    private IBrandDgQueryApi brandDgQueryApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportBrandModeDto.class);
        ArrayList<ImportBrandModeDto> passList = new ArrayList<ImportBrandModeDto>();
        HashSet<String> codeSet = new HashSet<String>();
        HashSet<String> nameSet = new HashSet<String>();
        List nameList = list.stream().filter(e -> Objects.nonNull(e.getName())).map(ImportBrandModeDto::getName).collect(Collectors.toList());
        Map<String, Object> brandMap = new HashMap<String, BrandDgRespDto>();
        if (CollectionUtil.isNotEmpty(nameList)) {
            BrandPageDgReqDto reqDto = new BrandPageDgReqDto();
            reqDto.setNameList(nameList);
            List respDtos = (List)this.brandDgQueryApi.queryList(reqDto).getData();
            if (CollectionUtil.isNotEmpty((Collection)respDtos)) {
                brandMap = respDtos.stream().collect(Collectors.toMap(BrandDgRespDto::getName, Function.identity(), (k1, k2) -> k2));
            }
        }
        for (ImportBrandModeDto dto : list) {
            Boolean verify = this.brandVerify(dto, codeSet, nameSet, brandMap);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList brandDgReqDtos = Lists.newArrayList();
        try {
            for (ImportBrandModeDto brandModeDto : passList) {
                BrandReqDto dto = new BrandReqDto();
                BeanUtil.copyProperties((Object)brandModeDto, (Object)dto, (String[])new String[0]);
                brandDgReqDtos.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u54c1\u724c,\u6570\u91cf\u4e3a:{}", (Object)brandDgReqDtos.size());
        this.brandDgApi.importInsertBatch((List)brandDgReqDtos);
    }

    private Boolean brandVerify(ImportBrandModeDto dto, Set<String> codeSet, Set<String> nameSet, Map<String, BrandDgRespDto> brandMap) {
        if (Objects.isNull(dto.getCode())) {
            dto.setErrorMsg("\u54c1\u724c\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (dto.getCode().length() > 50) {
            dto.setErrorMsg("\u7f16\u7801\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
            return false;
        }
        if (codeSet.contains(dto.getCode())) {
            dto.setErrorMsg("\u7f16\u7801\u5df2\u5b58\u5728\u5217\u8868");
            return false;
        }
        if (codeSet.contains(dto.getCode())) {
            dto.setErrorMsg("\u54c1\u724c\u7f16\u7801\u5df2\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        codeSet.add(dto.getCode());
        if (Objects.isNull(dto.getName())) {
            dto.setErrorMsg("\u54c1\u724c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (dto.getName().length() > 50) {
            dto.setErrorMsg("\u54c1\u724c\u540d\u79f0\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
            return false;
        }
        if (nameSet.contains(dto.getName())) {
            dto.setErrorMsg("\u54c1\u724c\u540d\u79f0\u5df2\u5b58\u5728\u5217\u8868");
            return false;
        }
        nameSet.add(dto.getName());
        BrandDgRespDto brandDgRespDto = brandMap.get(dto.getName());
        if (Objects.nonNull(brandDgRespDto) && !Objects.equals(dto.getCode(), brandDgRespDto.getCode())) {
            dto.setErrorMsg(dto.getName() + "\u54c1\u724c\u540d\u79f0\u5df2\u5b58\u5728!");
            return false;
        }
        if (Objects.nonNull(dto.getRemark()) && dto.getRemark().length() > 100) {
            dto.setErrorMsg("\u5907\u6ce8\u4e0d\u53ef\u8d85\u8fc7100\u4e2a\u5b57");
            return false;
        }
        return true;
    }
}

