/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.customer.dto.request.DgCsShipmentEnterprisePageReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsShipmentEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.api.IDgCsShipmentEnterpriseApiProxy;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.mgmt.application.rpc.api.trade.IDgAfterSaleOrderQueryApi;
import com.yunxi.dg.base.mgmt.application.rpc.api.trade.IDgB2CAfterSaleStatemachineApi;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.DgAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.AfterSaleExpressImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_change_order_import")
public class ExchangeOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeOrderCommonServiceImpl.class);
    private static final String PASS = "pass";
    private static final String FAIL = "fail";
    private static final String FAIL_FILE_NAME = "\u6362\u8d27\u5355\u5bfc\u5165\u5931\u8d25\u5355\u636e";
    @Resource
    private IDgAfterSaleOrderQueryApi afterSaleOrderQueryApi;
    @Resource
    private IDgB2CAfterSaleStatemachineApi iDgB2CAfterSaleStatemachineApi;
    @Resource
    private IDgCsShipmentEnterpriseApiProxy dgCsShipmentEnterpriseApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u6362\u8d27\u5355\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        ArrayList passList = Lists.newArrayList();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), AfterSaleExpressImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        if (resultList.size() > 2000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc72000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        List<String> shippingNameList = resultList.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getShippingName())).map(p -> p.getShippingName()).collect(Collectors.toList());
        Map<String, DgCsShipmentEnterpriseRespDto> shipmentEnterpriseMap = this.getShipmentEnterpriseMap(shippingNameList);
        for (AfterSaleExpressImportDto afterSaleExpressImportDto : resultList) {
            boolean isPass = this.checkParam(afterSaleExpressImportDto, shipmentEnterpriseMap);
            if (isPass) {
                afterSaleExpressImportDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", afterSaleExpressImportDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), afterSaleExpressImportDto.getErrorMsg()));
                respDto.getErrorDetails().add(afterSaleExpressImportDto);
                continue;
            }
            passList.add(afterSaleExpressImportDto);
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    private Map<String, DgCsShipmentEnterpriseRespDto> getShipmentEnterpriseMap(List<String> shippingNameList) {
        if (CollectionUtil.isEmpty(shippingNameList)) {
            return Maps.newHashMap();
        }
        DgCsShipmentEnterprisePageReqDto dto = new DgCsShipmentEnterprisePageReqDto();
        dto.setNameList(shippingNameList);
        PageInfo pageInfo = (PageInfo)this.dgCsShipmentEnterpriseApiProxy.page(dto).getData();
        if (pageInfo == null || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return Maps.newHashMap();
        }
        return pageInfo.getList().stream().collect(Collectors.toMap(p -> p.getName(), Function.identity(), (k1, k2) -> k2));
    }

    private Map<String, String> setShipmentEnterpriseMap(DgCsShipmentEnterpriseRespDto dto) {
        HashMap map = Maps.newHashMap();
        map.put(dto.getName(), dto.getCode());
        return map;
    }

    private Map<Long, String> getAfterSaleOrderTypeMap(List<DgAfterSaleOrderRespDto> data) {
        return data.stream().collect(Collectors.toMap(BaseDto::getId, DgAfterSaleOrderDto::getAfterSaleOrderType, (k1, k2) -> k2));
    }

    public boolean checkParam(AfterSaleExpressImportDto afterSaleExpressImportDto, Map<String, DgCsShipmentEnterpriseRespDto> shipmentEnterpriseMap) {
        DgAfterSaleOrderDto dgAfterSaleOrderDto = new DgAfterSaleOrderDto();
        BeanCopyUtil.copyProperties((Object)afterSaleExpressImportDto, (Object)dgAfterSaleOrderDto);
        log.info("\u4ea4\u6613\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)dgAfterSaleOrderDto));
        StringBuffer errorMsg = new StringBuffer();
        if (StrUtil.isBlank((CharSequence)afterSaleExpressImportDto.getReturnShippingSn())) {
            errorMsg.append("\u9000\u56de\u8fd0\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((CharSequence)afterSaleExpressImportDto.getShippingName())) {
            DgCsShipmentEnterpriseRespDto dto = shipmentEnterpriseMap.get(afterSaleExpressImportDto.getShippingName());
            if (dto == null) {
                errorMsg.append("\u9000\u56de\u7269\u6d41\u5546\u4e0d\u5b58\u5728;");
            } else {
                afterSaleExpressImportDto.setShipmentEnterpriseMap(this.setShipmentEnterpriseMap(dto));
            }
        }
        if (StrUtil.isBlank((CharSequence)afterSaleExpressImportDto.getPlatformRefundOrderSn()) && StrUtil.isBlank((CharSequence)afterSaleExpressImportDto.getAfterSaleOrderNo()) && StrUtil.isBlank((CharSequence)afterSaleExpressImportDto.getPlatformOrderNo()) && StrUtil.isBlank((CharSequence)afterSaleExpressImportDto.getBeforeReturnShippingSn())) {
            errorMsg.append("\u67e5\u8be2\u65e0\u552e\u540e\u5355\u636e;");
        } else {
            dgAfterSaleOrderDto.setReturnShippingSn(afterSaleExpressImportDto.getBeforeReturnShippingSn());
            Optional.ofNullable(dgAfterSaleOrderDto.getReturnShippingSn()).ifPresent(s -> dgAfterSaleOrderDto.setReturnShippingSn(s.replaceAll("\\s", "")));
            Optional.ofNullable(dgAfterSaleOrderDto.getPlatformRefundOrderSn()).ifPresent(s -> dgAfterSaleOrderDto.setPlatformRefundOrderSn(s.replaceAll("\\s", "")));
            Optional.ofNullable(dgAfterSaleOrderDto.getAfterSaleOrderNo()).ifPresent(s -> dgAfterSaleOrderDto.setAfterSaleOrderNo(s.replaceAll("\\s", "")));
            Optional.ofNullable(dgAfterSaleOrderDto.getPlatformOrderNo()).ifPresent(s -> dgAfterSaleOrderDto.setPlatformOrderNo(s.replaceAll("\\s", "")));
            Optional.ofNullable(dgAfterSaleOrderDto.getShippingName()).ifPresent(s -> dgAfterSaleOrderDto.setShippingName(s.replaceAll("\\s", "")));
            dgAfterSaleOrderDto.setStatusList(Arrays.asList(DgAfterSaleOrderStatusEnum.WAIT_AUDIT.getCode(), DgAfterSaleOrderStatusEnum.WAIT_RETURN.getCode(), DgAfterSaleOrderStatusEnum.WAIT_CHECK_GOODS.getCode()));
            log.info("\u67e5\u8be2\u552e\u540e\u5355\u636e\u72b6\u6001\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)dgAfterSaleOrderDto));
            RestResponse listRestResponse = this.afterSaleOrderQueryApi.queryAfterSaleOrder(dgAfterSaleOrderDto);
            List data = (List)listRestResponse.getData();
            log.info("\u67e5\u8be2\u552e\u540e\u5355\u72b6\u6001:{}", (Object)JSONObject.toJSONString((Object)data));
            if (CollectionUtil.isEmpty((Collection)data)) {
                errorMsg.append("\u975e\u5f85\u5ba1\u6838\u3001\u5f85\u9000\u8d27\u3001\u5f85\u5165\u5e93\u72b6\u6001\u7684\u5355\u636e\u4e0d\u5bfc\u5165");
            } else {
                List afterSaleOrderIds = data.stream().map(BaseDto::getId).collect(Collectors.toList());
                afterSaleExpressImportDto.setAfterSaleOrderIds(afterSaleOrderIds);
                afterSaleExpressImportDto.setAfterSaleOrderTypeMap(this.getAfterSaleOrderTypeMap(data));
            }
        }
        afterSaleExpressImportDto.setErrorMsg(errorMsg.toString());
        return errorMsg.length() > 0;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        if (StringUtils.isBlank((CharSequence)ServiceContext.getContext().getRequestId())) {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        }
        List passResultList = (List)object;
        log.info("\u9000\u56de\u5feb\u9012\u5355\u53f7\u5bfc\u5165\u6210\u529f\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)passResultList));
        List failResultList = respDto.getErrorDetails();
        log.info("\u9000\u56de\u5feb\u9012\u5355\u53f7\u5bfc\u5165\u5931\u8d25\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)failResultList));
        if (CollectionUtil.isEmpty((Collection)passResultList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        for (AfterSaleExpressImportDto afterSaleExpressImportDto : passResultList) {
            Map afterSaleOrderTypeMap = afterSaleExpressImportDto.getAfterSaleOrderTypeMap();
            for (Long afterSaleOrderId : afterSaleExpressImportDto.getAfterSaleOrderIds()) {
                DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
                bizAfterSaleOrderReqDto.setId(afterSaleOrderId);
                bizAfterSaleOrderReqDto.setReturnShippingSn(afterSaleExpressImportDto.getReturnShippingSn());
                if (StringUtils.isNotEmpty((CharSequence)afterSaleExpressImportDto.getShippingName())) {
                    bizAfterSaleOrderReqDto.setShippingName(afterSaleExpressImportDto.getShippingName());
                    if (afterSaleExpressImportDto.getShipmentEnterpriseMap() != null) {
                        bizAfterSaleOrderReqDto.setShippingCode((String)afterSaleExpressImportDto.getShipmentEnterpriseMap().get(afterSaleExpressImportDto.getShippingName()));
                    }
                }
                try {
                    RestResponse response = this.iDgB2CAfterSaleStatemachineApi.modifyShipping((String)afterSaleOrderTypeMap.get(afterSaleOrderId), afterSaleOrderId, bizAfterSaleOrderReqDto);
                    if (response.getResultCode().equals("0")) continue;
                    log.error("\u4fee\u6539\u9000\u56de\u5feb\u9012\u53f7\u5931\u8d25afterSaleOrderNo:{}", (Object)bizAfterSaleOrderReqDto.getAfterSaleOrderNo());
                    afterSaleExpressImportDto.setErrorMsg("\u4fee\u6539\u9000\u56de\u5feb\u9012\u53f7\u5931\u8d25");
                    respDto.getErrorDetails().add(afterSaleExpressImportDto);
                }
                catch (Exception e) {
                    log.error("\u5bfc\u5165\u8fd0\u5355\u53f7\uff0c\u4fdd\u5b58\u5931\u8d25 {}", (Object)afterSaleExpressImportDto.getAfterSaleOrderNo(), (Object)e);
                    afterSaleExpressImportDto.setErrorMsg("\u4fee\u6539\u9000\u56de\u5feb\u9012\u53f7\u5931\u8d25");
                    respDto.getErrorDetails().add(afterSaleExpressImportDto);
                }
            }
        }
    }
}

