/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.reconciliationbiz.IChannelBillApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ChannelEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportJdFxBillDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ChannelBillDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_jd_fx_bill_import")
public class JdFxBillCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(JdFxBillCommonServiceImpl.class);
    @Resource
    protected IChannelBillApiProxy channelBillApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportJdFxBillDto.class);
        ArrayList<ImportJdFxBillDto> passList = new ArrayList<ImportJdFxBillDto>();
        for (ImportJdFxBillDto dto : list) {
            Boolean billVerify = this.jdBillVerify(dto);
            if (!billVerify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList channelBillDtos = Lists.newArrayList();
        try {
            for (ImportJdFxBillDto jdBillDto : passList) {
                jdBillDto.setDate(com.dtyunxi.util.DateUtil.format((Date)jdBillDto.getExcelDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (null != jdBillDto.getExcelBillDate()) {
                    jdBillDto.setBillDate(com.dtyunxi.util.DateUtil.format((Date)jdBillDto.getExcelBillDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                jdBillDto.setIncomeAmount(this.amountTransForZero(jdBillDto.getIncomeAmount()));
                jdBillDto.setExpenditureAmount(this.amountTransForZero(jdBillDto.getExpenditureAmount()));
                ChannelBillDto dto = new ChannelBillDto();
                dto.setChannelCode(ChannelEnum.JDFX.getCode());
                dto.setChannelName(ChannelEnum.JDFX.getName());
                dto.setSerialNo(jdBillDto.getMerchantOrderNumber());
                dto.setPlatformSerialNo(jdBillDto.getMerchantOrderNumber());
                dto.setUniqueSerialNo(jdBillDto.getMerchantOrderNumber().concat(jdBillDto.getDate()));
                dto.setProduceDate(DateUtil.parseDate((String)jdBillDto.getDate(), (String)"yyyyMMdd"));
                dto.setData(JSON.toJSONString((Object)jdBillDto));
                this.setCreatePerson(commonReqDto, dto);
                channelBillDtos.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u4eac\u4e1c\u5206\u9500\u539f\u59cb\u8d26\u5355,\u6570\u91cf\u4e3a:{}", (Object)channelBillDtos.size());
        this.channelBillApi.importInsertBatch((List)channelBillDtos);
    }

    private String amountTransForZero(String incomeAmount) {
        if (StringUtils.isBlank((CharSequence)incomeAmount) || "-".equals(incomeAmount) || "--".equals(incomeAmount)) {
            return "0";
        }
        return incomeAmount;
    }

    private Boolean jdBillVerify(ImportJdFxBillDto dto) {
        return true;
    }

    protected void setCreatePerson(ImportFileOperationCommonReqDto commonReqDto, ChannelBillDto dto) {
        dto.setCreatePerson(commonReqDto.getCreatePerson());
        dto.setUpdatePerson(commonReqDto.getCreatePerson());
    }
}

