/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.report.dto.agg.DgBasisOrderRelOrderInfoRespDto;
import com.yunxi.dg.base.center.report.dto.agg.DgRelOrderReqDto;
import com.yunxi.dg.base.center.report.proxy.agg.IDgBasisOrderRelOrderInfoApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.IOcsBasisOrderRelOrderInfoService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OcsBasisOrderRelOrderInfoServiceImpl
implements IOcsBasisOrderRelOrderInfoService {
    @Resource
    private IDgBasisOrderRelOrderInfoApiProxy basisOrderRelOrderInfoApiProxy;

    @Override
    public RestResponse<List<DgBasisOrderRelOrderInfoRespDto>> queryRelOrderByRelevanceNo(DgRelOrderReqDto reqDto) {
        List orderInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.basisOrderRelOrderInfoApiProxy.queryRelOrderByRelevanceNo(reqDto));
        if (CollectionUtil.isEmpty((Collection)orderInfoRespDtos)) {
            return new RestResponse();
        }
        Map<String, List<DgBasisOrderRelOrderInfoRespDto>> listMap = orderInfoRespDtos.stream().filter(o -> ObjectUtil.isNotNull((Object)o.getOrderType())).collect(Collectors.groupingBy(DgBasisOrderRelOrderInfoRespDto::getOrderType));
        if (ObjectUtil.isNull(listMap)) {
            return new RestResponse();
        }
        List<String> orderTypeList = Arrays.asList("delivery_notice_order", "out_notice_order", "out_result_order", "delivery_result_order", "receive_notice_order", "in_notice_order", "in_result_order", "receive_result_order");
        ArrayList<DgBasisOrderRelOrderInfoRespDto> list = new ArrayList<DgBasisOrderRelOrderInfoRespDto>();
        for (String orderType : orderTypeList) {
            if (!listMap.containsKey(orderType)) continue;
            List<DgBasisOrderRelOrderInfoRespDto> dgBasisOrderRelOrderInfoRespDtos = listMap.get(orderType);
            dgBasisOrderRelOrderInfoRespDtos.sort(Comparator.comparing(BaseRespDto::getCreateTime).reversed());
            list.addAll(dgBasisOrderRelOrderInfoRespDtos);
        }
        return new RestResponse(list);
    }
}

