/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.dto.entity.CsOrganizationPageQueryDto;
import com.yunxi.dg.base.center.report.dto.entity.CsOrganizationPageRespDto;
import com.yunxi.dg.base.center.report.proxy.customer.IDgOrganizationQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.api.inventorybiz.ICsLogicInventoryQueryApi;
import com.yunxi.dg.base.mgmt.application.rpc.api.userbiz.IDgOrganizationApi;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ChannelQueryReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgShopReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgCsChannelRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.api.IDgShopApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgCsChannelQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ShopStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.inventory.CsLogicInventoryQueryDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.inventory.CsLogicInventoryRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.user.OrganizationDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportOnlineShopDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_online_shop_import")
public class OnlineShopCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(OnlineShopCommonServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(OnlineShopCommonServiceImpl.class);
    @Resource
    private ICsLogicInventoryQueryApi iCsLogicInventoryQueryApi;
    @Resource
    private IDgOrganizationApi iDgOrganizationApi;
    @Resource
    private IDgCustomerQueryApiProxy iDgCustomerQueryApiProxy;
    @Resource
    private IDgCsChannelQueryApiProxy iDgCsChannelQueryApiProxy;
    @Resource
    private IDgOrganizationQueryApiProxy iDgOrganizationQueryApiProxy;
    @Resource
    private IDgShopApiProxy dgShopApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        Map<Object, Object> inventoryMap;
        Map<Object, Object> enterpriseMap;
        Map<Object, Object> channelMap;
        Map<Object, Object> customerMap;
        ArrayList importList = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        this.logger.info("\u8bfb\u53d6\u6570\u91cf===============>{}", (Object)result.getList().size());
        CubeBeanUtils.copyCollection(importList, (Collection)result.getList(), ImportOnlineShopDto.class);
        this.logger.info("\u5bfc\u5165\u6570\u91cf===============>{}", (Object)importList.size());
        ArrayList<ImportOnlineShopDto> passList = new ArrayList<ImportOnlineShopDto>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        List orgList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgOrganizationApi.queryOrgListByCode(importList.stream().map(ImportOnlineShopDto::getSaleOrganizationCode).filter(Objects::nonNull).collect(Collectors.toList())))).orElse(new ArrayList());
        Map<String, OrganizationDto> orgMap = orgList.stream().collect(Collectors.toMap(OrganizationDto::getCode, Function.identity(), (a, b) -> a));
        List customerCode = importList.stream().map(ImportOnlineShopDto::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerCode)) {
            JSONObject jo = new JSONObject();
            jo.put("codeInList", customerCode);
            List customerList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgCustomerQueryApiProxy.queryByList(JSON.toJSONString((Object)jo)))).orElse(new ArrayList());
            customerMap = customerList.stream().collect(Collectors.toMap(DgCustomerRespDto::getCode, Function.identity(), (a, b) -> a));
        } else {
            customerMap = Maps.newHashMap();
        }
        List channelCodes = importList.stream().map(ImportOnlineShopDto::getChannelCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(channelCodes)) {
            ChannelQueryReqDto channelQueryReqDto = new ChannelQueryReqDto();
            channelQueryReqDto.setCodes(channelCodes);
            List channelList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgCsChannelQueryApiProxy.queryListChannelByCodes(channelQueryReqDto))).orElse(new ArrayList());
            channelMap = channelList.stream().collect(Collectors.toMap(DgCsChannelRespDto::getChannelCode, Function.identity(), (a, b) -> a));
        } else {
            channelMap = Maps.newHashMap();
        }
        List orgIds = orgList.stream().map(OrganizationDto::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIds)) {
            CsOrganizationPageQueryDto organizationPageQueryDto = new CsOrganizationPageQueryDto();
            organizationPageQueryDto.setIdList(orgIds);
            List channelList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgOrganizationQueryApiProxy.querySaleOrgByList(organizationPageQueryDto))).orElse(new ArrayList());
            enterpriseMap = channelList.stream().collect(Collectors.toMap(CsOrganizationPageRespDto::getCode, Function.identity(), (a, b) -> a));
        } else {
            enterpriseMap = Maps.newHashMap();
        }
        List warehouseCodes = importList.stream().map(ImportOnlineShopDto::getLogicWarehouseCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(warehouseCodes)) {
            CsLogicInventoryQueryDto inventoryQueryDto = new CsLogicInventoryQueryDto();
            inventoryQueryDto.setWarehouseCodeList(warehouseCodes);
            List inventoryList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iCsLogicInventoryQueryApi.queryInfoList(inventoryQueryDto))).orElse(new ArrayList());
            inventoryMap = inventoryList.stream().collect(Collectors.toMap(CsLogicInventoryRespDto::getWarehouseCode, Function.identity(), (a, b) -> a));
        } else {
            inventoryMap = Maps.newHashMap();
        }
        for (ImportOnlineShopDto importDto : importList) {
            Boolean verify = this.onlineShopVerify(importDto, orgMap, customerMap, channelMap, enterpriseMap, inventoryMap);
            if (!verify.booleanValue()) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        respDto.setDetails(passList);
        dataMap.put("passList", passList);
        dataMap.put("orgMap", orgMap);
        dataMap.put("enterpriseMap", enterpriseMap);
        dataMap.put("customerMap", customerMap);
        dataMap.put("channelMap", channelMap);
        dataMap.put("inventoryMap", inventoryMap);
        return dataMap;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        Map dataMap = (Map)object;
        List passList = (List)dataMap.get("passList");
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        Map orgMap = (Map)dataMap.get("orgMap");
        Map enterpriseMap = (Map)dataMap.get("enterpriseMap");
        Map customerMap = (Map)dataMap.get("customerMap");
        Map channelMap = (Map)dataMap.get("channelMap");
        Map inventoryMap = (Map)dataMap.get("inventoryMap");
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList reqDtoList = new ArrayList();
        try {
            passList.forEach(dto -> {
                DgShopReqDto shopReqDto = new DgShopReqDto();
                reqDtoList.add(shopReqDto);
                shopReqDto.setStoreName(dto.getStoreName());
                shopReqDto.setCustomerCode(dto.getCustomerCode());
                shopReqDto.setCustomerName(((DgCustomerRespDto)customerMap.get(dto.getCustomerCode())).getName());
                shopReqDto.setStoreType(Integer.valueOf(1));
                shopReqDto.setSaleOrganizationCode(dto.getSaleOrganizationCode());
                shopReqDto.setSaleOrganizationId(((OrganizationDto)orgMap.get(dto.getSaleOrganizationCode())).getId());
                shopReqDto.setSaleOrganizationName(((OrganizationDto)orgMap.get(dto.getSaleOrganizationCode())).getName());
                CsOrganizationPageRespDto csOrganizationPageRespDto = (CsOrganizationPageRespDto)enterpriseMap.get(dto.getSaleOrganizationCode());
                if (csOrganizationPageRespDto != null) {
                    shopReqDto.setSaleCompanyCode(csOrganizationPageRespDto.getEnterpriseCode());
                    shopReqDto.setSaleCompanyId(csOrganizationPageRespDto.getEnterpriseId());
                    shopReqDto.setSaleCompanyName(csOrganizationPageRespDto.getEnterpriseName());
                }
                shopReqDto.setChannelCode(dto.getChannelCode());
                shopReqDto.setChannelId(((DgCsChannelRespDto)channelMap.get(dto.getChannelCode())).getId());
                shopReqDto.setChannelName(((DgCsChannelRespDto)channelMap.get(dto.getChannelCode())).getChannelName());
                if (StringUtils.isNotBlank((CharSequence)dto.getStatus())) {
                    ShopStatusEnum statusEnum = ShopStatusEnum.enumOf((String)dto.getStatus());
                    if (statusEnum != null) {
                        shopReqDto.setStatus(statusEnum.getType());
                    } else {
                        shopReqDto.setStatus(Integer.valueOf(1));
                    }
                } else {
                    shopReqDto.setStatus(Integer.valueOf(1));
                }
                shopReqDto.setRemark(dto.getRemark());
                shopReqDto.setLineType(Integer.valueOf(1));
                if (StringUtils.isNotBlank((CharSequence)dto.getLogicWarehouseCode())) {
                    shopReqDto.setLogicWarehouseCode(dto.getLogicWarehouseCode());
                    shopReqDto.setLogicWarehouseId(((CsLogicInventoryRespDto)inventoryMap.get(dto.getLogicWarehouseCode())).getWarehouseId());
                }
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u7ebf\u4e0a\u5e97\u94fa,\u6570\u91cf\u4e3a:{}", (Object)reqDtoList.size());
        RestResponseHelper.checkOrThrow((RestResponse)this.dgShopApiProxy.addShopBatch(reqDtoList));
    }

    private Boolean onlineShopVerify(ImportOnlineShopDto dto, Map<String, OrganizationDto> orgMap, Map<String, DgCustomerRespDto> customerMap, Map<String, DgCsChannelRespDto> channelMap, Map<String, CsOrganizationPageRespDto> enterpriseMap, Map<String, CsLogicInventoryRespDto> inventoryMap) {
        if (StringUtils.isBlank((CharSequence)dto.getSaleOrganizationCode())) {
            dto.setErrorMsg("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getStoreName())) {
            dto.setErrorMsg("\u5e97\u94fa\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getChannelCode())) {
            dto.setErrorMsg("\u6240\u5c5e\u6e20\u9053\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getCustomerCode())) {
            dto.setErrorMsg("\u6240\u5c5e\u5ba2\u6237\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (!orgMap.containsKey(dto.getSaleOrganizationCode())) {
            dto.setErrorMsg("\u672a\u627e\u5230\u9500\u552e\u7ec4\u7ec7\uff1a" + dto.getSaleOrganizationCode());
            return false;
        }
        if (!customerMap.containsKey(dto.getCustomerCode())) {
            dto.setErrorMsg("\u672a\u627e\u5230\u6240\u5c5e\u5ba2\u6237\uff1a" + dto.getCustomerCode());
            return false;
        }
        if (!channelMap.containsKey(dto.getChannelCode())) {
            dto.setErrorMsg("\u672a\u627e\u5230\u6240\u5c5e\u6e20\u9053\uff1a" + dto.getChannelCode());
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getLogicWarehouseCode()) && !inventoryMap.containsKey(dto.getLogicWarehouseCode())) {
            dto.setErrorMsg("\u672a\u627e\u5230\u4e09\u65b9\u5c65\u7ea6\u9ed8\u8ba4\u4ed3\uff1a" + dto.getLogicWarehouseCode());
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getStatus()) && ShopStatusEnum.enumOf((String)dto.getStatus()) == null) {
            dto.setErrorMsg("\u72b6\u6001\u8bbe\u7f6e\u9519\u8bef\uff1a" + dto.getStatus());
            return false;
        }
        return true;
    }
}

