/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.user.dto.dto.OrgAdvAddReqDto;
import com.yunxi.dg.base.center.user.dto.dto.OrgQueryReqDto;
import com.yunxi.dg.base.center.user.dto.dto.OrganizationDto;
import com.yunxi.dg.base.center.user.proxy.IDgOrganizationApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.utils.RequestUtil;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportDepartmentDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_department_import")
public class DepartmentCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(DepartmentCommonServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(DepartmentCommonServiceImpl.class);
    @Resource
    private IDgOrganizationApiProxy iDgOrganizationApiProxy;
    public static final String HEADER_ROOT_ORGANIZATION_ID_KEY = "Root-Organization-Id";

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        String rootOrgId = RequestUtil.getRequest().getHeader(HEADER_ROOT_ORGANIZATION_ID_KEY);
        rootOrgId = StrUtil.isBlank((CharSequence)rootOrgId) ? "0" : rootOrgId;
        Long rootOrganizationId = Long.parseLong(rootOrgId);
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        this.logger.info("\u8bfb\u53d6\u6570\u91cf===============>{}", (Object)result.getList().size());
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportDepartmentDto.class);
        this.logger.info("\u5bfc\u5165\u6570\u91cf===============>{}", (Object)list.size());
        ArrayList<ImportDepartmentDto> passList = new ArrayList<ImportDepartmentDto>();
        HashMap<String, List> dataMap = new HashMap<String, List>();
        OrgQueryReqDto orgQueryReqDto = new OrgQueryReqDto();
        orgQueryReqDto.setFuncType("human_resource");
        orgQueryReqDto.setOrganizationId(rootOrganizationId);
        List existDepartmentList = (List)this.iDgOrganizationApiProxy.queryOrgListByOrgIdAndFuncType(orgQueryReqDto).getData();
        ArrayList<String> existDepartmentCodeList = new ArrayList();
        HashMap<String, List<String>> depMap = new HashMap<String, List<String>>();
        if (CollectionUtil.isNotEmpty((Collection)existDepartmentList)) {
            existDepartmentCodeList = existDepartmentList.stream().map(OrganizationDto::getCode).collect(Collectors.toList());
            Map<Long, List<OrganizationDto>> assistMap = existDepartmentList.stream().collect(Collectors.groupingBy(OrganizationDto::getParentId));
            Map<Long, String> idCodeMap = existDepartmentList.stream().collect(Collectors.toMap(OrganizationDto::getId, OrganizationDto::getCode, (o1, o2) -> o2));
            assistMap.forEach((k, v) -> {
                String code = (String)idCodeMap.get(k);
                if (Objects.isNull(code)) {
                    return;
                }
                depMap.put(code, ((List)Optional.ofNullable(v).orElse(new ArrayList())).stream().map(OrganizationDto::getName).collect(Collectors.toList()));
            });
        }
        for (ImportDepartmentDto dto : list) {
            Boolean verify = this.saleOrgVerify(dto, existDepartmentCodeList, depMap);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        dataMap.put("passList", passList);
        dataMap.put("existDepartmentList", existDepartmentList);
        return dataMap;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        Map dataMap = (Map)object;
        List passList = (List)dataMap.get("passList");
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        List existEnterpriseList = (List)dataMap.get("existDepartmentList");
        Map<String, Long> idMap = existEnterpriseList.stream().collect(Collectors.toMap(OrganizationDto::getCode, OrganizationDto::getId));
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList<OrgAdvAddReqDto> reqDtoList = new ArrayList<OrgAdvAddReqDto>();
        try {
            for (ImportDepartmentDto dto : passList) {
                OrgAdvAddReqDto reqDto = new OrgAdvAddReqDto();
                reqDto.setCode(dto.getCode());
                reqDto.setName(dto.getName());
                reqDto.setParentId(idMap.get(dto.getParentCode()));
                reqDto.setType("2");
                reqDto.setFuncTypeCodes(Collections.singletonList("human_resource"));
                reqDto.setEntityPropCode("department");
                reqDtoList.add(reqDto);
            }
            log.info("\u6279\u91cf\u4fdd\u5b58\u90e8\u95e8,\u6570\u91cf\u4e3a:{}", (Object)reqDtoList.size());
            RestResponseHelper.extractData((RestResponse)this.iDgOrganizationApiProxy.addOrganizationBatch(reqDtoList));
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u6570\u636e\uff0c\u5931\u8d25\u4e86", (Throwable)e);
            passList.forEach(item -> item.setErrorMsg("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage()));
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
        }
    }

    private Boolean saleOrgVerify(ImportDepartmentDto dto, List<String> existOrgCodeList, Map<String, List<String>> depMap) {
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            dto.setErrorMsg("\u90e8\u95e8\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getCode())) {
            dto.setErrorMsg("\u90e8\u95e8\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getParentCode())) {
            dto.setErrorMsg("\u4e0a\u7ea7\u90e8\u95e8\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (existOrgCodeList.contains(dto.getCode())) {
            dto.setErrorMsg("\u90e8\u95e8\u7f16\u7801\u5df2\u5b58\u5728\uff1a" + dto.getCode());
            return false;
        }
        if (!existOrgCodeList.contains(dto.getParentCode())) {
            dto.setErrorMsg("\u4e0a\u7ea7\u90e8\u95e8\u7f16\u7801\u4e0d\u5b58\u5728\uff1a" + dto.getParentCode());
            return false;
        }
        List<String> depNameList = depMap.get(dto.getParentCode());
        if (CollectionUtil.isNotEmpty(depNameList) && depNameList.contains(dto.getName())) {
            dto.setErrorMsg("\u540d\u79f0\u5728\u540c\u4e00\u90e8\u95e8\u4e2d\u5df2\u5b58\u5728");
            return false;
        }
        return true;
    }
}

