/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dto.ItemInvoiceConditionReqDto;
import com.yunxi.dg.base.center.item.dto.ItemInvoiceDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSkuExtListDgRespDto;
import com.yunxi.dg.base.center.item.proxy.api.IItemInvoiceApiProxy;
import com.yunxi.dg.base.center.item.proxy.query.IItemExtQueryApiProxy;
import com.yunxi.dg.base.center.item.proxy.query.IItemInvoiceQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.FinancialManagementInvoiceManagementGoodsInvoicingInfoService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.SpecialInvoiceRemarkEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.BatchDeleteGoodsInvoicingInfoParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetGoodsInvoicingInfoListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GoodsInvoiceImportDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GoodsInvoicingInfoVO;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="AbstractBaseFileOperationCommonService_GOODS_INVOICING")
public class FinancialManagementInvoiceManagementGoodsInvoicingInfoServiceServiceImpl
extends AbstractBaseFileOperationCommonService
implements FinancialManagementInvoiceManagementGoodsInvoicingInfoService {
    private static Logger logger = LoggerFactory.getLogger(FinancialManagementInvoiceManagementGoodsInvoicingInfoServiceServiceImpl.class);
    @Resource
    private IItemInvoiceApiProxy itemInvoiceApiProxy;
    @Resource
    private IItemInvoiceQueryApiProxy itemInvoiceQueryApiProxy;
    @Resource
    private IItemExtQueryApiProxy itemExtQueryApiProxy;

    @Override
    public RestResponse<Object> addGoodsInvoicingInfo(@ApiParam(value="") @Valid @RequestBody(required=false) GoodsInvoicingInfoVO goodsInvoicingInfoVO) {
        String goodsCode = goodsInvoicingInfoVO.getGoodsCode();
        ArrayList<String> queryList = new ArrayList<String>();
        queryList.add(goodsCode);
        List itemInvoiceDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemInvoiceQueryApiProxy.queryInvoiceByItemCodes(queryList));
        if (CollectionUtils.isNotEmpty((Collection)itemInvoiceDtos)) {
            throw new BizException("\u8be5\u5f00\u7968\u5546\u54c1\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\u6570\u636e,\u8bf7\u6838\u5b9e");
        }
        ItemInvoiceDto addReqDto = new ItemInvoiceDto();
        addReqDto.setSkuCode(goodsInvoicingInfoVO.getGoodsCode());
        addReqDto.setSkuDisplayName(goodsInvoicingInfoVO.getGoodsDesc());
        addReqDto.setSkuName(goodsInvoicingInfoVO.getGoodsName());
        addReqDto.setItemType(goodsInvoicingInfoVO.getGoodsClassification());
        addReqDto.setPatentName(goodsInvoicingInfoVO.getPatent());
        addReqDto.setTaxRate(new BigDecimal(goodsInvoicingInfoVO.getTaxRate()));
        addReqDto.setTaxCategoryCode(goodsInvoicingInfoVO.getTaxClassificationCode());
        addReqDto.setPatentNo(goodsInvoicingInfoVO.getPatentNo());
        addReqDto.setSpecialInvoiceRemark(goodsInvoicingInfoVO.getSpecialInvoiceRemark());
        if (goodsInvoicingInfoVO.getTaxClassificationCode().length() > 19) {
            throw new BizException("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
        }
        return new RestResponse(this.itemInvoiceApiProxy.addItemInvoice(addReqDto).getData());
    }

    @Override
    public RestResponse<Object> deleteGoodsInvoicingInfo(@ApiParam(value="") @Valid @RequestBody(required=false) BatchDeleteGoodsInvoicingInfoParams batchDeleteGoodsInvoicingInfoParams) {
        List ids = batchDeleteGoodsInvoicingInfoParams.getIds().stream().map(e -> Long.parseLong(e.trim())).collect(Collectors.toList());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.itemInvoiceApiProxy.removeByIds(ids)));
    }

    @Override
    public RestResponse<GoodsInvoicingInfoVO> getGoodsInvoicingInfoDetail(@NotNull @ApiParam(value="", required=true) @Valid @RequestParam(value="id", required=true) String id) {
        ItemInvoiceDto itemInvoiceDto = (ItemInvoiceDto)this.itemInvoiceQueryApiProxy.queryById(Long.valueOf(Long.parseLong(id))).getData();
        GoodsInvoicingInfoVO invoicingInfoVO = new GoodsInvoicingInfoVO();
        this.dtoToVo(itemInvoiceDto, invoicingInfoVO);
        return new RestResponse((Object)invoicingInfoVO);
    }

    @Override
    public RestResponse<PageInfo<GoodsInvoicingInfoVO>> getGoodsInvoicingInfoListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetGoodsInvoicingInfoListPageParams getGoodsInvoicingInfoListPageParams) {
        ItemInvoiceConditionReqDto reqDto = new ItemInvoiceConditionReqDto();
        this.getQueryByPageParam(reqDto, getGoodsInvoicingInfoListPageParams);
        PageInfo dtoPageInfo = (PageInfo)this.itemInvoiceQueryApiProxy.queryByPages(reqDto).getData();
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<GoodsInvoicingInfoVO> invoicingInfoVOS = new ArrayList<GoodsInvoicingInfoVO>();
        if (CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) {
            for (ItemInvoiceDto itemInvoiceDto : dtoPageInfo.getList()) {
                GoodsInvoicingInfoVO infoVO = new GoodsInvoicingInfoVO();
                this.dtoToVo(itemInvoiceDto, infoVO);
                infoVO.setGoodsDesc(itemInvoiceDto.getSkuDisplayName());
                infoVO.setGoodsCode(itemInvoiceDto.getSkuCode());
                infoVO.setGoodsName(itemInvoiceDto.getSkuName());
                infoVO.setGoodsSimpleName(itemInvoiceDto.getSkuDisplayName());
                invoicingInfoVOS.add(infoVO);
            }
        }
        pageInfo.setList(invoicingInfoVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateGoodsInvoicingInfo(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) GoodsInvoicingInfoVO goodsInvoicingInfoVO) {
        ItemInvoiceDto addReqDto = new ItemInvoiceDto();
        addReqDto.setId(Long.valueOf(Long.parseLong(id)));
        addReqDto.setSkuCode(goodsInvoicingInfoVO.getGoodsCode());
        addReqDto.setSkuDisplayName(goodsInvoicingInfoVO.getGoodsSimpleName());
        addReqDto.setSkuName(goodsInvoicingInfoVO.getGoodsName());
        addReqDto.setPatentName(goodsInvoicingInfoVO.getPatent());
        addReqDto.setItemType(goodsInvoicingInfoVO.getGoodsClassification());
        addReqDto.setTaxRate(new BigDecimal(goodsInvoicingInfoVO.getTaxRate()));
        addReqDto.setTaxCategoryCode(goodsInvoicingInfoVO.getTaxClassificationCode());
        addReqDto.setPatentNo(goodsInvoicingInfoVO.getPatentNo());
        addReqDto.setSpecialInvoiceRemark(goodsInvoicingInfoVO.getSpecialInvoiceRemark());
        if (goodsInvoicingInfoVO.getTaxClassificationCode().length() > 19) {
            throw new BizException("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.itemInvoiceApiProxy.modifyItemInvoice(addReqDto)));
    }

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), GoodsInvoiceImportDto.class);
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        List itemCodeList = list.stream().map(GoodsInvoiceImportDto::getSkuCode).distinct().collect(Collectors.toList());
        List itemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemExtQueryApiProxy.querySkuExtBySkuCodes(itemCodeList));
        Map itemCodeMap = ((List)Optional.ofNullable(itemRespDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuExtListDgRespDto::getCode, Function.identity(), (v1, v2) -> v2));
        list.forEach(i -> {
            String name;
            ArrayList<String> errorList = new ArrayList<String>();
            if (Objects.isNull(i.getSkuCode())) {
                errorList.add("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            } else if (!itemCodeMap.containsKey(i.getSkuCode())) {
                errorList.add("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            if (Objects.isNull(i.getTaxCategoryCode())) {
                errorList.add("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
            } else if (i.getTaxCategoryCode().length() > 19) {
                errorList.add("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
            }
            if (Objects.isNull(i.getTaxRate())) {
                errorList.add("\u7a0e\u7387\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)i.getSpecialInvoiceRemark()) && StringUtils.isBlank((CharSequence)(name = SpecialInvoiceRemarkEnum.getCodeByName((String)i.getSpecialInvoiceRemark().trim())))) {
                errorList.add("\u7279\u6b8a\u53d1\u7968\u5907\u6ce8\u6709\u8bef\uff0c\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u679a\u4e3e");
            }
            if (CollectionUtils.isNotEmpty(errorList)) {
                i.setErrorMsg(String.join((CharSequence)",", errorList));
                i.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", i.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), i.getErrorMsg()));
                respDto.getErrorDetails().add(i);
            } else {
                i.setSpecialInvoiceRemark(SpecialInvoiceRemarkEnum.getCodeByName((String)i.getSpecialInvoiceRemark()));
                saveList.add(i);
            }
        });
        return saveList;
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List saveList;
        if (object != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)object))) {
            try {
                RestResponseHelper.extractData((RestResponse)this.itemInvoiceApiProxy.batchAddItemInvoice(BeanUtil.copyToList((Collection)saveList, ItemInvoiceDto.class)));
            }
            catch (Exception e) {
                saveList.forEach(i -> {
                    i.setErrorMsg("\u5bfc\u5165\u5931\u8d25" + e.getMessage());
                    i.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", i.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), i.getErrorMsg()));
                    respDto.getErrorDetails().add(i);
                });
            }
        }
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.callBackImportFileOperationCommonSync(result, commonReqDto, respDto, object);
    }

    public void dtoToVo(ItemInvoiceDto itemInvoiceDto, GoodsInvoicingInfoVO invoicingInfoVO) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        invoicingInfoVO.setId(itemInvoiceDto.getId());
        invoicingInfoVO.setGoodsCode(itemInvoiceDto.getSkuCode());
        invoicingInfoVO.setGoodsSimpleName(itemInvoiceDto.getSkuDisplayName());
        invoicingInfoVO.setGoodsDesc(itemInvoiceDto.getSkuDisplayName());
        invoicingInfoVO.setGoodsName(itemInvoiceDto.getSkuName());
        invoicingInfoVO.setPatent(itemInvoiceDto.getPatentName());
        invoicingInfoVO.setGoodsClassification(itemInvoiceDto.getItemType());
        invoicingInfoVO.setTaxRate(String.valueOf(itemInvoiceDto.getTaxRate()));
        invoicingInfoVO.setTaxClassificationCode(itemInvoiceDto.getTaxCategoryCode());
        invoicingInfoVO.setCreatePerson(itemInvoiceDto.getCreatePerson());
        invoicingInfoVO.setCreateTime(itemInvoiceDto.getCreateTime());
        invoicingInfoVO.setUpdatePerson(itemInvoiceDto.getUpdatePerson());
        invoicingInfoVO.setUpdateTime(itemInvoiceDto.getUpdateTime());
        invoicingInfoVO.setPatentNo(itemInvoiceDto.getPatentNo());
        invoicingInfoVO.setSpecification(itemInvoiceDto.getSpecification());
        invoicingInfoVO.setThirdCode(itemInvoiceDto.getThirdCode());
        invoicingInfoVO.setEnergyEfficiencyRating(itemInvoiceDto.getEnergyEfficiencyRating());
        invoicingInfoVO.setSpecialInvoiceRemark(itemInvoiceDto.getSpecialInvoiceRemark());
        invoicingInfoVO.setSpecialInvoiceRemarkName(SpecialInvoiceRemarkEnum.getNameByCode((String)itemInvoiceDto.getSpecialInvoiceRemark()));
    }

    public void getQueryByPageParam(ItemInvoiceConditionReqDto reqDto, GetGoodsInvoicingInfoListPageParams getGoodsInvoicingInfoListPageParams) {
        reqDto.setPageSize(getGoodsInvoicingInfoListPageParams.getPageSize());
        reqDto.setPageNum(getGoodsInvoicingInfoListPageParams.getPageNum());
        reqDto.setUpdateBeginTime(getGoodsInvoicingInfoListPageParams.getUpdateTimeStart());
        reqDto.setUpdateEndTime(getGoodsInvoicingInfoListPageParams.getUpdateTimeEnd());
        reqDto.setItemCode(getGoodsInvoicingInfoListPageParams.getGoodsCode());
        reqDto.setTaxCategoryCode(getGoodsInvoicingInfoListPageParams.getTaxClassificationCode());
        reqDto.setPatentName(getGoodsInvoicingInfoListPageParams.getPatent());
        reqDto.setPatentNo(getGoodsInvoicingInfoListPageParams.getPatentNo());
        reqDto.setItemName(getGoodsInvoicingInfoListPageParams.getGoodsName());
        reqDto.setItemType(getGoodsInvoicingInfoListPageParams.getGoodsClassification());
        reqDto.setPatentNo(getGoodsInvoicingInfoListPageParams.getPatentNo());
        reqDto.setItemDisplayName(getGoodsInvoicingInfoListPageParams.getGoodsDesc());
        reqDto.setSpecification(getGoodsInvoicingInfoListPageParams.getSpecification());
        reqDto.setThirdCode(getGoodsInvoicingInfoListPageParams.getThirdCode());
        reqDto.setEnergyEfficiencyRating(getGoodsInvoicingInfoListPageParams.getEnergyEfficiencyRating());
        reqDto.setSpecialInvoiceRemark(getGoodsInvoicingInfoListPageParams.getSpecialInvoiceRemark());
    }
}

