/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.dto.enums.AdjustmentBusinessTypeEnum;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.proxy.business.IInventoryAdjustmentOrderApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.UnitDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IDgLogicInventoryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.unit.IUnitDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.config.InventoryConfig;
import com.yunxi.dg.base.mgmt.service.context.OcsConfig;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportInventoryAdjustmentOrderDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_inventory_adjustment_order_import")
public class InventoryAdjustmentOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(InventoryAdjustmentOrderCommonServiceImpl.class);
    @Resource
    private IInventoryAdjustmentOrderApiProxy inventoryAdjustmentOrderApiProxy;
    @Resource
    private IDgLogicInventoryApiProxy iDgLogicInventoryApiProxy;
    @Resource
    private IUnitDgQueryApiProxy iUnitDgQueryApiProxy;
    @Resource
    private IDictQueryApiProxy iDictQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5e93\u5b58\u8c03\u6574\u5355\u8bfb\u53d6\u6570\u91cf====>>>{}", (Object)result.getList().size());
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList list = new ArrayList();
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportInventoryAdjustmentOrderDto.class);
        ArrayList<ImportInventoryAdjustmentOrderDto> passList = new ArrayList<ImportInventoryAdjustmentOrderDto>();
        ArrayList skuCodeList = new ArrayList();
        ArrayList warehouseCodeList = new ArrayList();
        ArrayList batchList = new ArrayList();
        ArrayList unitNameList = new ArrayList();
        list.forEach(importDto -> {
            if (StringUtils.isNotBlank((CharSequence)importDto.getSkuCode())) {
                skuCodeList.add(importDto.getSkuCode());
            }
            if (StringUtils.isNotBlank((CharSequence)importDto.getWarehouseCode())) {
                warehouseCodeList.add(importDto.getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)importDto.getBatch())) {
                batchList.add(importDto.getBatch());
            }
            if (StringUtils.isNotBlank((CharSequence)importDto.getUnit())) {
                unitNameList.add(importDto.getUnit());
            }
        });
        DgLogicInventoryListReqDto logicReqDto = new DgLogicInventoryListReqDto();
        logicReqDto.setWarehouseCodeList(warehouseCodeList);
        List inventoryRespList = (List)RestResponseHelper.extractData((RestResponse)this.iDgLogicInventoryApiProxy.queryList(logicReqDto));
        Map<String, List<DgLogicInventoryDto>> warehouseCodeMap = ((List)Optional.of(inventoryRespList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(DgLogicInventoryDto::getWarehouseCode));
        List unitRespList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iUnitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(new ArrayList());
        Map<String, UnitDgRespDto> unitMap = ((List)Optional.of(unitRespList).orElse(new ArrayList())).stream().collect(Collectors.toMap(UnitDgRespDto::getName, Function.identity(), (key1, key2) -> key1));
        Map<String, UnitDgRespDto> unitCodeMap = ((List)Optional.of(unitRespList).orElse(new ArrayList())).stream().collect(Collectors.toMap(UnitDgRespDto::getCode, Function.identity(), (key1, key2) -> key1));
        ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
        itemQueryDgReqDto.setSkuCodes(skuCodeList);
        List itemSkuDgRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApiProxy.querySkuList(itemQueryDgReqDto))).orElse(new ArrayList());
        Map<String, DgItemSkuDetailRespDto> itemSkuDgRespDtoMap = itemSkuDgRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.iDictQueryApiProxy.queryByGroupCodeAndCode("special_batch", "special_batch"));
        HashMap<String, DictValueDto> specialBatchMap = new HashMap();
        if (Objects.nonNull(dictDto)) {
            specialBatchMap = dictDto.getDictValueList().stream().collect(Collectors.toMap(DictValueDto::getValue, Function.identity(), (key1, key2) -> key1));
        }
        for (ImportInventoryAdjustmentOrderDto dto : list) {
            boolean verify = this.verifyInventoryAdjustmentOrderImportParams(dto, warehouseCodeMap, unitMap, specialBatchMap, itemSkuDgRespDtoMap, unitCodeMap);
            if (!verify) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        log.info("\u5e93\u5b58\u8c03\u6574\u5355\u6821\u9a8c\u901a\u8fc7\u6570\u91cf====>>>{}", (Object)passList.size());
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)passList) && CollectionUtils.isNotEmpty((Collection)respDto.getErrorDetails())) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        ArrayList reqDtoList = new ArrayList();
        passList.stream().collect(Collectors.groupingBy(ImportInventoryAdjustmentOrderDto::getOrderUniqueKey)).forEach((key, value) -> {
            AdjustmentOrderDto orderDto = (AdjustmentOrderDto)BeanUtil.toBean(value.get(0), AdjustmentOrderDto.class);
            orderDto.setAdjustmentOrderDetailDtos(new ArrayList());
            orderDto.setEvent("submit");
            orderDto.setOrderType("INVENTORY_ADJUSTMENT");
            orderDto.setPushSap(((ImportInventoryAdjustmentOrderDto)value.get(0)).getPushErp());
            orderDto.setPushWms(((ImportInventoryAdjustmentOrderDto)value.get(0)).getPushWms());
            orderDto.setBusinessType(((ImportInventoryAdjustmentOrderDto)value.get(0)).getBusinessType());
            orderDto.setWarehouseCode(((ImportInventoryAdjustmentOrderDto)value.get(0)).getWarehouseCode());
            orderDto.setBizDate(DateUtil.parseDate((String)((ImportInventoryAdjustmentOrderDto)value.get(0)).getBizDate(), (String)"yyyy/MM/dd"));
            orderDto.setWarehouseCode(((ImportInventoryAdjustmentOrderDto)value.get(0)).getWarehouseCode());
            orderDto.setWarehouseName(((ImportInventoryAdjustmentOrderDto)value.get(0)).getWarehouseName());
            orderDto.setOrganizationCode(((ImportInventoryAdjustmentOrderDto)value.get(0)).getOrganizationCode());
            orderDto.setOrganizationName(((ImportInventoryAdjustmentOrderDto)value.get(0)).getOrganizationName());
            orderDto.setPhysicsWarehouseCode(((ImportInventoryAdjustmentOrderDto)value.get(0)).getPhysicsWarehouseCode());
            orderDto.setPhysicsWarehouseName(((ImportInventoryAdjustmentOrderDto)value.get(0)).getPhysicsWarehouseName());
            orderDto.setInventoryProperty(((ImportInventoryAdjustmentOrderDto)value.get(0)).getInventoryProperty());
            Map<String, List<ImportInventoryAdjustmentOrderDto>> deatilMap = value.stream().collect(Collectors.groupingBy(ImportInventoryAdjustmentOrderDto::getDetailUniqueKey));
            deatilMap.forEach((detailKey, detailValue) -> {
                AdjustmentOrderDetailDto detailDto = (AdjustmentOrderDetailDto)BeanUtil.toBean(detailValue.get(0), AdjustmentOrderDetailDto.class);
                detailDto.setSkuCode(((ImportInventoryAdjustmentOrderDto)detailValue.get(0)).getSkuCode());
                detailDto.setBatch(((ImportInventoryAdjustmentOrderDto)detailValue.get(0)).getBatch());
                detailDto.setProduceTime(DateUtil.parseDate((String)((ImportInventoryAdjustmentOrderDto)detailValue.get(0)).getProduceTime(), (String)"yyyy/MM/dd"));
                detailDto.setExpireTime(DateUtil.parseDate((String)((ImportInventoryAdjustmentOrderDto)detailValue.get(0)).getExpireTime(), (String)"yyyy/MM/dd"));
                detailDto.setChangeType(((ImportInventoryAdjustmentOrderDto)detailValue.get(0)).getAdjustmentType());
                detailDto.setChangeQuantity(detailValue.stream().map(ImportInventoryAdjustmentOrderDto::getChangeQuantity).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add));
                detailDto.setUnit(((ImportInventoryAdjustmentOrderDto)detailValue.get(0)).getUnit());
                detailDto.setRemark(((ImportInventoryAdjustmentOrderDto)detailValue.get(0)).getRemark());
                orderDto.getAdjustmentOrderDetailDtos().add(detailDto);
            });
            reqDtoList.add(orderDto);
        });
        Integer integer = (Integer)this.inventoryAdjustmentOrderApiProxy.insertBatch(reqDtoList).getData();
        log.info("\u5e93\u5b58\u8c03\u6574\u5355\u5bfc\u5165\u6210\u529f\u6570\u91cf====>>>{}", (Object)integer);
        log.info("\u5e93\u5b58\u8c03\u6574\u5355\u5bfc\u5165\u6210\u529f====>>>{}", (Object)JSON.toJSONString(reqDtoList));
    }

    private boolean verifyInventoryAdjustmentOrderImportParams(ImportInventoryAdjustmentOrderDto dto, Map<String, List<DgLogicInventoryDto>> warehouseCodeMap, Map<String, UnitDgRespDto> unitMap, Map<String, DictValueDto> specialBatchMap, Map<String, DgItemSkuDetailRespDto> itemSkuDgRespDtoMap, Map<String, UnitDgRespDto> unitCodeMap) {
        List<DgLogicInventoryDto> logicInventoryDtoList = warehouseCodeMap.get(dto.getWarehouseCode());
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseCode())) {
            dto.setErrorMsg("\u903b\u8f91\u4ed3\u7f16\u7801\u672a\u586b\u5199");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessType())) {
            dto.setErrorMsg("\u4e1a\u52a1\u7c7b\u578b\u672a\u586b\u5199");
            return false;
        }
        AdjustmentBusinessTypeEnum typeEnum = AdjustmentBusinessTypeEnum.getEnumByDesc((String)dto.getBusinessType());
        if (typeEnum == null) {
            dto.setErrorMsg("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
            return false;
        }
        dto.setBusinessType(typeEnum.getType());
        if (StringUtils.isBlank((CharSequence)dto.getSkuCode())) {
            dto.setErrorMsg("sku\u7f16\u7801\u672a\u586b\u5199");
            return false;
        }
        if (!(!StringUtils.isNotBlank((CharSequence)dto.getInventoryProperty()) || dto.getInventoryProperty().equals("\u5f85\u68c0") || dto.getInventoryProperty().equals("\u6b8b\u6b21") || dto.getInventoryProperty().equals("\u6b63\u54c1") || dto.getInventoryProperty().equals("\u51bb\u7ed3"))) {
            dto.setErrorMsg("\u5e93\u5b58\u72b6\u6001\u4e0d\u5b58\u5728");
            return false;
        }
        if (!InventoryConfig.isNoneBatch()) {
            if (StringUtils.isBlank((CharSequence)dto.getBatch())) {
                dto.setErrorMsg("\u6279\u6b21\u672a\u586b\u5199");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)dto.getProduceTime())) {
                dto.setErrorMsg("\u65b0\u589e\u6279\u6b21\u7684\u751f\u4ea7\u65e5\u671f\u672a\u586b\u5199");
                return false;
            }
            if (!dto.getProduceTime().matches("\\d{4}/\\d{2}/\\d{2}")) {
                dto.setErrorMsg("\u751f\u4ea7\u65e5\u671f\u4e0d\u7b26\u5408\u201cYYYY/MM/DD\u201d\u7684\u683c\u5f0f\uff0c\u8bf7\u8c03\u6574");
                return false;
            }
        }
        if (StringUtils.isBlank((CharSequence)dto.getAdjustmentType())) {
            dto.setErrorMsg("\u8c03\u6574\u7c7b\u578b\u672a\u586b\u5199");
            return false;
        }
        if (!"\u589e\u52a0".equals(dto.getAdjustmentType()) && !"\u51cf\u5c11".equals(dto.getAdjustmentType())) {
            dto.setErrorMsg("\u8c03\u6574\u7c7b\u578b\u4e0d\u5b58\u5728");
            return false;
        }
        DgItemSkuDetailRespDto itemSkuDgRespDto = itemSkuDgRespDtoMap.get(dto.getSkuCode());
        if (StringUtils.isBlank((CharSequence)dto.getChangeQuantity())) {
            dto.setErrorMsg("\u8c03\u6574\u6570\u91cf\u672a\u586b\u5199");
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.getUnit()) && Objects.nonNull(itemSkuDgRespDto) && Objects.nonNull(unitCodeMap.get(itemSkuDgRespDto.getUnit()))) {
            dto.setUnit(unitCodeMap.get(itemSkuDgRespDto.getUnit()).getName());
        }
        if (OcsConfig.isUnitConversion()) {
            if (StringUtils.isBlank((CharSequence)dto.getUnit())) {
                dto.setErrorMsg("\u5355\u4f4d\u672a\u586b\u5199");
                return false;
            }
            UnitDgRespDto unitDgRespDto = unitMap.get(dto.getUnit());
            if (unitDgRespDto.getDecimalLimit() == 0 && !dto.getChangeQuantity().matches("\\d+")) {
                dto.setErrorMsg("SKU\u7f16\u7801" + dto.getSkuCode() + "\u7684\u8c03\u6574\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
                return false;
            }
            if (unitDgRespDto.getDecimalLimit() != 0 && !dto.getChangeQuantity().matches("^\\d+(\\.\\d{1," + unitDgRespDto.getDecimalLimit() + "})?$")) {
                dto.setErrorMsg("SKU\u7f16\u7801" + dto.getSkuCode() + "\u7684\u8c03\u6574\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6570\uff0c\u4e14\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u8d85\u8fc7" + unitDgRespDto.getDecimalLimit() + "\u4f4d");
                return false;
            }
        } else {
            dto.setUnit((String)ObjectUtils.defaultIfNull((Object)dto.getUnit(), (Object)"pcs"));
            if (!dto.getChangeQuantity().matches("\\d+")) {
                dto.setErrorMsg("\u8c03\u6574\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
                return false;
            }
            if (Integer.parseInt(dto.getChangeQuantity()) > 10000000) {
                dto.setErrorMsg("\u8c03\u6574\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc77\u4f4d");
                return false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRemark()) && dto.getRemark().length() > 200) {
            dto.setErrorMsg("\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7200\u4e2a\u5b57\u7b26");
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBizDate()) && !dto.getBizDate().matches("\\d{4}/\\d{2}/\\d{2}")) {
            dto.setErrorMsg("\u4e1a\u52a1\u65e5\u671f\u4e0d\u7b26\u5408\u201cYYYY/MM/DD\u201d\u7684\u683c\u5f0f\uff0c\u8bf7\u8c03\u6574");
            return false;
        }
        dto.setBizDate(DateUtil.getDateFormat((Date)new Date(), (String)"yyyy/MM/dd"));
        if (CollectionUtils.isNotEmpty(logicInventoryDtoList)) {
            dto.setWarehouseName(logicInventoryDtoList.get(0).getWarehouseName());
            dto.setOrganizationCode(logicInventoryDtoList.get(0).getOrganizationCode());
            dto.setOrganizationName(logicInventoryDtoList.get(0).getOrganizationName());
            dto.setPhysicsWarehouseCode(logicInventoryDtoList.get(0).getPhysicsWarehouseCode());
            dto.setPhysicsWarehouseName(logicInventoryDtoList.get(0).getPhysicsWarehouseName());
        }
        if (AdjustmentBusinessTypeEnum.INVENTORY_PROFIT_LOSS.getDesc().equals(dto.getBusinessType())) {
            dto.setPushErp(Integer.valueOf(1));
            dto.setPushWms(Integer.valueOf(1));
        } else {
            dto.setPushErp(Integer.valueOf(0));
            dto.setPushWms(Integer.valueOf(0));
        }
        switch (dto.getInventoryProperty()) {
            case "\u6b8b\u6b21": {
                dto.setInventoryProperty(LogicWarehouseQualityEnum.UN_QUALIFIED.getCode());
                break;
            }
            case "\u5f85\u68c0": {
                dto.setInventoryProperty(LogicWarehouseQualityEnum.WAIT_INSPECTION.getCode());
                break;
            }
            case "\u51bb\u7ed3": {
                dto.setInventoryProperty(LogicWarehouseQualityEnum.FREEZE.getCode());
                break;
            }
            default: {
                dto.setInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
            }
        }
        dto.setAdjustmentType(dto.getAdjustmentType().equals("\u589e\u52a0") ? "increase" : "decrease");
        return true;
    }
}

