/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.BaseOrderAddressDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BaseOrderAddressPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutResultOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.entity.IBaseOrderAddressApiProxy;
import com.yunxi.dg.base.center.logistics.dto.entity.LogisticsInfoDto;
import com.yunxi.dg.base.center.logistics.proxy.entity.ILogisticsInfoApiProxy;
import com.yunxi.dg.base.center.openapi.dto.request.StdLogisticsInfoReqDto;
import com.yunxi.dg.base.center.openapi.proxy.kuaidi100.IKuaidi100ApiProxy;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.proxy.order.IPerformOrderQueryApiProxy;
import com.yunxi.dg.base.center.transform.dto.request.TrLogisticsMappingRelationReqDto;
import com.yunxi.dg.base.center.transform.dto.response.TrLogisticsMappingRelationRespDto;
import com.yunxi.dg.base.center.transform.proxy.query.ITrLogisticsMappingRelationQueryApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.service.IOcsLogisticsService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.ReceiveDeliveryResultOrderDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OcsLogisticsServiceImpl
implements IOcsLogisticsService {
    private static final Logger logger = LoggerFactory.getLogger(OcsLogisticsServiceImpl.class);
    @Resource
    private ILogisticsInfoApiProxy logisticsInfoApiProxy;
    @Resource
    private IKuaidi100ApiProxy kuaidi100ApiProxy;
    @Resource
    private IPerformOrderQueryApiProxy performOrderQueryApiProxy;
    @Resource
    private IBaseOrderAddressApiProxy baseOrderAddressApiProxy;
    @Resource
    private ITrLogisticsMappingRelationQueryApiProxy logisticsMappingRelationQueryApiProxy;
    @Resource
    private IInOutResultOrderApiProxy inOutResultOrderApiProxy;

    @Override
    public void saveLogisticsByResultOrder(ReceiveDeliveryResultOrderDto resultOrderDto) {
        logger.info("\u4fdd\u5b58\u7269\u6d41\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)resultOrderDto));
        LogisticsInfoDto logisticsInfoDto = new LogisticsInfoDto();
        logisticsInfoDto.setBusinessOrderNo(resultOrderDto.getRelevanceNo());
        logisticsInfoDto.setBusinessType(resultOrderDto.getRelevanceTableName());
        logisticsInfoDto.setLogisticsOrderNo(resultOrderDto.getShippingCode());
        logisticsInfoDto.setLogisticsCompanyName(resultOrderDto.getShippingCompany());
        logisticsInfoDto.setLogisticsCompanyCode(resultOrderDto.getShippingCompanyCode());
        logisticsInfoDto.setDeliveryWarehouseCode(resultOrderDto.getDeliveryLogicWarehouseCode());
        logisticsInfoDto.setDeliveryWarehouseName(resultOrderDto.getDeliveryLogicWarehouseName());
        logisticsInfoDto.setTotalQuantity(resultOrderDto.getTotalQuantity());
        InOutResultOrderPageReqDto pageReqDto = new InOutResultOrderPageReqDto();
        pageReqDto.setRelevanceNo(resultOrderDto.getRelevanceNo());
        pageReqDto.setOrderType("out");
        pageReqDto.setPageNum(Integer.valueOf(1));
        pageReqDto.setPageSize(Integer.valueOf(1));
        logger.info("\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\uff1a{}", (Object)JSON.toJSONString((Object)pageReqDto));
        PageInfo inOutResultOrderDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inOutResultOrderApiProxy.page(pageReqDto));
        if (CollectionUtil.isNotEmpty((Collection)inOutResultOrderDtoPageInfo.getList())) {
            InOutResultOrderDto orderDto = (InOutResultOrderDto)inOutResultOrderDtoPageInfo.getList().get(0);
            logisticsInfoDto.setScanTime(ObjectUtil.isNotEmpty((Object)orderDto.getInOutTime()) ? orderDto.getInOutTime() : orderDto.getCreateTime());
        }
        Optional.ofNullable(resultOrderDto.getRelevanceTableName()).ifPresent(tableName -> {
            if (tableName.equals("cs_order_sale") && resultOrderDto.getRelevanceNo().contains("DD")) {
                DgBizPerformOrderRespDto performOrder = (DgBizPerformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.performOrderQueryApiProxy.queryByOrderNo(resultOrderDto.getRelevanceNo()));
                if (ObjectUtil.isNotEmpty((Object)performOrder) && ObjectUtil.isNotEmpty((Object)performOrder.getPerformOrderSnapshotDto())) {
                    logisticsInfoDto.setShopCode(performOrder.getPerformOrderSnapshotDto().getShopCode());
                    logisticsInfoDto.setShopName(performOrder.getPerformOrderSnapshotDto().getShopName());
                }
                if (ObjectUtil.isNotEmpty((Object)performOrder) && ObjectUtil.isNotEmpty((Object)performOrder.getPerformOrderWarehouseInfoDto())) {
                    logisticsInfoDto.setTransportTypeCode(performOrder.getPerformOrderWarehouseInfoDto().getTransportTypeCode());
                    logisticsInfoDto.setTransportTypeName(performOrder.getPerformOrderWarehouseInfoDto().getTransportTypeName());
                    logisticsInfoDto.setTransportStyle(performOrder.getPerformOrderWarehouseInfoDto().getTransportStyle());
                }
                if (ObjectUtil.isNotEmpty((Object)performOrder) && ObjectUtil.isNotEmpty((Object)performOrder.getItemList())) {
                    BigDecimal totalVolume = BigDecimal.ZERO;
                    BigDecimal totalWeight = BigDecimal.ZERO;
                    for (DgPerformOrderItemExtRespDto detail : performOrder.getItemList()) {
                        totalVolume = totalVolume.add(detail.getVolume() != null ? detail.getVolume() : BigDecimal.ZERO);
                        totalWeight = totalWeight.add(detail.getWeight() != null ? detail.getWeight() : BigDecimal.ZERO);
                    }
                    logisticsInfoDto.setTotalVolume(totalVolume);
                    logisticsInfoDto.setTotalWeight(totalWeight);
                }
            }
        });
        BaseOrderAddressPageReqDto addressPageReqDto = new BaseOrderAddressPageReqDto();
        addressPageReqDto.setDocumentNo(resultOrderDto.getRelevanceNo());
        addressPageReqDto.setContactsType("consignee");
        addressPageReqDto.setPageNum(Integer.valueOf(1));
        addressPageReqDto.setPageSize(Integer.valueOf(1));
        PageInfo addressDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.baseOrderAddressApiProxy.page(addressPageReqDto));
        Optional.ofNullable(addressDtoPageInfo.getList()).ifPresent(list -> {
            BaseOrderAddressDto addressDto = (BaseOrderAddressDto)list.get(0);
            logisticsInfoDto.setProvince(addressDto.getProvince());
            logisticsInfoDto.setProvinceCode(addressDto.getProvinceCode());
            logisticsInfoDto.setCity(addressDto.getCity());
            logisticsInfoDto.setCityCode(addressDto.getCityCode());
            logisticsInfoDto.setArea(addressDto.getDistrict());
            logisticsInfoDto.setAreaCode(addressDto.getDistrictCode());
        });
        logger.info("\u4fdd\u5b58\u7269\u6d41\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)logisticsInfoDto));
        RestResponseHelper.extractData((RestResponse)this.logisticsInfoApiProxy.insert(logisticsInfoDto));
    }

    @Override
    public void subscribe(String logisticsOrder, String logisticsCompany, String phoneNum) {
        logger.info("\u7269\u6d41\u8f68\u8ff9\u8ba2\u9605\uff1a{}\uff0c{}", (Object)logisticsOrder, (Object)logisticsCompany);
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)logisticsOrder), (String)"\u7269\u6d41\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)logisticsCompany), (String)"\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        StdLogisticsInfoReqDto subscribeReqDto = new StdLogisticsInfoReqDto();
        TrLogisticsMappingRelationReqDto relationReqDto = new TrLogisticsMappingRelationReqDto();
        relationReqDto.setLogisticsCode(logisticsCompany);
        relationReqDto.setSiteCode("kuaidi100");
        logger.info("\u5339\u914d\u5feb\u9012100\u5bf9\u5e94\u7684\u7269\u6d41\u516c\u53f8\u7f16\u7801\uff1a{}", (Object)JSON.toJSONString((Object)relationReqDto));
        TrLogisticsMappingRelationRespDto relationRespDto = (TrLogisticsMappingRelationRespDto)RestResponseHelper.extractData((RestResponse)this.logisticsMappingRelationQueryApiProxy.queryByRelationReqDtoSiteMatching(relationReqDto));
        AssertUtils.isFalse((ObjectUtil.isEmpty((Object)relationRespDto) || StringUtils.isBlank((CharSequence)relationRespDto.getExternalLogisticsCode()) ? 1 : 0) != 0, (String)("\u627e\u4e0d\u5230\u5feb\u9012100\u6e20\u9053\u7684\u7269\u6d41\u5546\u7f16\u7801\uff1a" + logisticsCompany));
        logger.info("\u5339\u914d\u5feb\u9012100\u5bf9\u5e94\u7684\u7269\u6d41\u516c\u53f8\u7f16\u7801\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)relationRespDto));
        subscribeReqDto.setLogisticsCode(relationRespDto.getExternalLogisticsCode());
        subscribeReqDto.setExpressCode(logisticsOrder);
        subscribeReqDto.setPhoneNum(phoneNum);
        logger.info("\u7269\u6d41\u8f68\u8ff9\u8ba2\u9605\uff1a{}", (Object)JSON.toJSONString((Object)subscribeReqDto));
        RestResponseHelper.extractData((RestResponse)this.kuaidi100ApiProxy.logisticsTrackSubscribe(subscribeReqDto));
    }
}

