/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.dto.entity.DgChannelWarehouseDto;
import com.yunxi.dg.base.center.share.dto.entity.DgChannelWarehousePageReqDto;
import com.yunxi.dg.base.center.share.dto.entity.SeparateRuleChannelSkuDto;
import com.yunxi.dg.base.center.share.dto.entity.SeparateRuleChannelSkuPageReqDto;
import com.yunxi.dg.base.center.share.proxy.rule.ISeparateRuleChannelSkuApiProxy;
import com.yunxi.dg.base.center.share.proxy.warehouse.IDgChannelWarehouseApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportSarNumberConfigurationModeDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ExportSarNumberConfigurationRespDto;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_sar_number_configuration")
public class SarNumberConfigurationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(SarNumberConfigurationCommonServiceImpl.class);
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private ISeparateRuleChannelSkuApiProxy separateRuleChannelSkuApiProxy;
    @Resource
    private IDgChannelWarehouseApiProxy channelWarehouseApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u5206\u4ed3\u6570\u91cf\u914d\u7f6e");
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList<ImportSarNumberConfigurationModeDto> passList = new ArrayList<ImportSarNumberConfigurationModeDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportSarNumberConfigurationModeDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u5206\u4ed3\u6570\u91cf\u914d\u7f6e,\u5bfc\u5165\u5206\u4ed3\u6570\u91cf\u914d\u7f6e\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        List itemSkuDetailDtoList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.querySkuList(new ItemQueryDgReqDto()))).orElse(new ArrayList());
        Map<String, DgItemSkuDetailRespDto> itemSkuMap = itemSkuDetailDtoList.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (o1, o2) -> o1));
        List separateRuleChannelSkuDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.separateRuleChannelSkuApiProxy.list(new SeparateRuleChannelSkuPageReqDto()))).orElse(new ArrayList());
        Map<String, SeparateRuleChannelSkuDto> separateRuleChannelSkuDtoMap = separateRuleChannelSkuDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + o.getWarehouseCode(), Function.identity(), (e1, e2) -> e1));
        List channelWarehouseDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.channelWarehouseApiProxy.list(new DgChannelWarehousePageReqDto()))).orElse(new ArrayList());
        Map<String, String> channelWarehouseMap = channelWarehouseDtos.stream().collect(Collectors.toMap(DgChannelWarehouseDto::getWarehouseCode, DgChannelWarehouseDto::getWarehouseName, (o1, o2) -> o1));
        for (ImportSarNumberConfigurationModeDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, itemSkuMap, separateRuleChannelSkuDtoMap, channelWarehouseMap);
            if (!isPass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        log.info("\u5bfc\u5165\u5206\u4ed3\u6570\u91cf\u914d\u7f6e\u6570\u636e:{}", (Object)JSON.toJSONString((Object)passList));
        List separateRuleChannelSkuDtos = BeanUtil.copyToList((Collection)passList, SeparateRuleChannelSkuDto.class);
        this.separateRuleChannelSkuApiProxy.batchInsert(separateRuleChannelSkuDtos);
    }

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        log.info("\u5206\u4ed3\u6570\u91cf\u914d\u7f6e\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        AssertUtils.isTrue((boolean)FileModeTypeEnum.SAR_NUMBER_CONFIGURATION.getKey().equals(key), (String)"\u4e1a\u52a1key\u6709\u8bef");
        SeparateRuleChannelSkuPageReqDto reqDto = new SeparateRuleChannelSkuPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            reqDto = (SeparateRuleChannelSkuPageReqDto)JSON.parseObject((String)filter, SeparateRuleChannelSkuPageReqDto.class);
        }
        List pageData = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.separateRuleChannelSkuApiProxy.page(reqDto))).getList();
        ArrayList<ExportSarNumberConfigurationRespDto> list = new ArrayList<ExportSarNumberConfigurationRespDto>();
        Integer num = 1;
        for (SeparateRuleChannelSkuDto dto : pageData) {
            ExportSarNumberConfigurationRespDto exportSarNumberConfigurationRespDto = (ExportSarNumberConfigurationRespDto)BeanUtil.copyProperties((Object)dto, ExportSarNumberConfigurationRespDto.class, (String[])new String[0]);
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
            exportSarNumberConfigurationRespDto.setNumber(n);
            exportSarNumberConfigurationRespDto.setSarQuantity(Integer.valueOf(dto.getSarQuantity().intValue()));
            exportSarNumberConfigurationRespDto.setCreateTime(DateUtil.formatDateTime((Date)dto.getCreateTime()));
            exportSarNumberConfigurationRespDto.setUpdateTime(DateUtil.formatDateTime((Date)dto.getUpdateTime()));
            list.add(exportSarNumberConfigurationRespDto);
        }
        log.info("\u5206\u4ed3\u6570\u91cf\u914d\u7f6e\u5bfc\u51fa\u5927\u5c0f:{}", (Object)list.size());
        return list;
    }

    private boolean paramVerify(ImportSarNumberConfigurationModeDto dto, Map<String, DgItemSkuDetailRespDto> itemSkuMap, Map<String, SeparateRuleChannelSkuDto> separateRuleChannelSkuDtoMap, Map<String, String> channelWarehouseMap) {
        if (StringUtils.isBlank((CharSequence)dto.getSkuCode())) {
            this.setErrorMsg(dto, "\u9009\u9879SKU\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!itemSkuMap.containsKey(dto.getSkuCode())) {
            this.setErrorMsg(dto, "\u8be5\u5546\u54c1\u4e0d\u5b58\u5728");
            return false;
        }
        dto.setSkuName(itemSkuMap.get(dto.getSkuCode()).getSkuName());
        if (StringUtils.isBlank((CharSequence)dto.getWarehouseCode())) {
            this.setErrorMsg(dto, "\u9009\u9879\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!channelWarehouseMap.containsKey(dto.getWarehouseCode())) {
            this.setErrorMsg(dto, "\u6e20\u9053\u7f16\u7801:" + dto.getWarehouseCode() + "\u4e0d\u5b58\u5728");
            return false;
        }
        if (separateRuleChannelSkuDtoMap.containsKey(dto.getSkuCode() + dto.getWarehouseCode())) {
            this.setErrorMsg(dto, "\u6e20\u9053" + dto.getWarehouseCode() + "\u4e2d\u5df2\u5b58\u5728\u5546\u54c1:" + dto.getSkuCode());
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getWarehouseName()) && !channelWarehouseMap.get(dto.getWarehouseCode()).equals(dto.getWarehouseName())) {
            this.setErrorMsg(dto, dto.getWarehouseName() + "\u6e20\u9053\u4e0d\u5b58\u5728");
            return false;
        }
        dto.setWarehouseName(channelWarehouseMap.get(dto.getWarehouseCode()));
        if (Objects.isNull(dto.getSarQuantity())) {
            this.setErrorMsg(dto, "\u9009\u9879SAR\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!dto.getSarQuantity().toString().matches("^[1-9]\\d*$")) {
            this.setErrorMsg(dto, "SAR\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
            return false;
        }
        return true;
    }

    private String setErrorMsg(ImportSarNumberConfigurationModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }
}

