/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.report.proxy.aftersale.IDgSmallRefundOrderApiProxy;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.trade.IDgB2CAfterSaleStatemachineApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.SmallRefundReimbursementOrderImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_small_refund_reimbursement_order_import")
public class SmallRefundReimbursementOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(SmallRefundReimbursementOrderCommonServiceImpl.class);
    @Resource
    private IDgSmallRefundOrderApiProxy idgSmallRefundOrderApiProxy;
    @Resource
    private IDgB2CAfterSaleStatemachineApiProxy idgB2CAfterSaleStatemachineApiProxy;
    @Resource
    private IDgAfterSaleOrderApiProxy dgAfterSaleOrderApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5c0f\u989d\u9000\u6b3e\u62a5\u9500\u5355\u53f7\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        List resultList = BeanUtil.copyToList((Collection)result.getList(), SmallRefundReimbursementOrderImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            throw new BizException("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ArrayList passList = Lists.newArrayList();
        for (SmallRefundReimbursementOrderImportDto importDto : resultList) {
            boolean isUnPass = this.checkAndInitParam(importDto);
            if (isUnPass) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        log.info("\u6253\u5370\u5c0f\u989d\u9000\u6b3e\u67e5\u8be2\u8ba2\u5355\u4fe1\u606fpassList\uff1a{}", (Object)JSONObject.toJSONString((Object)passList));
        respDto.setDetails((List)passList);
        Collections.sort(respDto.getErrorDetails(), Comparator.comparingInt(ImportBaseModeDto::getRowNum));
        return passList;
    }

    public boolean checkAndInitParam(SmallRefundReimbursementOrderImportDto importDto) {
        log.info("\u5f00\u59cb\u6821\u9a8c\u6570\u636e");
        StringBuffer errorMsg = new StringBuffer();
        boolean flag = true;
        if (null == importDto.getRefundOrderNo()) {
            errorMsg.append("\u9000\u6b3e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            flag = false;
        }
        if (null == importDto.getReimbursementOrderNo()) {
            errorMsg.append("\u62a5\u9500\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            flag = false;
        }
        if (flag) {
            boolean startsWithAF = importDto.getRefundOrderNo().startsWith("AF");
            if (!startsWithAF) {
                errorMsg.append("\u672a\u5339\u914d\u5230\u9000\u6b3e\u5355\u53f7\uff1b");
            } else {
                DgAfterSaleOrderRespDto respDto = (DgAfterSaleOrderRespDto)this.idgSmallRefundOrderApiProxy.queryBySaleOrderNo(importDto.getRefundOrderNo()).getData();
                if (null == respDto) {
                    errorMsg.append("\u672a\u5339\u914d\u5230\u9000\u6b3e\u5355\u53f7\uff1b");
                } else {
                    if (null != respDto.getStatus() && !Objects.equals(respDto.getStatus(), "FINISH")) {
                        errorMsg.append("\u5355\u636e\u672a\u5b8c\u6210,\u65e0\u6cd5\u5bfc\u5165\uff1b");
                    }
                    if (null != respDto.getReimbursementStatus() && Objects.equals(respDto.getReimbursementStatus(), 1)) {
                        errorMsg.append("\u5355\u636e\u5df2\u6838\u9500,\u65e0\u6cd5\u5bfc\u5165\uff1b");
                    }
                }
                CubeBeanUtils.copyProperties((Object)importDto, (Object)respDto, (String[])new String[0]);
                log.info("\u5c0f\u989d\u9000\u6b3e\u62a5\u9500\u5355\u53f7\u6821\u9a8c\u5b8c\u6210\u540e\u7684\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)importDto));
            }
        }
        importDto.setErrorMsg(errorMsg.toString());
        log.info("\u5c0f\u989d\u9000\u6b3e\u62a5\u9500\u5355\u53f7\u5bfc\u5165\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)errorMsg));
        return errorMsg.length() > 0;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("\u5c0f\u989d\u9000\u6b3e\u62a5\u9500\u5355\u53f7-callBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u5904\u7406\u66f4\u65b0\u64cd\u4f5c");
        for (SmallRefundReimbursementOrderImportDto dto : passList) {
            DgAfterSaleOrderReqDto updateDto = new DgAfterSaleOrderReqDto();
            CubeBeanUtils.copyProperties((Object)updateDto, (Object)dto, (String[])new String[0]);
            updateDto.setReimbursementOrderNo(dto.getReimbursementOrderNo());
            log.info("\u8fdb\u884c\u66f4\u65b0\u7684\u6570\u636e:{}", (Object)updateDto);
            this.dgAfterSaleOrderApiProxy.updateReimbursement(updateDto);
            log.info("\u66f4\u65b0\u7ed3\u675f");
        }
        Collections.sort(respDto.getErrorDetails(), Comparator.comparingInt(ImportBaseModeDto::getRowNum));
        log.info("\u9519\u8bef\u65e5\u5fd7\u6253\u53702\uff1a{}", (Object)JSONObject.toJSONString((Object)respDto.getErrorDetails()));
    }

    private void setErrorMsg(SmallRefundReimbursementOrderImportDto dto, String msg) {
        dto.setErrorMsg(StringUtils.isBlank((CharSequence)dto.getErrorMsg()) ? String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef\uff0c%s", dto.getRowNum() + 1, msg) : dto.getErrorMsg() + ";" + msg);
    }
}

